<?php
/**
 * The template part for displaying Post
 * @package Ultimate Ecommerce Shop 
 * @subpackage ultimate_ecommerce_shop
 * @since 1.0
 */
?>
<?php 
  $ultimate_ecommerce_shop_archive_year  = get_the_time('Y'); 
  $ultimate_ecommerce_shop_archive_month = get_the_time('m'); 
  $ultimate_ecommerce_shop_archive_day   = get_the_time('d'); 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="post-wrap mb-4">
    <div class="box-image">
      <?php 
        if(has_post_thumbnail()) {
          the_post_thumbnail(); ?>
      <?php }?>
    </div>    
    <div class="post-main p-2">
      <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
      <div class="adminbox py-2">  
        <span class="entry-date me-3"><i class="far fa-calendar-alt me-2"></i><a href="<?php echo esc_url( get_day_link( $ultimate_ecommerce_shop_archive_year, $ultimate_ecommerce_shop_archive_month, $ultimate_ecommerce_shop_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span>
        <span class="entry-author me-3"><i class="fas fa-user me-2"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span>
        <span class="entry-comments me-3"><i class="far fa-comments me-2"></i><?php comments_number( __('0 Comment', 'ultimate-ecommerce-shop'), __('0 Comments', 'ultimate-ecommerce-shop'), __('% Comments', 'ultimate-ecommerce-shop') ); ?></span>
      </div>  
      <div class="entry-content"><p><?php the_excerpt();?></p></div>
      <div class="continue-read mt-3">
        <a href="<?php the_permalink(); ?>"><span><?php esc_html_e('READ MORE...','ultimate-ecommerce-shop'); ?></span><span class="screen-reader-text"><?php esc_html_e( 'READ MORE...','ultimate-ecommerce-shop');?></span></a>
      </div>
    </div>
  </div>
</article>