<?php
/**
 * Ultimate Ecommerce Shop Theme Customizer
 *
 * @package Ultimate Ecommerce Shop
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function ultimate_ecommerce_shop_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'ultimate_ecommerce_shop_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'LT Settings', 'ultimate-ecommerce-shop' ),
	    'description' => __( 'Description of what this panel does.', 'ultimate-ecommerce-shop' ),
	) );

	$wp_customize->add_section( 'ultimate_ecommerce_shop_left_right' , array(
    	'title'      => __( 'General Settings', 'ultimate-ecommerce-shop' ),
		'priority'   => 30,
		'panel' => 'ultimate_ecommerce_shop_panel_id'
	) );
    
    //Select width layout
    $wp_customize->add_setting('ultimate_ecommerce_shop_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','ultimate-ecommerce-shop'),
        'section' => 'ultimate_ecommerce_shop_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','ultimate-ecommerce-shop'),
            'Contained Width' => esc_html__('Contained Width','ultimate-ecommerce-shop'),
            'Boxed Width' => esc_html__('Boxed Width','ultimate-ecommerce-shop'),
        ),
	) );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('ultimate_ecommerce_shop_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'	        
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_theme_options',
	    array(
	        'type' => 'radio',
	        'description' => __( 'Choose sidebar between different options', 'ultimate-ecommerce-shop' ),
	        'label' => __( 'Post Sidebar Layout', 'ultimate-ecommerce-shop' ),
	        'section' => 'ultimate_ecommerce_shop_left_right',
	        'choices' => array(
	            'One Column' => __('One Column ','ultimate-ecommerce-shop'),
	            'Three Columns' => __('Three Columns','ultimate-ecommerce-shop'),
	            'Four Columns' => __('Four Columns','ultimate-ecommerce-shop'),
	            'Right Sidebar' => __('Right Sidebar','ultimate-ecommerce-shop'),
	            'Left Sidebar' => __('Left Sidebar','ultimate-ecommerce-shop'),
	            'Grid Layout' => __('Grid Layout','ultimate-ecommerce-shop')
	        ),
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_dropdown_anim', array(
		'section'  => 'ultimate_ecommerce_shop_left_right',
		'label'    => __( 'Submenu Dropdown Effect','ultimate-ecommerce-shop'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'ultimate-ecommerce-shop'),
			'zoomIn' => __('zoomIn', 'ultimate-ecommerce-shop'),
			'flip-up' => __('flip-up', 'ultimate-ecommerce-shop'),
			'none' => __('none', 'ultimate-ecommerce-shop')
		)
	));

	$ultimate_ecommerce_shop_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Kavoon' =>'Kavoon',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'ultimate_ecommerce_shop_typography', array(
    	'title'      => __( 'Typography', 'ultimate-ecommerce-shop' ),
		'priority'   => 30,
		'panel' => 'ultimate_ecommerce_shop_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_paragraph_color', array(
		'label' => __('Paragraph Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_paragraph_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'Paragraph Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_paragraph_font_size',array(
		'default'	=> '12px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_atag_color', array(
		'label' => __('"a" Tag Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_atag_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( '"a" Tag Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_li_color', array(
		'label' => __('"li" Tag Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_li_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( '"li" Tag Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h1_color', array(
		'label' => __('H1 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h1_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'H1 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h1_font_size',array(
		'default'	=> '50px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h1_font_size',array(
		'label'	=> __('H1 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h2_color', array(
		'label' => __('h2 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h2_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'h2 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h2_font_size',array(
		'default'	=> '45px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h2_font_size',array(
		'label'	=> __('h2 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h3_color', array(
		'label' => __('h3 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h3_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'h3 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h3_font_size',array(
		'default'	=> '36px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h3_font_size',array(
		'label'	=> __('h3 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h4_color', array(
		'label' => __('h4 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h4_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'h4 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h4_font_size',array(
		'default'	=> '30px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h4_font_size',array(
		'label'	=> __('h4 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h5_color', array(
		'label' => __('h5 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h5_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'h5 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h5_font_size',array(
		'default'	=> '25px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h5_font_size',array(
		'label'	=> __('h5 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_h6_color', array(
		'label' => __('h6 Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_typography',
		'settings' => 'ultimate_ecommerce_shop_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control(
	    'ultimate_ecommerce_shop_h6_font_family', array(
	    'section'  => 'ultimate_ecommerce_shop_typography',
	    'label'    => __( 'h6 Fonts','ultimate-ecommerce-shop'),
	    'type'     => 'select',
	    'choices'  => $ultimate_ecommerce_shop_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('ultimate_ecommerce_shop_h6_font_size',array(
		'default'	=> '18px',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_h6_font_size',array(
		'label'	=> __('h6 Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_typography',
		'setting'	=> 'ultimate_ecommerce_shop_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('ultimate_ecommerce_shop_topbar',array(
		'title'	=> __('Topbar','ultimate-ecommerce-shop'),
		'description'	=> __('Add Topbar Content here','ultimate-ecommerce-shop'),
		'priority'	=> null,
		'panel' => 'ultimate_ecommerce_shop_panel_id',
	));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_checkbox'
    ) );
    $wp_customize->add_control('ultimate_ecommerce_shop_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'ultimate-ecommerce-shop' ),
        'label' => __( 'Sticky Header','ultimate-ecommerce-shop' ),
        'section' => 'ultimate_ecommerce_shop_topbar'
    ));

    //Show /Hide Topbar
	$wp_customize->add_setting( 'ultimate_ecommerce_shop_show_topbar',array(
		'default' => false,
      	'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_checkbox'
    ) );
    $wp_customize->add_control('ultimate_ecommerce_shop_show_topbar',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable Topbar.', 'ultimate-ecommerce-shop' ),
        'label' => __( 'Topbar','ultimate-ecommerce-shop' ),
        'section' => 'ultimate_ecommerce_shop_topbar'
    ));

	$wp_customize->add_setting('ultimate_ecommerce_shop_discount_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_discount_text',array(
		'label'	=> __('Add Discount Text','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_topbar',
		'setting'	=> 'ultimate_ecommerce_shop_discount_text',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_call_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_call_text',array(
		'label'	=> __('Add Call Text','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_topbar',
		'setting'	=> 'ultimate_ecommerce_shop_call_text',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_call',array(
		'default'	=> '',
		'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_phone_number'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_call',array(
		'label'	=> __('Add Phone Number','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_topbar',
		'setting'	=> 'ultimate_ecommerce_shop_call',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_mail_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_mail_text',array(
		'label'	=> __('Add Email Text','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_topbar',
		'setting'	=> 'ultimate_ecommerce_shop_mail_text',
		'type'		=> 'text'
	));	

	$wp_customize->add_setting('ultimate_ecommerce_shop_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_mail',array(
		'label'	=> __('Add Email','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_topbar',
		'setting'	=> 'ultimate_ecommerce_shop_mail',
		'type'		=> 'text'
	));	

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_disc_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_disc_color', array(
		'label' => __('Discount Text Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_disc_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_epicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_epicon_color', array(
		'label' => __('Email/Phone Icon Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_epicon_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_eptitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_eptitle_color', array(
		'label' => __('Email/Phone Title Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_eptitle_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_eptext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_eptext_color', array(
		'label' => __('Email/Phone Text Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_eptext_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_menu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_menu_color', array(
		'label' => __('Menus Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_menu_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_menuhvr_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_menuhvr_color', array(
		'label' => __('Menus Hover Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_menuhvr_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_submenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_submenu_color', array(
		'label' => __('Submenus Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_submenu_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_submenuhvr_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_submenuhvr_color', array(
		'label' => __('Submenus Hover Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_submenuhvr_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_icon_color', array(
		'label' => __('Icon Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_icon_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_iconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_iconbg_color', array(
		'label' => __('Icon Bg Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_topbar',
		'settings' => 'ultimate_ecommerce_shop_iconbg_color',
	)));
	
	//home page slider
	$wp_customize->add_section( 'ultimate_ecommerce_shop_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'ultimate-ecommerce-shop' ),
		'priority'   => null,
		'panel' => 'ultimate_ecommerce_shop_panel_id'
	) );

	$wp_customize->add_setting('ultimate_ecommerce_shop_slider_hide',array(
	   'default' => false,
	   'sanitize_callback'  => 'ultimate_ecommerce_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_slider_hide',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'ultimate-ecommerce-shop' ),
	   'label' => __('Show / Hide slider','ultimate-ecommerce-shop'),
	   'section' => 'ultimate_ecommerce_shop_slidersettings',
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_slider_title',array(
        'default' => true,
        'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_slider_title',array(
     	'type' => 'checkbox',
      	'label' => __('Show / Hide Slider Title','ultimate-ecommerce-shop'),
      	'section' => 'ultimate_ecommerce_shop_slidersettings',
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_slider_button',array(
        'default' => true,
        'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_slider_button',array(
     	'type' => 'checkbox',
		'description'=> __('Note : Give the image size 1600 × 600 px.','ultimate-ecommerce-shop'),
      	'label' => __('Show / Hide Slider Button','ultimate-ecommerce-shop'),
      	'section' => 'ultimate_ecommerce_shop_slidersettings',
	));

	//This is onload transaction effect
	$wp_customize->add_setting('ultimate_ecommerce_shop_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_slider_animation', array(
		'section'  => 'ultimate_ecommerce_shop_slidersettings',
		'label'    => __( 'Onload Transaction Effect','ultimate-ecommerce-shop'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'ultimate-ecommerce-shop'),
			'bounceInRight' => __('bounceInRight', 'ultimate-ecommerce-shop'),
			'bounceInUp' => __('bounceInUp', 'ultimate-ecommerce-shop'),
			'bounceInDown' => __('bounceInDown', 'ultimate-ecommerce-shop'),
			'zoomIn' => __('zoomIn', 'ultimate-ecommerce-shop'),
			'zoomOut' => __('zoomOut', 'ultimate-ecommerce-shop'),
			'fadeInLeft' => __('fadeInLeft', 'ultimate-ecommerce-shop'),
			'fadeInRight' => __('fadeInRight', 'ultimate-ecommerce-shop'),
			'fadeInUp' => __('fadeInUp', 'ultimate-ecommerce-shop'),
			'fadeInDown' => __('fadeInDown', 'ultimate-ecommerce-shop'),
			'flip-up' => __('flip-up', 'ultimate-ecommerce-shop'),
			'none' => __('none', 'ultimate-ecommerce-shop')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'ultimate_ecommerce_shop_slidersettings_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_dropdown_pages'
		) );

		$wp_customize->add_control( 'ultimate_ecommerce_shop_slidersettings_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'ultimate-ecommerce-shop' ),
			'section'  => 'ultimate_ecommerce_shop_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('ultimate_ecommerce_shop_slider_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_slider_title_font_size',array(
		'label'	=> __('Title Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_slidersettings',
		'setting'	=> 'ultimate_ecommerce_shop_slider_title_font_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_slider_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_slider_color', array(
		'label' => __('Text Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_slidersettings',
		'settings' => 'ultimate_ecommerce_shop_slider_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_sliderlink_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_sliderlink_color', array(
		'label' => __('Button Text Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_slidersettings',
		'settings' => 'ultimate_ecommerce_shop_sliderlink_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_sliderbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_sliderbg_color', array(
		'label' => __('Background Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_slidersettings',
		'settings' => 'ultimate_ecommerce_shop_sliderbg_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_slidernp_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_slidernp_color', array(
		'label' => __('Next Pre Arrow Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_slidersettings',
		'settings' => 'ultimate_ecommerce_shop_slidernp_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_slidernpbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_slidernpbg_color', array(
		'label' => __('Next Pre Arrow Bg Color', 'ultimate-ecommerce-shop'),
		'section' => 'ultimate_ecommerce_shop_slidersettings',
		'settings' => 'ultimate_ecommerce_shop_slidernpbg_color',
	)));

	//Top Products
	$wp_customize->add_section('ultimate_ecommerce_shop_top_product_sec',array(
		'title'	=> __('Top Products Section ','ultimate-ecommerce-shop'),
		'description'=> __('Note : This section will appear below the slider.','ultimate-ecommerce-shop'),
		'panel' => 'ultimate_ecommerce_shop_panel_id',
	));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_product_title', array(
		'default'           => '',
		'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_dropdown_pages'
	));
	$wp_customize->add_control( 'ultimate_ecommerce_shop_product_title', array(
		'label'    => __( 'Select Top Product Title Page', 'ultimate-ecommerce-shop' ),
		'section'  => 'ultimate_ecommerce_shop_top_product_sec',
		'type'     => 'dropdown-pages'
	));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_top_products', array(
		'default'           => '',
		'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_dropdown_pages'
	));
	$wp_customize->add_control( 'ultimate_ecommerce_shop_top_products', array(
		'label'    => __( 'Select Page', 'ultimate-ecommerce-shop' ),
		'section'  => 'ultimate_ecommerce_shop_top_product_sec',
		'type'     => 'dropdown-pages'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_shop_img_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_shop_img_size',array(
		'label'	=> __('Product Image Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_top_product_sec',
		'setting'	=> 'ultimate_ecommerce_shop_shop_img_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_shop_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_shop_title_font_size',array(
		'label'	=> __('Title Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_top_product_sec',
		'setting'	=> 'ultimate_ecommerce_shop_shop_title_font_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_shop_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_shop_text_font_size',array(
		'label'	=> __('Text Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_top_product_sec',
		'setting'	=> 'ultimate_ecommerce_shop_shop_text_font_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_product_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_product_title_font_size',array(
		'label'	=> __('Product Title Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_top_product_sec',
		'setting'	=> 'ultimate_ecommerce_shop_product_title_font_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_product_price_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_product_price_font_size',array(
		'label'	=> __('Product Price Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_top_product_sec',
		'setting'	=> 'ultimate_ecommerce_shop_product_price_font_size',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_product_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_product_title_color', array(
		'label'    => __('Top Product Page Title Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_top_product_sec',
	)));

	$wp_customize->add_setting('ultimate_ecommerce_shop_product_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_product_text_color', array(
		'label'    => __('Top Product Page Text Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_top_product_sec',
	)));
		
	//footer
	$wp_customize->add_section('ultimate_ecommerce_shop_footer_section',array(
		'title'	=> __('Footer Setting','ultimate-ecommerce-shop'),
		'description'	=> __('Add some text for footer like copyright etc.','ultimate-ecommerce-shop'),
		'panel' => 'ultimate_ecommerce_shop_panel_id'
	));

	/*Footer Background Color */
	$wp_customize->add_setting('ultimate_ecommerce_shop_footer_background_color', array(
		'default'           => '#080c15',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_footer_background_color', array(
		'label'    => __('Footer Background Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_footer_section',
	)));
	
	$wp_customize->add_setting('ultimate_ecommerce_shop_footer_copy',array(
		'default'	=> 'Ecommerce WordPress Theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_footer_copy',array(
		'label'	=> __('Copyright Text','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('ultimate_ecommerce_shop_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_footer_copy_font_size',array(
		'label'	=> __('Copyright Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_footer_section',
		'setting'	=> 'ultimate_ecommerce_shop_footer_copy_font_size',
		'type'		=> 'number'
	));

    //Copyright Text Alignment
	$wp_customize->add_setting('ultimate_ecommerce_shop_copyright_text_position',array(
        'default' => 'center',
        'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_copyright_text_position',array(
        'type' => 'select',
        'label' => __('Copyright Text Alignment','ultimate-ecommerce-shop'),
        'section' => 'ultimate_ecommerce_shop_footer_section',
        'choices' => array(
            'left' => __('Left','ultimate-ecommerce-shop'),
            'right' => __('Right','ultimate-ecommerce-shop'),
            'center' => __('Center','ultimate-ecommerce-shop'),
        ),
	) );

	//Copyright Background Color
    $wp_customize->add_setting('ultimate_ecommerce_shop_copyright_background_color', array(
		'default'           => '#067fb9',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_footer_section',
	)));

	$wp_customize->add_setting('ultimate_ecommerce_shop_widgets_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_widgets_title_color', array(
		'label'    => __('Widgets Title Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_footer_section',
	)));

	$wp_customize->add_setting('ultimate_ecommerce_shop_widgets_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ultimate_ecommerce_shop_widgets_menu_color', array(
		'label'    => __('Widgets Menus Color', 'ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_footer_section',
	)));

	//Wocommerce Shop Page
	$wp_customize->add_section('ultimate_ecommerce_shop_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','ultimate-ecommerce-shop'),
		'panel' => 'ultimate_ecommerce_shop_panel_id'
	));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'ultimate_ecommerce_shop_sanitize_choices',
	) );
	$wp_customize->add_control( 'ultimate_ecommerce_shop_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'ultimate-ecommerce-shop' ),
		'description'	=> __('How many products should be shown per Column?','ultimate-ecommerce-shop'),
		'section'  => 'ultimate_ecommerce_shop_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('ultimate_ecommerce_shop_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_float',
	));	
	$wp_customize->add_control('ultimate_ecommerce_shop_products_per_page',array(
		'label'	=> __('Product Per Page','ultimate-ecommerce-shop'),
		'description'	=> __('How many products should be shown per page?','ultimate-ecommerce-shop'),
		'section'	=> 'ultimate_ecommerce_shop_woocommerce_shop_page',
		'type'		=> 'number'
	));

	// logo site title size 
	$wp_customize->add_setting('ultimate_ecommerce_shop_site_title_font_size',array(
		'default'	=> 40,
		'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_float'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_site_title_font_size',array(
		'label'	=> __('Site Title Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'title_tagline',
		'setting'	=> 'ultimate_ecommerce_shop_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// logo site tagline size 
	$wp_customize->add_setting('ultimate_ecommerce_shop_site_tagline_font_size',array(
		'default'	=> 15,
		'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_float'
	));
	$wp_customize->add_control('ultimate_ecommerce_shop_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size','ultimate-ecommerce-shop'),
		'section'	=> 'title_tagline',
		'setting'	=> 'ultimate_ecommerce_shop_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// logo site title
	$wp_customize->add_setting('ultimate_ecommerce_shop_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'ultimate_ecommerce_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('ultimate_ecommerce_shop_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','ultimate-ecommerce-shop'),
       'section' => 'title_tagline'
    ));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_site_title_color', array(
		'label' => __('Title Color', 'ultimate-ecommerce-shop'),
		'section' => 'title_tagline',
		'settings' => 'ultimate_ecommerce_shop_site_title_color',
	)));

	$wp_customize->add_setting( 'ultimate_ecommerce_shop_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_ecommerce_shop_site_tagline_color', array(
		'label' => __('Tagline Color', 'ultimate-ecommerce-shop'),
		'section' => 'title_tagline',
		'settings' => 'ultimate_ecommerce_shop_site_tagline_color',
	)));
	
}
add_action( 'customize_register', 'ultimate_ecommerce_shop_customize_register' );	

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Ultimate_Ecommerce_Shop_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Ultimate_Ecommerce_Shop_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
		 	new Ultimate_Ecommerce_Shop_Customize_Section_Pro(
		 		$manager,
		 		'example_1',
		 		array(
					'priority' => 9,
	 				'title'    => esc_html__( 'Ultimate Ecommerce Pro', 'ultimate-ecommerce-shop' ),
					'pro_text' => esc_html__( 'Go Pro','ultimate-ecommerce-shop' ),
					'pro_url'  => esc_url('https://www.logicalthemes.com/themes/premium-ecommerce-wordpress-theme/')
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'ultimate-ecommerce-shop-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'ultimate-ecommerce-shop-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Ultimate_Ecommerce_Shop_Customize::get_instance();