<?php
/**
 * Ultimate Ecommerce Shop functions and definitions
 * @package Ultimate Ecommerce Shop
 */

/* Theme Setup */
if ( ! function_exists( 'ultimate_ecommerce_shop_setup' ) ) :

function ultimate_ecommerce_shop_setup() {

	load_theme_textdomain( 'ultimate-ecommerce-shop', get_template_directory() . '/languages' );

	$GLOBALS['content_width'] = apply_filters( 'ultimate_ecommerce_shop_content_width', 640 );

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'custom-logo', array(
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
	) );
	add_image_size('ultimate-ecommerce-shop-homepage-thumb',240,145,true);
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'ultimate-ecommerce-shop' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'f1f1f1'
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support('responsive-embeds');

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */

	add_editor_style( array( 'assets/css/editor-style.css', ultimate_ecommerce_shop_font_url() ) );

	// Theme Activation Notice
	global $pagenow;
	
	if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
		add_action( 'admin_notices', 'ultimate_ecommerce_shop_activation_notice' );
	}
}
endif; // ultimate_ecommerce_shop_setup
add_action( 'after_setup_theme', 'ultimate_ecommerce_shop_setup' );

// Notice after Theme Activation
function ultimate_ecommerce_shop_activation_notice() {
	echo '<div class="notice notice-success is-dismissible welcome">';
		echo '<h3>'. esc_html__( 'Warm Greetings to you!!', 'ultimate-ecommerce-shop' ) .'</h3>';
		echo '<p>'. esc_html__( ' We are much obliged to you for choosing are Ultimate Ecommerce theme. We promise to present you with all the outstanding features and services of our theme. Please proceed towards the landing page to get started .', 'ultimate-ecommerce-shop' ) .'</p>';
		echo '<p><a href="'. esc_url( admin_url( 'themes.php?page=ultimate_ecommerce_shop_guide' ) ) .'" class="button button-primary">'. esc_html__( 'Welcome...', 'ultimate-ecommerce-shop' ) .'</a></p>';
	echo '</div>';
}

/*Site URL*/
define('ULTIMATE_ECOMMERCE_SHOP_FREE_THEME_DOC',__('https://logicalthemes.com/docs/free-ultimate-ecommerce/', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_SUPPORT',__('https://wordpress.org/support/theme/ultimate-ecommerce-shop/', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_REVIEW',__('https://wordpress.org/support/theme/ultimate-ecommerce-shop/reviews/#new-post', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_BUY_NOW',__('https://www.logicalthemes.com/tl-pr/premium-ecommerce-wordpress-theme/', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_LIVE_DEMO',__('https://logicalthemes.com/ultimate-ecommerce-shop-pro/', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_PRO_DOC',__('https://logicalthemes.com/docs/ultimate-ecommerce-store-pro/', 'ultimate-ecommerce-shop'));
define('ULTIMATE_ECOMMERCE_SHOP_CREDIT',__('https://www.logicalthemes.com/themes/free-ecommerce-wordpress-theme/','ultimate-ecommerce-shop'));
if ( ! function_exists( 'ultimate_ecommerce_shop_credit' ) ) {
	function ultimate_ecommerce_shop_credit(){
		echo "<a href=".esc_url(ULTIMATE_ECOMMERCE_SHOP_CREDIT)." target='_blank'>".esc_html__(get_theme_mod('ultimate_ecommerce_shop_footer_copy',__('By LogicalThemes','ultimate-ecommerce-shop')))."</a>";
	}
}

/*radio button sanitization*/
function ultimate_ecommerce_shop_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function ultimate_ecommerce_shop_sanitize_phone_number( $phone ) {
	return preg_replace( '/[^\d+]/', '', $phone );
}

function ultimate_ecommerce_shop_sanitize_checkbox( $input ) {
	return ( ( isset( $input ) && true == $input ) ? true : false );
}

function ultimate_ecommerce_shop_sanitize_float( $input ) {
	return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'ultimate_ecommerce_shop_loop_columns');
if (!function_exists('ultimate_ecommerce_shop_loop_columns')) {
	function ultimate_ecommerce_shop_loop_columns() {
		$columns = get_theme_mod( 'ultimate_ecommerce_shop_products_per_column', 3 );
		return $columns; // 3 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'ultimate_ecommerce_shop_shop_per_page', 20 );
function ultimate_ecommerce_shop_shop_per_page( $cols ) {
  	$cols = get_theme_mod( 'ultimate_ecommerce_shop_products_per_page', 9 );
	return $cols;
}

function ultimate_ecommerce_shop_sanitize_dropdown_pages($page_id, $setting) {
	// Ensure $input is an absolute integer.
	$page_id = absint($page_id);
	// If $page_id is an ID of a published page, return it; otherwise, return the default.
	return ('publish' == get_post_status($page_id)?$page_id:$setting->default);
}

/* Theme Widgets Setup */
function ultimate_ecommerce_shop_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears on blog page sidebar', 'ultimate-ecommerce-shop' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Posts and Pages Sidebar', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears on posts and pages', 'ultimate-ecommerce-shop' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears on posts and pages', 'ultimate-ecommerce-shop' ),
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Social Icon', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears on header', 'ultimate-ecommerce-shop' ),
		'id'            => 'social-icon',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears in footer', 'ultimate-ecommerce-shop' ),
		'id'            => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 2', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears in footer', 'ultimate-ecommerce-shop' ),
		'id'            => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 3', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears in footer', 'ultimate-ecommerce-shop' ),
		'id'            => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 4', 'ultimate-ecommerce-shop' ),
		'description'   => __( 'Appears in footer', 'ultimate-ecommerce-shop' ),
		'id'            => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'ultimate_ecommerce_shop_widgets_init' );

function ultimate_ecommerce_shop_font_url() {
	$font_url      = '';
	$font_family   = array(
		'ABeeZee:ital@0;1',
	    'Abril+Fatfac',
	    'Acme',
	    'Anton',
	    'Architects+Daughter',
	    'Arimo:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
	    'Arsenal:ital,wght@0,400;0,700;1,400;1,700',
	    'Arvo:ital,wght@0,400;0,700;1,400;1,700',
	    'Alegreya:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Alfa+Slab+One',
	    'Averia+Serif+Libre:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700',
	    'Bangers',
	    'Boogaloo',
	    'Bad+Script',
	    'Bitter:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Bree+Serif',
	    'BenchNine:wght@300;400;700',
	    'Cabin:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
	    'Cardo:ital,wght@0,400;0,700;1,400',
	    'Courgette',
	    'Cherry+Swash:wght@400;700',
	    'Cormorant+Garamond:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700',
	    'Crimson+Text:ital,wght@0,400;0,600;0,700;1,400;1,600;1,700',
	    'Cuprum:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
	    'Cookie',
	    'Coming+Soon',
	    'Chewy',
	    'Days+One',
	    'Dosis:wght@200;300;400;500;600;700;800',
	    'Economica:ital,wght@0,400;0,700;1,400;1,700',
	    'Fira+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Fredoka+One',
	    'Fjalla+One',
	    'Francois+One',
	    'Frank+Ruhl+Libre:wght@300;400;500;700;900',
	    'Gloria+Hallelujah',
	    'Great+Vibes',
	    'Handlee',
	    'Hammersmith+One',
	    'Heebo:wght@100;200;300;400;500;600;700;800;900',
	    'Inconsolata:wght@200;300;400;500;600;700;800;900',
	    'Indie+Flower',
	    'IM+Fell+English+SC',
	    'Julius+Sans+One',
	    'Josefin+Slab:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700',
	    'Josefin+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700',
	    'Jost:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Kaisei+HarunoUmi:wght@400;500;700',
	    'Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Lobster',
	    'Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900',
	    'Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
	    'Libre+Baskerville:ital,wght@0,400;0,700;1,400',
	    'Lobster+Two:ital,wght@0,400;0,700;1,400;1,700',
	    'Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900',
	    'Monda:wght@400;700',
	    'Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Marck+Script',
	    'Noto+Serif:ital,wght@0,400;0,700;1,400;1,700',
	    'Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800',
	    'Overpass:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Overpass+Mono:wght@300;400;500;600;700',
	    'Oxygen:wght@300;400;700',
	    'Orbitron:wght@400;500;600;700;800;900',
	    'Patua+One',
	    'Pacifico',
	    'Padauk:wght@400;700',
	    'Playball',
	    'Playfair+Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
	    'PT+Sans:ital,wght@0,400;0,700;1,400;1,700',
	    'Philosopher:ital,wght@0,400;0,700;1,400;1,700',
	    'Permanent+Marker',
	    'Poiret+One',
	    'Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Quicksand:wght@300;400;500;600;700',
	    'Quattrocento+Sans:ital,wght@0,400;0,700;1,400;1,700',
	    'Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Roboto+Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700',
	    'Rokkitt:wght@100;200;300;400;500;600;700;800;900',
	    'Russo+One',
	    'Righteous',
	    'Saira:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Satisfy',
	    'Slabo+13px',
	    'Slabo+27px',
	    'Source+Sans+Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900',
	    'Shadows+Into+Light+Two',
	    'Shadows+Into+Light',
	    'Sacramento',
	    'Shrikhand',
	    'Staatliches',
	    'Tangerine:wght@400;700',
	    'Trirong:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700',
	    'Unica+One',
	    'VT323',
	    'Varela+Round',
	    'Vampiro+One',
	    'Vollkorn:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Volkhov:ital,wght@0,400;0,700;1,400;1,700',
	    'Work+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'Yanone+Kaffeesatz:wght@200;300;400;500;600;700',
	    'ZCOOL+XiaoWei'
	);

	$fonts_url = add_query_arg( array(
		'family' => implode( '&family=', $font_family ),
		'display' => 'swap',
	), 'https://fonts.googleapis.com/css2' );

	$contents = wptt_get_webfont_url( esc_url_raw( $fonts_url ) );
	return $contents;
}	

/* Theme enqueue scripts */
function ultimate_ecommerce_shop_scripts() {
	wp_enqueue_style( 'ultimate-ecommerce-shop-font', ultimate_ecommerce_shop_font_url(), array() );
	wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');
	wp_enqueue_style( 'ultimate-ecommerce-shop-basic-style', get_stylesheet_uri() );
    require get_parent_theme_file_path( '/inc/inline-css.php' );
	wp_add_inline_style( 'ultimate-ecommerce-shop-basic-style',$ultimate_ecommerce_shop_custom_css );
	wp_style_add_data( 'ultimate-ecommerce-shop-style', 'rtl', 'replace' );
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/assets/css/fontawesome-all.css' );	 
	wp_enqueue_style( 'custom-aniumations', get_template_directory_uri().'/assets/css/animations.css' );

	// Paragraph
	    $ultimate_ecommerce_shop_paragraph_color = get_theme_mod('ultimate_ecommerce_shop_paragraph_color', '');
	    $ultimate_ecommerce_shop_paragraph_font_family = get_theme_mod('ultimate_ecommerce_shop_paragraph_font_family', '');
	    $ultimate_ecommerce_shop_paragraph_font_size = get_theme_mod('ultimate_ecommerce_shop_paragraph_font_size', '');
	// "a" tag
		$ultimate_ecommerce_shop_atag_color = get_theme_mod('ultimate_ecommerce_shop_atag_color', '');
	    $ultimate_ecommerce_shop_atag_font_family = get_theme_mod('ultimate_ecommerce_shop_atag_font_family', '');
	// "li" tag
		$ultimate_ecommerce_shop_li_color = get_theme_mod('ultimate_ecommerce_shop_li_color', '');
	    $ultimate_ecommerce_shop_li_font_family = get_theme_mod('ultimate_ecommerce_shop_li_font_family', '');
	// H1
		$ultimate_ecommerce_shop_h1_color = get_theme_mod('ultimate_ecommerce_shop_h1_color', '');
	    $ultimate_ecommerce_shop_h1_font_family = get_theme_mod('ultimate_ecommerce_shop_h1_font_family', '');
	    $ultimate_ecommerce_shop_h1_font_size = get_theme_mod('ultimate_ecommerce_shop_h1_font_size', '');
	// H2
		$ultimate_ecommerce_shop_h2_color = get_theme_mod('ultimate_ecommerce_shop_h2_color', '');
	    $ultimate_ecommerce_shop_h2_font_family = get_theme_mod('ultimate_ecommerce_shop_h2_font_family', '');
	    $ultimate_ecommerce_shop_h2_font_size = get_theme_mod('ultimate_ecommerce_shop_h2_font_size', '');
	// H3
		$ultimate_ecommerce_shop_h3_color = get_theme_mod('ultimate_ecommerce_shop_h3_color', '');
	    $ultimate_ecommerce_shop_h3_font_family = get_theme_mod('ultimate_ecommerce_shop_h3_font_family', '');
	    $ultimate_ecommerce_shop_h3_font_size = get_theme_mod('ultimate_ecommerce_shop_h3_font_size', '');
	// H4
		$ultimate_ecommerce_shop_h4_color = get_theme_mod('ultimate_ecommerce_shop_h4_color', '');
	    $ultimate_ecommerce_shop_h4_font_family = get_theme_mod('ultimate_ecommerce_shop_h4_font_family', '');
	    $ultimate_ecommerce_shop_h4_font_size = get_theme_mod('ultimate_ecommerce_shop_h4_font_size', '');
	// H5
		$ultimate_ecommerce_shop_h5_color = get_theme_mod('ultimate_ecommerce_shop_h5_color', '');
	    $ultimate_ecommerce_shop_h5_font_family = get_theme_mod('ultimate_ecommerce_shop_h5_font_family', '');
	    $ultimate_ecommerce_shop_h5_font_size = get_theme_mod('ultimate_ecommerce_shop_h5_font_size', '');
	// H6
		$ultimate_ecommerce_shop_h6_color = get_theme_mod('ultimate_ecommerce_shop_h6_color', '');
	    $ultimate_ecommerce_shop_h6_font_family = get_theme_mod('ultimate_ecommerce_shop_h6_font_family', '');
	    $ultimate_ecommerce_shop_h6_font_size = get_theme_mod('ultimate_ecommerce_shop_h6_font_size', '');
	//slider
		$ultimate_ecommerce_shop_site_title_color = get_theme_mod('ultimate_ecommerce_shop_site_title_color', '');
		$ultimate_ecommerce_shop_site_tagline_color = get_theme_mod('ultimate_ecommerce_shop_site_tagline_color', '');

	//slider
		$ultimate_ecommerce_shop_slider_color = get_theme_mod('ultimate_ecommerce_shop_slider_color', '');
		$ultimate_ecommerce_shop_sliderbg_color = get_theme_mod('ultimate_ecommerce_shop_sliderbg_color', '');
		$ultimate_ecommerce_shop_sliderlink_color = get_theme_mod('ultimate_ecommerce_shop_sliderlink_color', '');

		$ultimate_ecommerce_shop_custom_css ='
			p,span{
			    color:'.esc_html($ultimate_ecommerce_shop_paragraph_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_paragraph_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_paragraph_font_size).'!important;
			}
			a{
			    color:'.esc_html($ultimate_ecommerce_shop_atag_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_atag_font_family).';
			}
			li{
			    color:'.esc_html($ultimate_ecommerce_shop_li_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_li_font_family).';
			}
			h1{
			    color:'.esc_html($ultimate_ecommerce_shop_h1_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h1_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h1_font_size).'!important;
			}
			h2{
			    color:'.esc_html($ultimate_ecommerce_shop_h2_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h2_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h2_font_size).'!important;
			}
			h3{
			    color:'.esc_html($ultimate_ecommerce_shop_h3_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h3_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h3_font_size).'!important;
			}
			h4{
			    color:'.esc_html($ultimate_ecommerce_shop_h4_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h4_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h4_font_size).'!important;
			}
			h5{
			    color:'.esc_html($ultimate_ecommerce_shop_h5_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h5_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h5_font_size).'!important;
			}
			h6{
			    color:'.esc_html($ultimate_ecommerce_shop_h6_color).'!important;
			    font-family: '.esc_html($ultimate_ecommerce_shop_h6_font_family).'!important;
			    font-size: '.esc_html($ultimate_ecommerce_shop_h6_font_size).'!important;
			}
			#slider .inner_carousel h1{
			    color:'.esc_html($ultimate_ecommerce_shop_slider_color).'!important;
			    background: '.esc_html($ultimate_ecommerce_shop_sliderbg_color).'!important;
			}
			#slider .more-btn a{
			    color:'.esc_html($ultimate_ecommerce_shop_sliderlink_color).'!important;
			}
			p.site-title a{
			    color:'.esc_html($ultimate_ecommerce_shop_site_title_color).'!important;
			}
			p.site-description{
			    color:'.esc_html($ultimate_ecommerce_shop_site_tagline_color).'!important;
			}

		';

		wp_add_inline_style( 'ultimate-ecommerce-shop-basic-style',$ultimate_ecommerce_shop_custom_css );

	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.js', array('jquery') ,'',true);
	wp_enqueue_script( 'ultimate-ecommerce-shop-customscripts', get_template_directory_uri() . '/assets/js/custom.js', array('jquery') );
	wp_enqueue_script( 'jquery-superfish', get_template_directory_uri() . '/assets/js/jquery.superfish.js', array('jquery') ,'',true);
	require get_parent_theme_file_path( '/inc/inline-css.php' );
	wp_add_inline_style( 'ultimate-ecommerce-shop-basic-style',$ultimate_ecommerce_shop_custom_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ultimate_ecommerce_shop_scripts' );

require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/custom-widgets/social-profile.php';
require get_template_directory() . '/inc/getting-started/getting-started.php';
require get_template_directory() . '/wptt-webfont-loader.php';