<?php
/**
 * Security Guard Services Theme Customizer
 *
 * @package Security Guard Services
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Security_Guard_Services_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Security_Guard_Services_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Security_Guard_Services_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Security Guard Services Pro', 'security-guard-services' ),
					'pro_text' => esc_html__( 'Go Pro', 'security-guard-services' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/products/premium-security-guard-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'security-guard-services-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'security-guard-services-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Security_Guard_Services_Customize::get_instance();

function security_guard_services_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'security_guard_services_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'security-guard-services' ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'security_guard_services_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'security-guard-services' ),
		'priority'   => null,
		'panel' => 'security_guard_services_panel_id'
	) );

	$wp_customize->add_setting('security_guard_services_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control('security_guard_services_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'security-guard-services' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'security-guard-services' ),
        'section' => 'security_guard_services_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','security-guard-services'),
            'Three Columns' => esc_html__('Three Columns','security-guard-services'),
            'Four Columns' => esc_html__('Four Columns','security-guard-services'),
            'Right Sidebar' => esc_html__('Right Sidebar','security-guard-services'),
            'Left Sidebar' => esc_html__('Left Sidebar','security-guard-services'),
            'Grid Layout' => esc_html__('Grid Layout','security-guard-services')
        ),
	));

	$security_guard_services_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'security_guard_services_typography', array(
    	'title'      => __( 'Typography', 'security-guard-services' ),
		'priority'   => null,
		'panel' => 'security_guard_services_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'security_guard_services_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_paragraph_color', array(
		'label' => __('Paragraph Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_paragraph_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'Paragraph Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	$wp_customize->add_setting('security_guard_services_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'security_guard_services_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_atag_color', array(
		'label' => __('"a" Tag Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_atag_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( '"a" Tag Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'security_guard_services_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_li_color', array(
		'label' => __('"li" Tag Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_li_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( '"li" Tag Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h1_color', array(
		'label' => __('H1 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h1_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H1 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('security_guard_services_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h1_font_size',array(
		'label'	=> __('H1 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h2_color', array(
		'label' => __('H2 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h2_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H2 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('security_guard_services_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h2_font_size',array(
		'label'	=> __('H2 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h3_color', array(
		'label' => __('H3 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h3_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H3 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('security_guard_services_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h3_font_size',array(
		'label'	=> __('H3 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h4_color', array(
		'label' => __('H4 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h4_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H4 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('security_guard_services_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h4_font_size',array(
		'label'	=> __('H4 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h5_color', array(
		'label' => __('H5 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h5_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H5 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('security_guard_services_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h5_font_size',array(
		'label'	=> __('H5 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'security_guard_services_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_h6_color', array(
		'label' => __('H6 Color', 'security-guard-services'),
		'section' => 'security_guard_services_typography',
		'settings' => 'security_guard_services_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('security_guard_services_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'security_guard_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'security_guard_services_h6_font_family', array(
	    'section'  => 'security_guard_services_typography',
	    'label'    => __( 'H6 Fonts','security-guard-services'),
	    'type'     => 'select',
	    'choices'  => $security_guard_services_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('security_guard_services_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_h6_font_size',array(
		'label'	=> __('H6 Font Size','security-guard-services'),
		'section'	=> 'security_guard_services_typography',
		'setting'	=> 'security_guard_services_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('security_guard_services_topbar',array(
		'title'	=> esc_html__('Header','security-guard-services'),
		'priority'	=> null,
		'panel' => 'security_guard_services_panel_id',
	));

	$wp_customize->add_setting( 'security_guard_services_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'security_guard_services_sanitize_checkbox'
    ) );
    $wp_customize->add_control('security_guard_services_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'security-guard-services' ),
        'label' => __( 'Sticky Header','security-guard-services' ),
        'section' => 'security_guard_services_topbar'
    ));

	$wp_customize->add_setting('security_guard_header_btnphonnum_text',array(
		'default'	=> '123-456-789',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_header_btnphonnum_text',array(
		'label'	=> __('Add Phone Number','security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_header_bg', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_header_bg', array(
		'label' => __('BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_header_bg',
	)));


	$wp_customize->add_setting( 'security_guard_services_header_menu_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_menu_col', array(
		'label' => __('Menu Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_menu_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_menuactivehover_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_menuactivehover_col', array(
		'label' => __('Menu Active & Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_menuactivehover_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_menuactiveborderhover_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_menuactiveborderhover_col', array(
		'label' => __('Menu Active & Hover Border Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_menuactiveborderhover_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_submenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_submenu_color', array(
		'label' => __('Submenu Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_submenu_color',
	)));


	$wp_customize->add_setting( 'security_guard_services_header_submenu_bg_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_submenu_bg_col', array(
		'label' => __('Submenu BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_submenu_bg_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_submenu_txthovercolor', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_submenu_txthovercolor', array(
		'label' => __('Submenu Text Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_submenu_txthovercolor',
	)));


	$wp_customize->add_setting( 'security_guard_services_header_submenubg_hover', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_submenubg_hover', array(
		'label' => __('Submenu BG Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_submenubg_hover',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_btn_text_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_btn_text_col', array(
		'label' => __('Button Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_btn_text_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_btn_bg_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_btn_bg_col', array(
		'label' => __('Button BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_btn_bg_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_btn_brdbg_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_btn_brdbg_col', array(
		'label' => __('Button Border Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_btn_brdbg_col',
	)));

	$wp_customize->add_setting( 'security_guard_services_header_btn_texthover_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_header_btn_texthover_col', array(
		'label' => __('Button Text Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_topbar',
		'settings' => 'security_guard_services_header_btn_texthover_col',
	)));

	//home page banner
	$wp_customize->add_section( 'security_guard_services_bannersettings' , array(
    	'title'      => esc_html__( 'Banner Settings', 'security-guard-services' ),
		'priority'   => null,
		'panel' => 'security_guard_services_panel_id'
	) );

	$wp_customize->add_setting(
    	'banner_profile_img',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_profile_img',
	        array(
			    'label'   		=> __('Profile Image','security-guard-services'),
				'description'   		=> __('Image size 480*566','security-guard-services'),
	            'section' => 'security_guard_services_bannersettings',
	            'settings' => 'banner_profile_img',
	        )
	    )
	);

	$wp_customize->add_setting('security_guard_services_banner_heading',array(
		'default'	=> 'YOUR TRUSTED PARTNER',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_banner_heading',array(
		'label'	=> __('Top Heading','security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_banner_headingbtm',array(
		'default'	=> 'IN SECURITY',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_banner_headingbtm',array(
		'label'	=> __('Bottom Heading','security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_banner_description',array(
		'default'	=> 'At SecurityForce, we deliver unparalleled protection services tailored to your needs.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_banner_description',array(
		'label'	=> __('Description','security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'banner_video_thumbnailimg',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_video_thumbnailimg',
	        array(
			    'label'   		=> __('Video Thumbnail Image','security-guard-services'),
				'description'   		=> __('Image size 640*427','security-guard-services'),
	            'section' => 'security_guard_services_bannersettings',
	            'settings' => 'banner_video_thumbnailimg',
	        )
	    )
	);

	$wp_customize->add_setting('security_guard_services_banner_videolink', array(
		'sanitize_callback' => 'security_guard_services_sanitize_iframe',
		'default' => 'Add your video embed code'
	));
	
	$wp_customize->add_control('security_guard_services_banner_videolink', array(
		'settings'=>'security_guard_services_banner_videolink', 
		'section'=>'security_guard_services_bannersettings',
		'type'=>'textarea', 
		'label'=> __('Iframe Code For Video', 'security-guard-services')
	));
	

	// $wp_customize->add_setting('security_guard_services_banner_videolink',array(
	// 	'default'	=> '#',
	// 	'sanitize_callback'	=> 'sanitize_text_field'
	// ));
	// $wp_customize->add_control('security_guard_services_banner_videolink',array(
	// 	'label'	=> __('Video Link','security-guard-services'),
	// 	'section' => 'security_guard_services_bannersettings',
	// 	'type'	 => 'text'
	// ));

// lzCustomLable($wp_customize, 'slidebtnlr', 'security_guard_services_bannersettings' , 'Button Setting');

	$wp_customize->add_setting('security_guard_services_banner_btntext',array(
		'default'	=> 'Request A Quote',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_banner_btntext',array(
		'label'	=> __('Button Text','security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_banner_btnlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_banner_btnlink',array(
		'label'	=> __('Button Link','security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'type'	 => 'text'
	));


	$wp_customize->add_setting( 'security_guard_services_banner_profilebg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_profilebg_color', array(
		'label' => __('Profile BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_profilebg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_heading_color', array(
		'label' => __('Heading Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_heading_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_description_color', array(
		'label' => __('Description Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_description_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_descriptionbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_descriptionbrd_color', array(
		'label' => __('Description Border Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_descriptionbrd_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_videoplaybtn_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_videoplaybtn_color', array(
		'label' => __('Video Play Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_videoplaybtn_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_videoplaybtnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_videoplaybtnbg_color', array(
		'label' => __('Video Play Icon BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_videoplaybtnbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btntext_color', array(
		'label' => __('Button Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btntext_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btnicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btnicon_color', array(
		'label' => __('Button Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btnicon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btniconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btniconbg_color', array(
		'label' => __('Button Icon BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btniconbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btnbg_color', array(
		'label' => __('Button BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btnbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btntxthrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btntxthrv_color', array(
		'label' => __('Button Text Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btntxthrv_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_banner_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_banner_btnbghrv_color', array(
		'label' => __('Button BG Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_bannersettings',
		'settings' => 'security_guard_services_banner_btnbghrv_color',
	)));


	//home page feature
	$wp_customize->add_section( 'security_guard_services_featuresettings' , array(
    	'title'      => esc_html__( 'Feature Settings', 'security-guard-services' ),
		'priority'   => null,
		'panel' => 'security_guard_services_panel_id'
	) );

	$wp_customize->add_setting( 'security_guard_services_feature_page1', array(
		'default'           => '',
		'sanitize_callback' => 'security_guard_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'security_guard_services_feature_page1', array(
		'label'    => esc_html__( 'Select Feature Page', 'security-guard-services' ),
		'section'  => 'security_guard_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('security_guard_services_feature_icon1',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_feature_icon1',array(
		'label'	=> __('Icon 1','security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_feature_page2', array(
		'default'           => '',
		'sanitize_callback' => 'security_guard_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'security_guard_services_feature_page2', array(
		'label'    => esc_html__( 'Select Feature Page', 'security-guard-services' ),
		'section'  => 'security_guard_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('security_guard_services_feature_icon2',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_feature_icon2',array(
		'label'	=> __('Icon 2','security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_feature_page3', array(
		'default'           => '',
		'sanitize_callback' => 'security_guard_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'security_guard_services_feature_page3', array(
		'label'    => esc_html__( 'Select Feature Page', 'security-guard-services' ),
		'section'  => 'security_guard_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('security_guard_services_feature_icon3',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_feature_icon3',array(
		'label'	=> __('Icon 3','security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_feature_page4', array(
		'default'           => '',
		'sanitize_callback' => 'security_guard_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'security_guard_services_feature_page4', array(
		'label'    => esc_html__( 'Select Feature Page', 'security-guard-services' ),
		'section'  => 'security_guard_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('security_guard_services_feature_icon4',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_feature_icon4',array(
		'label'	=> __('Icon 4','security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_feature_shield_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_feature_shield_color', array(
		'label' => __('Shield Color', 'security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'settings' => 'security_guard_services_feature_shield_color',
	)));
	
	$wp_customize->add_setting( 'security_guard_services_feature_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_feature_icon_color', array(
		'label' => __('Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'settings' => 'security_guard_services_feature_icon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_feature_iconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_feature_iconbg_color', array(
		'label' => __('Icon BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'settings' => 'security_guard_services_feature_iconbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_feature_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_feature_title_color', array(
		'label' => __('Title Color', 'security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'settings' => 'security_guard_services_feature_title_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_feature_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_feature_description_color', array(
		'label' => __('Description Color', 'security-guard-services'),
		'section' => 'security_guard_services_featuresettings',
		'settings' => 'security_guard_services_feature_description_color',
	)));


	//home page Aboutus
	$wp_customize->add_section( 'security_guard_services_aboutussettings' , array(
		'title'      => esc_html__( 'About Us Settings', 'security-guard-services' ),
		'priority'   => null,
		'panel' => 'security_guard_services_panel_id'
	) );

	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image','security-guard-services'),
				'description'   		=> __('Image size 406*640','security-guard-services'),
	            'section' => 'security_guard_services_aboutussettings',
	            'settings' => 'aboutus_image',
	        )
	    )
	);

	$wp_customize->add_setting('security_guard_services_aboutus_subheading',array(
		'default'	=> 'About Us',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_subheading',array(
		'label'	=> __('Sub Heading','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_heading1',array(
		'default'	=> 'YOUR TRUSTED PARTNER',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_heading1',array(
		'label'	=> __('Heading 1','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_heading2',array(
		'default'	=> 'IN SECURITY',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_heading2',array(
		'label'	=> __('Heading 2','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('security_guard_services_aboutus_description',array(
		'default'	=> 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words hidden in the middle of text.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_description',array(
		'label'	=> __('Description','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('security_guard_services_aboutus_list1',array(
		'default'	=> '24/7 Availability',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_list1',array(
		'label'	=> __('List 1','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_list2',array(
		'default'	=> '14 Year of Experience',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_list2',array(
		'label'	=> __('List 2','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_list3',array(
		'default'	=> 'Trained Professionals',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_list3',array(
		'label'	=> __('List 3','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_list4',array(
		'default'	=> 'Advanced Technology',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_list4',array(
		'label'	=> __('List 4','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('security_guard_services_aboutus_btntext',array(
		'default'	=> 'Request A Quote',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_btntext',array(
		'label'	=> __('Button Text','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_btnlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_btnlink',array(
		'label'	=> __('Button Link','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_yearofexprience_number',array(
		'default'	=> '21',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_yearofexprience_number',array(
		'label'	=> __('Year of Exprience Number','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_yearofexprience_numbertxt',array(
		'default'	=> 'YEARS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_yearofexprience_numbertxt',array(
		'label'	=> __('Year of Exprience Number Text','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('security_guard_services_aboutus_yearofexprience_text',array(
		'default'	=> 'OF EXPERIENCE',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('security_guard_services_aboutus_yearofexprience_text',array(
		'label'	=> __('Year of Exprience Text','security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_aboutus_subheading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_subheading_color', array(
		'label' => __('Sub Heading Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_subheading_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_subheadingbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_subheadingbg_color', array(
		'label' => __('Sub Heading BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_subheadingbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_subheadingicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_subheadingicon_color', array(
		'label' => __('Sub Heading Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_subheadingicon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_heading1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_heading1_color', array(
		'label' => __('Heading 1 Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_heading1_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_heading2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_heading2_color', array(
		'label' => __('Heading 2 Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_heading2_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_description_color', array(
		'label' => __('Description Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_description_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_lists_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_lists_color', array(
		'label' => __('Lists Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_lists_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_listsicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_listsicon_color', array(
		'label' => __('Lists Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_listsicon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btntext_color', array(
		'label' => __('Button Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btntext_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btnicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btnicon_color', array(
		'label' => __('Button Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btnicon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btniconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btniconbg_color', array(
		'label' => __('Button Icon BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btniconbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btnbg_color', array(
		'label' => __('Button BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btnbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btntxthrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btntxthrv_color', array(
		'label' => __('Button Text Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btntxthrv_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_btnbghrv_color', array(
		'label' => __('Button BG Hover Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_btnbghrv_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_yearofexpnum_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_yearofexpnum_color', array(
		'label' => __('Year Of Experience Number Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_yearofexpnum_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_aboutus_yearofexptext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_aboutus_yearofexptext_color', array(
		'label' => __('Year Of Experience Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_aboutussettings',
		'settings' => 'security_guard_services_aboutus_yearofexptext_color',
	)));


	//footer
	$wp_customize->add_section('security_guard_services_footer_section',array(
		'title'	=> esc_html__('Footer Text','security-guard-services'),
		'panel' => 'security_guard_services_panel_id'
	));
		
	$wp_customize->add_setting('security_guard_services_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('security_guard_services_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','security-guard-services'),
		'section'	=> 'security_guard_services_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'security_guard_services_footer_copyright_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_footer_copyright_color', array(
		'label' => __('Copyright Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_footer_section',
		'settings' => 'security_guard_services_footer_copyright_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_footer_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_footer_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'security-guard-services'),
		'section' => 'security_guard_services_footer_section',
		'settings' => 'security_guard_services_footer_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_footer_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_footer_text_color', array(
		'label' => __('Text Color', 'security-guard-services'),
		'section' => 'security_guard_services_footer_section',
		'settings' => 'security_guard_services_footer_text_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_footer_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_footer_icon_color', array(
		'label' => __('Icon Color', 'security-guard-services'),
		'section' => 'security_guard_services_footer_section',
		'settings' => 'security_guard_services_footer_icon_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_footer_activemenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_footer_activemenu_color', array(
		'label' => __('Active Menu Color', 'security-guard-services'),
		'section' => 'security_guard_services_footer_section',
		'settings' => 'security_guard_services_footer_activemenu_color',
	)));


	//Wocommerce Shop Page
	$wp_customize->add_section('security_guard_services_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','security-guard-services'),
		'panel' => 'security_guard_services_panel_id'
	));

	$wp_customize->add_setting( 'security_guard_services_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'security_guard_services_sanitize_choices',
	) );
	$wp_customize->add_control( 'security_guard_services_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'security-guard-services' ),
		'description'	=> __('How many products should be shown per Column?','security-guard-services'),
		'section'  => 'security_guard_services_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('security_guard_services_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'security_guard_services_sanitize_float',
	));	
	$wp_customize->add_control('security_guard_services_products_per_page',array(
		'label'	=> __('Product Per Page','security-guard-services'),
		'description'	=> __('How many products should be shown per page?','security-guard-services'),
		'section'	=> 'security_guard_services_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'security_guard_services_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'security-guard-services'),
		'section' => 'security_guard_services_woocommerce_shop_page',
		'settings' => 'security_guard_services_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'security_guard_services_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'security-guard-services'),
		'section' => 'security_guard_services_woocommerce_shop_page',
		'settings' => 'security_guard_services_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'security_guard_services_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_product_sale_color', array(
		'label' => __('Sale Badge Color', 'security-guard-services'),
		'section' => 'security_guard_services_woocommerce_shop_page',
		'settings' => 'security_guard_services_product_sale_color',
	)));


	// logo site title
	$wp_customize->add_setting('security_guard_services_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'security_guard_services_sanitize_checkbox'
    ));
    $wp_customize->add_control('security_guard_services_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','security-guard-services'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'security_guard_services_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_site_title_color', array(
		'label' => __('Site Title Color', 'security-guard-services'),
		'section' => 'title_tagline',
		'settings' => 'security_guard_services_site_title_color',
	)));

    $wp_customize->add_setting( 'security_guard_services_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'security_guard_services_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'security-guard-services'),
		'section' => 'title_tagline',
		'settings' => 'security_guard_services_site_tagline_color',
	)));
}
add_action( 'customize_register', 'security_guard_services_customize_register' );