<?php
/**
 * Roofing Solutions Theme Customizer
 *
 * @package Roofing Solutions
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Roofing_Solutions_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Roofing_Solutions_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Roofing_Solutions_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Roofing Solutions Pro', 'roofing-solutions' ),
					'pro_text' => esc_html__( 'Go Pro', 'roofing-solutions' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/product/themes/roofing-wp-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'roofing-solutions-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'roofing-solutions-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Roofing_Solutions_Customize::get_instance();

function roofing_solutions_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'roofing_solutions_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'roofing-solutions' ),
	) );

	//Select width layout
    $wp_customize->add_setting('roofing_solutions_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control('roofing_solutions_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','roofing-solutions'),
        'section' => 'roofing_solutions_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','roofing-solutions'),
            'Contained Width' => esc_html__('Contained Width','roofing-solutions'),
            'Boxed Width' => esc_html__('Boxed Width','roofing-solutions'),
        ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'roofing_solutions_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'roofing-solutions' ),
		'priority'   => null,
		'panel' => 'roofing_solutions_panel_id'
	) );

	$wp_customize->add_setting('roofing_solutions_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control('roofing_solutions_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'roofing-solutions' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'roofing-solutions' ),
        'section' => 'roofing_solutions_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','roofing-solutions'),
            'Three Columns' => esc_html__('Three Columns','roofing-solutions'),
            'Four Columns' => esc_html__('Four Columns','roofing-solutions'),
            'Right Sidebar' => esc_html__('Right Sidebar','roofing-solutions'),
            'Left Sidebar' => esc_html__('Left Sidebar','roofing-solutions'),
            'Grid Layout' => esc_html__('Grid Layout','roofing-solutions')
        ),
	));

	$wp_customize->add_setting('roofing_solutions_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control('roofing_solutions_dropdown_anim', array(
		'section'  => 'roofing_solutions_left_right',
		'label'    => __( 'Submenu Dropdown Effect','roofing-solutions'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'roofing-solutions'),
			'zoomIn' => __('zoomIn', 'roofing-solutions'),
			'flip-up' => __('flip-up', 'roofing-solutions'),
			'none' => __('none', 'roofing-solutions')
		)
	));

	$roofing_solutions_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'roofing_solutions_typography', array(
    	'title'      => __( 'Typography', 'roofing-solutions' ),
		'priority'   => null,
		'panel' => 'roofing_solutions_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_paragraph_color', array(
		'label' => __('Paragraph Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_paragraph_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'Paragraph Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	$wp_customize->add_setting('roofing_solutions_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_atag_color', array(
		'label' => __('"a" Tag Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_atag_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( '"a" Tag Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_li_color', array(
		'label' => __('"li" Tag Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_li_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( '"li" Tag Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h1_color', array(
		'label' => __('H1 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h1_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H1 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h1_font_size',array(
		'label'	=> __('H1 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h2_color', array(
		'label' => __('H2 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h2_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H2 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h2_font_size',array(
		'label'	=> __('H2 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h3_color', array(
		'label' => __('H3 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h3_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H3 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h3_font_size',array(
		'label'	=> __('H3 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h4_color', array(
		'label' => __('H4 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h4_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H4 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h4_font_size',array(
		'label'	=> __('H4 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h5_color', array(
		'label' => __('H5 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h5_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H5 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h5_font_size',array(
		'label'	=> __('H5 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'roofing_solutions_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_h6_color', array(
		'label' => __('H6 Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_typography',
		'settings' => 'roofing_solutions_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('roofing_solutions_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control(
	    'roofing_solutions_h6_font_family', array(
	    'section'  => 'roofing_solutions_typography',
	    'label'    => __( 'H6 Fonts','roofing-solutions'),
	    'type'     => 'select',
	    'choices'  => $roofing_solutions_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('roofing_solutions_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_h6_font_size',array(
		'label'	=> __('H6 Font Size','roofing-solutions'),
		'section'	=> 'roofing_solutions_typography',
		'setting'	=> 'roofing_solutions_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('roofing_solutions_topbar',array(
		'title'	=> esc_html__('Topbar','roofing-solutions'),
		'priority'	=> null,
		'panel' => 'roofing_solutions_panel_id',
	));

	$wp_customize->add_setting( 'roofing_solutions_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'roofing_solutions_sanitize_checkbox'
    ) );
    $wp_customize->add_control('roofing_solutions_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'roofing-solutions' ),
        'label' => __( 'Sticky Header','roofing-solutions' ),
        'section' => 'roofing_solutions_topbar'
    ));


	$wp_customize->add_setting('roofing_solutions_phone',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_phone',array(
		'label'	=> __('Add Phone Number','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_mail',array(
		'label'	=> __('Add Mail','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('roofing_solutions_facebook_url',array(
		'label'	=> __('Add Facebook URL','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('roofing_solutions_twitter_url',array(
		'label'	=> __('Add Twitter URL','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_likedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('roofing_solutions_likedin_url',array(
		'label'	=> __('Add Linkedin URL','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_btn_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_btn_text',array(
		'label'	=> __('Add Button Text','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_btn_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_btn_link',array(
		'label'	=> __('Button Link','roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'roofing_solutions_logobg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_logobg_color', array(
		'label' => __('Logo BG Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'settings' => 'roofing_solutions_logobg_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_menubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_menubg_color', array(
		'label' => __('Menu BG Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_topbar',
		'settings' => 'roofing_solutions_menubg_color',
	)));

	//home page slider
	$wp_customize->add_section( 'roofing_solutions_slidersettings' , array(
    	'title'      => esc_html__( 'Slider Settings', 'roofing-solutions' ),
		'priority'   => null,
		'panel' => 'roofing_solutions_panel_id'
	) );

	$wp_customize->add_setting('roofing_solutions_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'roofing_solutions_sanitize_checkbox'
	));
	$wp_customize->add_control('roofing_solutions_slider_hide_show',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'roofing-solutions' ),
	   'label' => esc_html__('Show / Hide slider','roofing-solutions'),
	   'section' => 'roofing_solutions_slidersettings',
	));

	//This is onload transaction effect
	$wp_customize->add_setting('roofing_solutions_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'roofing_solutions_sanitize_choices'
	));
	$wp_customize->add_control('roofing_solutions_slider_animation', array(
		'section'  => 'roofing_solutions_slidersettings',
		'label'    => __( 'Onload Transaction Effect','roofing-solutions'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'roofing-solutions'),
			'bounceInRight' => __('bounceInRight', 'roofing-solutions'),
			'bounceInUp' => __('bounceInUp', 'roofing-solutions'),
			'bounceInDown' => __('bounceInDown', 'roofing-solutions'),
			'zoomIn' => __('zoomIn', 'roofing-solutions'),
			'zoomOut' => __('zoomOut', 'roofing-solutions'),
			'fadeInLeft' => __('fadeInLeft', 'roofing-solutions'),
			'fadeInRight' => __('fadeInRight', 'roofing-solutions'),
			'fadeInUp' => __('fadeInUp', 'roofing-solutions'),
			'fadeInDown' => __('fadeInDown', 'roofing-solutions'),
			'flip-up' => __('flip-up', 'roofing-solutions'),
			'none' => __('none', 'roofing-solutions')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'roofing_solutions_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'roofing_solutions_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'roofing_solutions_slider_page' . $count, array(
			'label'    => esc_html__( 'Select Slider Page', 'roofing-solutions' ),
			'section'  => 'roofing_solutions_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('roofing_solutions_slider_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_slider_title_font_size',array(
		'label'	=> __('Title Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('roofing_solutions_slider_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_slider_text_font_size',array(
		'label'	=> __('Text Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('roofing_solutions_slider_btn_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_slider_btn_font_size',array(
		'label'	=> __('Button Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'roofing_solutions_slider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_title_color', array(
		'label' => __('Title Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_title_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_slider_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_text_color', array(
		'label' => __('Text Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_text_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_slider_btn_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_btn_color', array(
		'label' => __('Button Text Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_btn_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_btnbg_color', array(
		'label' => __('Button Background Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_btnbg_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_slider_np_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_np_color', array(
		'label' => __('Next Pre Arrow Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_np_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_slider_npbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_slider_npbg_color', array(
		'label' => __('Next Pre Arrow Background Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_slidersettings',
		'settings' => 'roofing_solutions_slider_npbg_color',
	)));

	//home page feature
	$wp_customize->add_section( 'roofing_solutions_featuresettings' , array(
    	'title'      => esc_html__( 'Feature Settings', 'roofing-solutions' ),
		'priority'   => null,
		'panel' => 'roofing_solutions_panel_id'
	) );

	
	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'roofing_solutions_feature_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'roofing_solutions_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'roofing_solutions_feature_page' . $count, array(
			'label'    => esc_html__( 'Select Feature Page', 'roofing-solutions' ),
			'section'  => 'roofing_solutions_featuresettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('roofing_solutions_feature_icon_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_feature_icon_font_size',array(
		'label'	=> __('Icons Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_featuresettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('roofing_solutions_feature_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_feature_title_font_size',array(
		'label'	=> __('Title Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_featuresettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('roofing_solutions_feature_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_feature_text_font_size',array(
		'label'	=> __('Text Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_featuresettings',
		'type'	 => 'number'
	));

	// Services Section
	$wp_customize->add_section('roofing_solutions_services_section',array(
		'title'	=> __('Services Section','roofing-solutions'),
		'panel' => 'roofing_solutions_panel_id',
	));

	$wp_customize->add_setting('roofing_solutions_btn_serviceheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_btn_serviceheading',array(
		'label'	=> __('Heading','roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('roofing_solutions_services_heading_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_services_heading_font_size',array(
		'label'	=> __('Heading Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'roofing_solutions_service_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_heading_color', array(
		'label' => __('Heading Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_heading_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_service_headingbdr_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_headingbdr_color', array(
		'label' => __('Heading Border Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_headingbdr_color',
	)));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('roofing_solutions_service_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'roofing_solutions_sanitize_choices',
	));
	$wp_customize->add_control('roofing_solutions_service_category',array(
		'type'    => 'select',
		'choices' => $cat_post,
		'label' => esc_html__('Select Category To Display Post','roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
	));

	$wp_customize->add_setting('roofing_solutions_services_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_services_font_size',array(
		'label'	=> __('Title Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('roofing_solutions_services_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('roofing_solutions_services_text_font_size',array(
		'label'	=> __('Text Font Size','roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'roofing_solutions_service_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_title_color', array(
		'label' => __('Title Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_title_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_service_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_text_color', array(
		'label' => __('Text Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_text_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_service_btn_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_btn_color', array(
		'label' => __('Button Text Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_btn_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_service_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_service_btnbg_color', array(
		'label' => __('Button BG Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_services_section',
		'settings' => 'roofing_solutions_service_btnbg_color',
	)));

	//footer
	$wp_customize->add_section('roofing_solutions_footer_section',array(
		'title'	=> esc_html__('Footer Text','roofing-solutions'),
		'panel' => 'roofing_solutions_panel_id'
	));
		
	$wp_customize->add_setting('roofing_solutions_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('roofing_solutions_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','roofing-solutions'),
		'section'	=> 'roofing_solutions_footer_section',
		'type'		=> 'text'
	));

	//Wocommerce Shop Page
	$wp_customize->add_section('roofing_solutions_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','roofing-solutions'),
		'panel' => 'roofing_solutions_panel_id'
	));

	$wp_customize->add_setting( 'roofing_solutions_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'roofing_solutions_sanitize_choices',
	) );
	$wp_customize->add_control( 'roofing_solutions_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'roofing-solutions' ),
		'description'	=> __('How many products should be shown per Column?','roofing-solutions'),
		'section'  => 'roofing_solutions_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('roofing_solutions_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'roofing_solutions_sanitize_float',
	));	
	$wp_customize->add_control('roofing_solutions_products_per_page',array(
		'label'	=> __('Product Per Page','roofing-solutions'),
		'description'	=> __('How many products should be shown per page?','roofing-solutions'),
		'section'	=> 'roofing_solutions_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'roofing_solutions_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_woocommerce_shop_page',
		'settings' => 'roofing_solutions_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'roofing_solutions_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_woocommerce_shop_page',
		'settings' => 'roofing_solutions_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'roofing_solutions_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_product_sale_color', array(
		'label' => __('Sale Badge Color', 'roofing-solutions'),
		'section' => 'roofing_solutions_woocommerce_shop_page',
		'settings' => 'roofing_solutions_product_sale_color',
	)));


	// logo site title
	$wp_customize->add_setting('roofing_solutions_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'roofing_solutions_sanitize_float'
	));
	$wp_customize->add_control('roofing_solutions_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','roofing-solutions'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('roofing_solutions_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'roofing_solutions_sanitize_checkbox'
    ));
    $wp_customize->add_control('roofing_solutions_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','roofing-solutions'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'roofing_solutions_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_site_title_color', array(
		'label' => __('Site Title Color', 'roofing-solutions'),
		'section' => 'title_tagline',
		'settings' => 'roofing_solutions_site_title_color',
	)));

    $wp_customize->add_setting( 'roofing_solutions_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'roofing_solutions_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'roofing-solutions'),
		'section' => 'title_tagline',
		'settings' => 'roofing_solutions_site_tagline_color',
	)));
}
add_action( 'customize_register', 'roofing_solutions_customize_register' );