<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'real_industry_above_slider' ); ?>

  <?php if( get_theme_mod('real_industry_slider_hide_show', false) != ''){ ?> 

    <section id="slider" class="m-0 p-0 mw-100">
      <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
        <?php $real_industry_content_pages = array();
          for ( $count = 1; $count <= 4; $count++ ) {
            $mod = intval( get_theme_mod( 'real_industry_slider_page' . $count ));
            if ( 'page-none-selected' != $mod ) {
              $real_industry_content_pages[] = $mod;
            }
          }
          if( !empty($real_industry_content_pages) ) :
            $args = array(
              'post_type' => 'page',
              'post__in' => $real_industry_content_pages,
              'orderby' => 'post__in'
            );
            $query = new WP_Query( $args );
          if ( $query->have_posts() ) :
            $i = 1;
        ?>     
        <div class="carousel-inner" role="listbox">
          <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
            <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>             
              <div class="sliderbg-img">
                  <?php the_post_thumbnail(); ?>
                  <div class="slide-oly"></div>
                  <div class="s-gradient"></div>
                  <div class="slider-net"></div>
                  
              </div>
              <?php
                  $real_industry_slider_animation = get_theme_mod('real_industry_slider_animation', '')
                ?>
              <div class="slider-content <?php echo ($real_industry_slider_animation)?>">
                  <div class="inner_carousel">
                    <?php if(get_theme_mod('real_industry_slidersubtitle') != ''){ ?>
                      <p class="s_titile"><?php echo esc_html(get_theme_mod('real_industry_slidersubtitle')); ?></p>
                    <?php }?>
                    <h2><?php the_title(); ?></h2>
                    <p>
                      <?php $real_industry_excerpt = get_the_excerpt(); echo esc_html( real_industry_string_limit_words( $real_industry_excerpt,20 ) ); ?>
                    </p>
                    <div class="read-btn">
                      <a href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e( 'Read More', 'real-industry' ); ?><span><i class="fa fa-angle-double-down"></i></span></a>
                    </div>
                  </div>
              </div>
            </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>
            
        </div>

        <div class="btmsec">
            <div class="row m-0">
                <div class="col-lg-6 col-md-6 col-sm-6 pd-0 ">
                    <div class="phoneno">
                      <?php if(get_theme_mod('real_industry_phone') != ''){ ?>
                        <a href="tel:<?php echo esc_attr(get_theme_mod('real_industry_phone')); ?>"><i class="fas fa-phone me-2"></i>
                        <div class="phtxt"><?php echo esc_html(get_theme_mod('real_industry_phone')); ?></div>
                      </a>
                      <?php }?>
                    </div>
                </div>

                <div class=" col-lg-5 offset-lg-1 col-md-6 col-sm-6 pd-0">
                    <div class="social-icons">
                      <?php if(get_theme_mod('real_industry_facebook_url') != '') {?>
                        <a href="<?php echo esc_url(get_theme_mod('real_industry_facebook_url')); ?>" target="_blank"><i class="fab fa-facebook-f"></i><span class="screen-reader-text"><?php echo esc_html('Facebook', 'real-industry'); ?></span></a>
                      <?php }?>
                      <?php if(get_theme_mod('real_industry_instagram_url') != '') {?>
                        <a href="<?php echo esc_url(get_theme_mod('real_industry_instagram_url')); ?>" target="_blank"><i class="fab fa-instagram"></i><span class="screen-reader-text"><?php echo esc_html('Instagram', 'real-industry'); ?></span></a>
                      <?php }?>
                      <?php if(get_theme_mod('real_industry_likedin_url') != '') {?>
                        <a href="<?php echo esc_url(get_theme_mod('real_industry_likedin_url')); ?>" target="_blank"><i class="fab fa-linkedin-in"></i><span class="screen-reader-text"><?php echo esc_html('Linkedin', 'real-industry'); ?></span></a>
                      <?php }?>
                      <?php if(get_theme_mod('real_industry_twitter_url') != '') {?>
                        <a href="<?php echo esc_url(get_theme_mod('real_industry_twitter_url')); ?>" target="_blank"><i class="fab fa-twitter"></i><span class="screen-reader-text"><?php echo esc_html('Twitter', 'real-industry'); ?></span></a>
                      <?php }?>
                    </div>
                </div>
            </div>
        </div>
        <?php else : ?>
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <div class="npbtn">
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fa fa-angle-double-left" aria-hidden="true"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous', 'real-industry' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fa fa-angle-double-right" aria-hidden="true"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next', 'real-industry' );?></span>
        </a>
        </div>
      </div>   
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'real_industry_below_slider' ); ?>

    <section id="aboutus-section">
      <div class="container">
        <div class="row m-0">
          <div class="col-lg-7 col-md-12 col-sm-12">
            <div class="head">
                <h3 class="title"><?php echo esc_html(get_theme_mod('real_industry_aboutustitle')); ?></h3> 
            </div>
            <p class="subtitle"><?php echo esc_html(get_theme_mod('real_industry_aboutussubtitle')); ?></p>

            <div class="aboutus-content">
              <p class="description"><?php echo esc_html(get_theme_mod('real_industry_aboutusdescription')); ?></p>
              <ul>
                <li><?php echo esc_html(get_theme_mod('real_industry_aboutuslist1')); ?></li>
                <li><?php echo esc_html(get_theme_mod('real_industry_aboutuslist2')); ?></li>
              </ul>
              <div class="aboutus-btn">
                <?php if(get_theme_mod('real_industry_aboutusbtntext') != '') {?>
                  <a href="<?php echo esc_html(get_theme_mod('real_industry_aboutusbtnlinks')); ?>"><?php echo esc_html(get_theme_mod('real_industry_aboutusbtntext')); ?><span><i class="fa fa-angle-double-down"></i></span></a>
                <?php }?>
              </div>
            </div>
          </div> 
          
          <div class="col-lg-5 col-md-12 col-sm-12">
              <div class="allimageslide">
                  <div class="image image1">
                    <?php 
                      $real_industry_aboutus_image1 = get_theme_mod('real_industry_aboutus_image1');

                      if(!empty($real_industry_aboutus_image1)){
                        echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($real_industry_aboutus_image1).'" class="img-responsive secondry-bg-img" />';
                      }else{
                        echo '<img alt="real_industry_aboutus_image1" src="'.get_template_directory_uri().'/assets/images/about.jpg" class="img-responsive" />';
                      }
                    ?>
                  </div>
                  <div class="image image2">
                    <?php 
                      $real_industry_aboutus_image2 = get_theme_mod('real_industry_aboutus_image2');

                      if(!empty($real_industry_aboutus_image2)){
                        echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($real_industry_aboutus_image2).'" class="img-responsive secondry-bg-img" />';
                      }else{
                        echo '<img alt="real_industry_aboutus_image2" src="'.get_template_directory_uri().'/assets/images/abt2.jpg" class="img-responsive" />';
                      }
                    ?>
                  </div>
                  <div class="image image3">
                    <?php 
                      $real_industry_aboutus_image3 = get_theme_mod('real_industry_aboutus_image3');

                      if(!empty($real_industry_aboutus_image3)){
                        echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($real_industry_aboutus_image3).'" class="img-responsive secondry-bg-img" />';
                      }else{
                        echo '<img alt="real_industry_aboutus_image3" src="'.get_template_directory_uri().'/assets/images/abt3.jpg" class="img-responsive" />';
                      }
                    ?>
                  </div>
              </div>
          </div>
        </div>
      </div>
    </section>

  <?php if( get_theme_mod('real_industry_service_category') != ''){ ?>

    <section id="service-section" >
      <div class="container">
        <?php if(get_theme_mod('real_industry_btn_serviceheading') != ''){ ?>
          <div class="service-head">
              <h4>
                  
                <?php echo esc_html(get_theme_mod('real_industry_btn_serviceheading')); ?>
                  
            </h4>

            <h6><?php echo esc_html(get_theme_mod('real_industry_btn_servicesubheading')); ?></h6>
          </div>
        <?php }?>

        <div class="row mr-0">
          <?php $real_industry_catData =  get_theme_mod('real_industry_service_category');
          if($real_industry_catData){
            $page_query = new WP_Query(array( 'category_name' => esc_html($real_industry_catData,'real-industry')));

            while( $page_query->have_posts() ) : $page_query->the_post();
            $sequence_number = $page_query->current_post + 1; // Get the post index and add 1 to start from 1

            ?>  
              
              <div class="col-lg-4 col-md-6 col-sm-6  serbx ">
                <div class="service-box text-center ">
                  <div class="service-img">
                    <?php the_post_thumbnail(); ?>
                      <div class="service-content">
                          <div class="number">
                            <h3>0<?php echo $sequence_number; ?></h3>
                          </div>

                          <a href="<?php echo esc_url( get_permalink() );?>">
                              <div class="title"><?php the_title();?></div>
                          </a>

                          <p>
                            <?php $real_industry_excerpt = get_the_excerpt(); echo esc_html( real_industry_string_limit_words( $real_industry_excerpt,20 ) ); ?> 
                          </p>
                          <div class="button"><a href="<?php the_permalink(); ?>"><span><?php echo esc_html('Read More', 'real-industry'); ?></span></a></div>
                      </div>
                    
                      <div class="clearfix"></div>
                  </div>
                  
                </div>
                <div class="clearfix"></div>
              </div>
              <!-- </div> -->
            <?php endwhile; 
            wp_reset_postdata();
          } ?>
        </div>
        <div class="service-bottmbtn">
          <?php if(get_theme_mod('real_industry_servicebtmbtntext') != '') {?>
            <a href="<?php echo esc_html(get_theme_mod('real_industry_servicebtmbtnlinks')); ?>"><?php echo esc_html(get_theme_mod('real_industry_servicebtmbtntext')); ?><span><i class="fa fa-angle-double-down"></i></span></a>
          <?php }?>
        </div>
      </div>
      <div class="clearfix"></div>
    </section>
  <?php }?>
  <?php do_action( 'real_industry_below_best_sellers' ); ?>

  <!-- <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div> -->
</main>
<?php get_footer(); ?>