<?php
/**
 * Real Industry Theme Customizer
 *
 * @package Real Industry
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Real_Industry_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Real_Industry_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Real_Industry_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Real Industry Pro', 'real-industry' ),
					'pro_text' => esc_html__( 'Go Pro', 'real-industry' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/product/themes/industry-wp-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'real-industry-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'real-industry-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Real_Industry_Customize::get_instance();

function real_industry_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'real_industry_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'real-industry' ),
	) );

	//Select width layout
    $wp_customize->add_setting('real_industry_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control('real_industry_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','real-industry'),
        'section' => 'real_industry_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','real-industry'),
            'Contained Width' => esc_html__('Contained Width','real-industry'),
            'Boxed Width' => esc_html__('Boxed Width','real-industry'),
        ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'real_industry_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'real-industry' ),
		'priority'   => null,
		'panel' => 'real_industry_panel_id'
	) );

	$wp_customize->add_setting('real_industry_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control('real_industry_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'real-industry' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'real-industry' ),
        'section' => 'real_industry_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','real-industry'),
            'Three Columns' => esc_html__('Three Columns','real-industry'),
            'Four Columns' => esc_html__('Four Columns','real-industry'),
            'Right Sidebar' => esc_html__('Right Sidebar','real-industry'),
            'Left Sidebar' => esc_html__('Left Sidebar','real-industry'),
            'Grid Layout' => esc_html__('Grid Layout','real-industry')
        ),
	));

	$wp_customize->add_setting('real_industry_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control('real_industry_dropdown_anim', array(
		'section'  => 'real_industry_left_right',
		'label'    => __( 'Submenu Dropdown Effect','real-industry'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'real-industry'),
			'zoomIn' => __('zoomIn', 'real-industry'),
			'flip-up' => __('flip-up', 'real-industry'),
			'none' => __('none', 'real-industry')
		)
	));

	$real_industry_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'real_industry_typography', array(
    	'title'      => __( 'Typography', 'real-industry' ),
		'priority'   => null,
		'panel' => 'real_industry_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'real_industry_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_paragraph_color', array(
		'label' => __('Paragraph Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('real_industry_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_paragraph_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'Paragraph Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	$wp_customize->add_setting('real_industry_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'real_industry_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_atag_color', array(
		'label' => __('"a" Tag Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('real_industry_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_atag_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( '"a" Tag Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'real_industry_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_li_color', array(
		'label' => __('"li" Tag Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('real_industry_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_li_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( '"li" Tag Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'real_industry_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h1_color', array(
		'label' => __('H1 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h1_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H1 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('real_industry_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h1_font_size',array(
		'label'	=> __('H1 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'real_industry_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h2_color', array(
		'label' => __('H2 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h2_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H2 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('real_industry_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h2_font_size',array(
		'label'	=> __('H2 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'real_industry_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h3_color', array(
		'label' => __('H3 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h3_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H3 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('real_industry_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h3_font_size',array(
		'label'	=> __('H3 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'real_industry_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h4_color', array(
		'label' => __('H4 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h4_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H4 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('real_industry_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h4_font_size',array(
		'label'	=> __('H4 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'real_industry_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h5_color', array(
		'label' => __('H5 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h5_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H5 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('real_industry_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h5_font_size',array(
		'label'	=> __('H5 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'real_industry_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_h6_color', array(
		'label' => __('H6 Color', 'real-industry'),
		'section' => 'real_industry_typography',
		'settings' => 'real_industry_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('real_industry_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'real_industry_h6_font_family', array(
	    'section'  => 'real_industry_typography',
	    'label'    => __( 'H6 Fonts','real-industry'),
	    'type'     => 'select',
	    'choices'  => $real_industry_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('real_industry_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_h6_font_size',array(
		'label'	=> __('H6 Font Size','real-industry'),
		'section'	=> 'real_industry_typography',
		'setting'	=> 'real_industry_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('real_industry_topbar',array(
		'title'	=> esc_html__('Topbar','real-industry'),
		'priority'	=> null,
		'panel' => 'real_industry_panel_id',
	));

	$wp_customize->add_setting( 'real_industry_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'real_industry_sanitize_checkbox'
    ) );
    $wp_customize->add_control('real_industry_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'real-industry' ),
        'label' => __( 'Sticky Header','real-industry' ),
        'section' => 'real_industry_topbar'
    ));

	$wp_customize->add_setting('real_industry_topheadtext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_topheadtext',array(
		'label'	=> __('Add Top Head Text','real-industry'),
		'section' => 'real_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_location',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_location',array(
		'label'	=> __('Add Location','real-industry'),
		'section' => 'real_industry_topbar',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('real_industry_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_mail',array(
		'label'	=> __('Add Mail','real-industry'),
		'section' => 'real_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'real_industry_topheadbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_topheadbg_color', array(
		'label' => __('Top Header BG Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_topheadbg_color',
	)));

	$wp_customize->add_setting( 'real_industry_topheadtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_topheadtext_color', array(
		'label' => __('Top Head Text Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_topheadtext_color',
	)));

	$wp_customize->add_setting( 'real_industry_topheadtexthover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_topheadtexthover_color', array(
		'label' => __('Top Head Text Hover Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_topheadtexthover_color',
	)));

	$wp_customize->add_setting( 'real_industry_topheadicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_topheadicon_color', array(
		'label' => __('Top Head Icon Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_topheadicon_color',
	)));

	$wp_customize->add_setting( 'real_industry_headermenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headermenu_color', array(
		'label' => __('Menu Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headermenu_color',
	)));

	$wp_customize->add_setting( 'real_industry_headeractivemenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headeractivemenuhover_color', array(
		'label' => __('Active Menu & Hover Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headeractivemenuhover_color',
	)));

	$wp_customize->add_setting( 'real_industry_headeractivemenuhoverbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headeractivemenuhoverbg_color', array(
		'label' => __('Active Menu & Hover BG Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headeractivemenuhoverbg_color',
	)));

	$wp_customize->add_setting( 'real_industry_headersubmenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headersubmenu_color', array(
		'label' => __('Submenu Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headersubmenu_color',
	)));
	
	$wp_customize->add_setting( 'real_industry_headersubmenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headersubmenuhover_color', array(
		'label' => __('Submenu Hover Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headersubmenuhover_color',
	)));

	$wp_customize->add_setting( 'real_industry_headersubmenubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headersubmenubg_color', array(
		'label' => __('Submenu BG Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headersubmenubg_color',
	)));

	$wp_customize->add_setting( 'real_industry_headersubmenubghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_headersubmenubghover_color', array(
		'label' => __('Submenu BG Hover Color', 'real-industry'),
		'section' => 'real_industry_topbar',
		'settings' => 'real_industry_headersubmenubghover_color',
	)));


	//home page slider
	$wp_customize->add_section( 'real_industry_slidersettings' , array(
    	'title'      => esc_html__( 'Slider Settings', 'real-industry' ),
		'priority'   => null,
		'panel' => 'real_industry_panel_id'
	) );

	$wp_customize->add_setting('real_industry_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'real_industry_sanitize_checkbox'
	));
	$wp_customize->add_control('real_industry_slider_hide_show',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'real-industry' ),
	   'label' => esc_html__('Show / Hide slider','real-industry'),
	   'section' => 'real_industry_slidersettings',
	));

	//This is onload transaction effect
	$wp_customize->add_setting('real_industry_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'real_industry_sanitize_choices'
	));
	$wp_customize->add_control('real_industry_slider_animation', array(
		'section'  => 'real_industry_slidersettings',
		'label'    => __( 'Onload Transaction Effect','real-industry'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'real-industry'),
			'bounceInRight' => __('bounceInRight', 'real-industry'),
			'bounceInUp' => __('bounceInUp', 'real-industry'),
			'bounceInDown' => __('bounceInDown', 'real-industry'),
			'zoomIn' => __('zoomIn', 'real-industry'),
			'zoomOut' => __('zoomOut', 'real-industry'),
			'fadeInLeft' => __('fadeInLeft', 'real-industry'),
			'fadeInRight' => __('fadeInRight', 'real-industry'),
			'fadeInUp' => __('fadeInUp', 'real-industry'),
			'fadeInDown' => __('fadeInDown', 'real-industry'),
			'flip-up' => __('flip-up', 'real-industry'),
			'none' => __('none', 'real-industry')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'real_industry_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'real_industry_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'real_industry_slider_page' . $count, array(
			'label'    => esc_html__( 'Select Slider Page', 'real-industry' ),
			'section'  => 'real_industry_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('real_industry_slidertitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_slidertitle_font_size',array(
		'label'	=> __('Title Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_slidersubtitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_slidersubtitle_font_size',array(
		'label'	=> __('Subtitle Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_slidertext_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_slidertext_font_size',array(
		'label'	=> __('Text Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_sliderbtn_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_sliderbtn_font_size',array(
		'label'	=> __('Button Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_slidersubtitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_slidersubtitle',array(
		'label'	=> __('Add Slider Subtitle','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_phone',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_phone',array(
		'label'	=> __('Add Phone Number','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_phone_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_phone_font_size',array(
		'label'	=> __('Phone Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('real_industry_facebook_url',array(
		'label'	=> __('Add Facebook URL','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('real_industry_instagram_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('real_industry_instagram_url',array(
		'label'	=> __('Add Instagram URL','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('real_industry_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('real_industry_twitter_url',array(
		'label'	=> __('Add Twitter URL','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('real_industry_likedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('real_industry_likedin_url',array(
		'label'	=> __('Add Linkedin URL','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	  => 'text'
	));

	$wp_customize->add_setting('real_industry_social_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_social_font_size',array(
		'label'	=> __('Icons Font Size','real-industry'),
		'section' => 'real_industry_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'real_industryslider_subtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_subtitle_color', array(
		'label' => __('Subtitle Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_subtitle_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_subtitlebdr_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_subtitlebdr_color', array(
		'label' => __('Subtitle Border Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_subtitlebdr_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_title_color', array(
		'label' => __('Title Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_title_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_description_color', array(
		'label' => __('Description Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_description_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btntext_color', array(
		'label' => __('Button Text Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btntext_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btnbg_color', array(
		'label' => __('Button BG Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btnbg_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btntexthover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btntexthover_color', array(
		'label' => __('Button Text Hover Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btntexthover_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btnbghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btnbghover_color', array(
		'label' => __('Button BG Hover Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btnbghover_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btnicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btnicon_color', array(
		'label' => __('Button Icon Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btnicon_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_btniconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_btniconbg_color', array(
		'label' => __('Button Icon BG Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_btniconbg_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_phonenumbericon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_phonenumbericon_color', array(
		'label' => __('Phone Number Icon Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_phonenumbericon_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_phonenumbericonbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_phonenumbericonbg_color', array(
		'label' => __('Phone Number Icon BG Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_phonenumbericonbg_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_phonenumber_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_phonenumber_color', array(
		'label' => __('Phone Number Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_phonenumber_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_socialicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_socialicon_color', array(
		'label' => __('Social Icon Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_socialicon_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_socialiconhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_socialiconhover_color', array(
		'label' => __('Social Icon Hover Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_socialiconhover_color',
	)));

	$wp_customize->add_setting( 'real_industryslider_bottomboxbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryslider_bottomboxbg_color', array(
		'label' => __('Bottom Box BG Color', 'real-industry'),
		'section' => 'real_industry_slidersettings',
		'settings' => 'real_industryslider_bottomboxbg_color',
	)));



	// aboutus Section
	$wp_customize->add_section('real_industry_aboutus_section',array(
		'title'	=> __('AboutUs Section','real-industry'),
		'panel' => 'real_industry_panel_id',
	));

	$wp_customize->add_setting('real_industry_aboutustitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutustitle',array(
		'label'	=> __('Title','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutussubtitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutussubtitle',array(
		'label'	=> __('Sub Title','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutusdescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutusdescription',array(
		'label'	=> __('Description','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutuslist1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutuslist1',array(
		'label'	=> __('List 1','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutuslist2',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutuslist2',array(
		'label'	=> __('List 2','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutus_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutus_title_font_size',array(
		'label'	=> __('Title Font Size','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_aboutus_subtitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutus_subtitle_font_size',array(
		'label'	=> __('Subtitle Font Size','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_aboutus_desc_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutus_desc_font_size',array(
		'label'	=> __('Description Font Size','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'number'
	));
	
	$wp_customize->add_setting('real_industry_aboutus_list_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutus_list_font_size',array(
		'label'	=> __('List Font Size','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_aboutusbtntext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutusbtntext',array(
		'label'	=> __('Button Text','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutusbtnlinks',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutusbtnlinks',array(
		'label'	=> __('Button Link','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_aboutusbtntext_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_aboutusbtntext_font_size',array(
		'label'	=> __('Button Font Size','real-industry'),
		'section' => 'real_industry_aboutus_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting(
    	'real_industry_aboutus_image1',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'real_industry_aboutus_image1',
	        array(
			    'label'   		=> __('Image 1','real-industry'),
				'description'   		=> __('Image size 417*546','real-industry'),
	            'section' => 'real_industry_aboutus_section',
	            'settings' => 'real_industry_aboutus_image1',
	        )
	    )
	);

	$wp_customize->add_setting( 'real_industryaboutus_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_title_color', array(
		'label' => __('Title Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_title_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_titleborder_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_titleborder_color', array(
		'label' => __('Title Border Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_titleborder_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_subtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_subtitle_color', array(
		'label' => __('Sub Title Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_subtitle_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_description_color', array(
		'label' => __('Description Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_description_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_list_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_list_color', array(
		'label' => __('List Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_list_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btntext_color', array(
		'label' => __('Button Text Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btntext_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btnbg_color', array(
		'label' => __('Button BG Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btnbg_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btntexthover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btntexthover_color', array(
		'label' => __('Button Text Hover Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btntexthover_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btnbghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btnbghover_color', array(
		'label' => __('Button BG Hover Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btnbghover_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btnicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btnicon_color', array(
		'label' => __('Button Icon Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btnicon_color',
	)));

	$wp_customize->add_setting( 'real_industryaboutus_btniconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryaboutus_btniconbg_color', array(
		'label' => __('Button Icon BG Color', 'real-industry'),
		'section' => 'real_industry_aboutus_section',
		'settings' => 'real_industryaboutus_btniconbg_color',
	)));
	




	// Services Section
	$wp_customize->add_section('real_industry_services_section',array(
		'title'	=> __('Services Section','real-industry'),
		'panel' => 'real_industry_panel_id',
	));

	$wp_customize->add_setting('real_industry_btn_serviceheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_btn_serviceheading',array(
		'label'	=> __('Heading','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_btn_servicesubheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_btn_servicesubheading',array(
		'label'	=> __('Sub Heading','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_services_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_services_title_font_size',array(
		'label'	=> __('Title Font Size','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('real_industry_services_subtitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_services_subtitle_font_size',array(
		'label'	=> __('Subtitle Font Size','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'number'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('real_industry_service_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'real_industry_sanitize_choices',
	));
	$wp_customize->add_control('real_industry_service_category',array(
		'type'    => 'select',
		'choices' => $cat_post,
		'label' => esc_html__('Select Category To Display Post','real-industry'),
		'section' => 'real_industry_services_section',
	));

	$wp_customize->add_setting('real_industry_servicebtmbtntext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_servicebtmbtntext',array(
		'label'	=> __('Button Text','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('real_industry_servicebtmbtnlinks',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_servicebtmbtnlinks',array(
		'label'	=> __('Button Link','real-industry'),
		'section' => 'real_industry_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'real_industryservices_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_heading_color', array(
		'label' => __('Heading Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_heading_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_headingbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_headingbrd_color', array(
		'label' => __('Heading Border Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_headingbrd_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_subheading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_subheading_color', array(
		'label' => __('Sub Heading Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_subheading_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_number_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_number_color', array(
		'label' => __('Number Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_number_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_title_color', array(
		'label' => __('Title Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_title_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_description_color', array(
		'label' => __('Description Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_description_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_readmore_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_readmore_color', array(
		'label' => __('Read More Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_readmore_color',
	)));

	$wp_customize->add_setting( 'real_industryservices_readmorehover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryservices_readmorehover_color', array(
		'label' => __('Read More Hover Color', 'real-industry'),
		'section' => 'real_industry_services_section',
		'settings' => 'real_industryservices_readmorehover_color',
	)));


	//footer
	$wp_customize->add_section('real_industry_footer_section',array(
		'title'	=> esc_html__('Footer Text','real-industry'),
		'panel' => 'real_industry_panel_id'
	));
		
	$wp_customize->add_setting('real_industry_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('real_industry_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','real-industry'),
		'section'	=> 'real_industry_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('real_industry_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('real_industry_footer_copy_font_size',array(
		'label'	=> __('Copyright Font Size','real-industry'),
		'section' => 'real_industry_footer_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'real_industryfooter_copyrighttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryfooter_copyrighttext_color', array(
		'label' => __('Copyright Text Color', 'real-industry'),
		'section' => 'real_industry_footer_section',
		'settings' => 'real_industryfooter_copyrighttext_color',
	)));

	$wp_customize->add_setting( 'real_industryfooter_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryfooter_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'real-industry'),
		'section' => 'real_industry_footer_section',
		'settings' => 'real_industryfooter_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'real_industryfooter_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryfooter_bg_color', array(
		'label' => __('BG Color', 'real-industry'),
		'section' => 'real_industry_footer_section',
		'settings' => 'real_industryfooter_bg_color',
	)));

	$wp_customize->add_setting( 'real_industryfooter_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industryfooter_text_color', array(
		'label' => __('Text Color', 'real-industry'),
		'section' => 'real_industry_footer_section',
		'settings' => 'real_industryfooter_text_color',
	)));



	//Wocommerce Shop Page
	$wp_customize->add_section('real_industry_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','real-industry'),
		'panel' => 'real_industry_panel_id'
	));

	$wp_customize->add_setting( 'real_industry_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'real_industry_sanitize_choices',
	) );
	$wp_customize->add_control( 'real_industry_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'real-industry' ),
		'description'	=> __('How many products should be shown per Column?','real-industry'),
		'section'  => 'real_industry_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('real_industry_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'real_industry_sanitize_float',
	));	
	$wp_customize->add_control('real_industry_products_per_page',array(
		'label'	=> __('Product Per Page','real-industry'),
		'description'	=> __('How many products should be shown per page?','real-industry'),
		'section'	=> 'real_industry_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'real_industry_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'real-industry'),
		'section' => 'real_industry_woocommerce_shop_page',
		'settings' => 'real_industry_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'real_industry_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'real-industry'),
		'section' => 'real_industry_woocommerce_shop_page',
		'settings' => 'real_industry_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'real_industry_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_product_sale_color', array(
		'label' => __('Sale Badge Color', 'real-industry'),
		'section' => 'real_industry_woocommerce_shop_page',
		'settings' => 'real_industry_product_sale_color',
	)));

	// site logo size
	$wp_customize->add_setting('real_industry_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'real_industry_sanitize_float'
	));
	$wp_customize->add_control('real_industry_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','real-industry'),
		'section' => 'title_tagline'
	));


	// logo site title
	$wp_customize->add_setting('real_industry_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'real_industry_sanitize_checkbox'
    ));
    $wp_customize->add_control('real_industry_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','real-industry'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'real_industry_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_site_title_color', array(
		'label' => __('Site Title Color', 'real-industry'),
		'section' => 'title_tagline',
		'settings' => 'real_industry_site_title_color',
	)));

    $wp_customize->add_setting( 'real_industry_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'real_industry_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'real-industry'),
		'section' => 'title_tagline',
		'settings' => 'real_industry_site_tagline_color',
	)));
}
add_action( 'customize_register', 'real_industry_customize_register' );