<?php
/**
 * Custom template tags for this theme.
 *
 * @package Policyguard Insurance Services
 */


if ( ! function_exists( 'policyguard_insurance_services_the_attached_image' ) ) :
/**
 * Prints the attached image with a link to the next attached image.
 */
function policyguard_insurance_services_the_attached_image() {
	$post                = get_post();
	$attachment_size     = apply_filters( 'policyguard_insurance_services_attachment_size', array( 1200, 1200 ) );
	$next_attachment_url = wp_get_attachment_url();
	$attachment_ids 	 = get_posts( array(
		'post_parent'    => $post->post_parent,
		'fields'         => 'ids',
		'numberposts'    =>  1,
		'post_status'    => 'inherit',
		'post_type'      => 'attachment',
		'post_mime_type' => 'image',
		'order'          => 'ASC',
		'orderby'        => 'menu_order ID'
	) );

	// If there is more than 1 attachment in a gallery...
	if ( count( $attachment_ids ) > 1 ) {
		foreach ( $attachment_ids as $attachment_id ) {
			if ( $attachment_id == $post->ID ) {
				$next_id = current( $attachment_ids );
				break;
			}
		}

		// get the URL of the next image attachment...
		if ( $next_id )
			$next_attachment_url = get_attachment_link( $next_id );

		// or get the URL of the first image attachment.
		else
			$next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
	}

	printf( '<a href="%1$s" rel="attachment">%2$s</a>',
		esc_url( $next_attachment_url ),
		wp_get_attachment_image( $post->ID, $attachment_size )
	);
	wp_reset_postdata();
}
endif;


/**
 * Returns true if a blog has more than 1 category
 */
function policyguard_insurance_services_categorized_blog() {
	if ( false === ( $policyguard_insurance_services_all_the_cool_cats = get_transient( 'policyguard_insurance_services_all_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$policyguard_insurance_services_all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts
		$policyguard_insurance_services_all_the_cool_cats = count( $policyguard_insurance_services_all_the_cool_cats );

		set_transient( 'policyguard_insurance_services_all_the_cool_cats', $policyguard_insurance_services_all_the_cool_cats );
	}

	if ( '1' != $policyguard_insurance_services_all_the_cool_cats ) {
		// This blog has more than 1 category so policyguard_insurance_services_categorized_blog should return true
		return true;
	} else {
		// This blog has only 1 category so policyguard_insurance_services_categorized_blog should return false
		return false;
	}
}

if ( ! function_exists( 'policyguard_insurance_services_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 * @since 1.0
 */
function policyguard_insurance_services_the_custom_logo() {	
	the_custom_logo();
}
endif;

/**
 * Flush out the transients used in policyguard_insurance_services_categorized_blog
 */
function policyguard_insurance_services_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'policyguard_insurance_services_all_the_cool_cats' );
}
add_action( 'edit_category', 'policyguard_insurance_services_category_transient_flusher' );
add_action( 'save_post',     'policyguard_insurance_services_category_transient_flusher' );

/*-- Custom metafield --*/
function policyguard_insurance_services_custom_icon() {
  	add_meta_box( 'bn_meta', __( 'Policyguard Insurance Services Meta Feilds', 'policyguard-insurance-services' ), 'policyguard_insurance_services_meta_icon_callback', 'post', 'normal', 'high' );
}
if (is_admin()){
  	add_action('admin_menu', 'policyguard_insurance_services_custom_icon');
}

function policyguard_insurance_services_meta_icon_callback( $post ) {
  	wp_nonce_field( basename( __FILE__ ), 'policyguard_insurance_services_icon_meta' );
  	$bn_stored_meta = get_post_meta( $post->ID );
  	$policyguard_insurance_services_icon = get_post_meta( $post->ID, 'policyguard_insurance_services_icon', true );
  	if(empty($policyguard_insurance_services_icon)){
	    //add a default value
	    add_post_meta($post->ID, 'policyguard_insurance_services_icon', 'fas fa-print');
    }
  	?>
  	<div id="custom_meta_feilds">
	    <table id="list">
	      	<tbody id="the-list" data-wp-lists="list:meta">
		        <tr id="meta-8">
		          	<td class="left">
		            	<?php esc_html_e( 'Fontawesome icon class', 'policyguard-insurance-services' ); ?>
		          	</td>
		          	<td class="left">
		            	<input type="text" name="policyguard_insurance_services_icon" id="policyguard_insurance_services_icon" value="<?php echo esc_attr($policyguard_insurance_services_icon); ?>" />
		          	</td>
		        </tr>
	      	</tbody>
	    </table>
  	</div>
  	<?php
}

function policyguard_insurance_services_save( $post_id ) {
  	if (!isset($_POST['policyguard_insurance_services_icon_meta']) || !wp_verify_nonce( strip_tags( wp_unslash( $_POST['policyguard_insurance_services_icon_meta']) ), basename(__FILE__))) {
      	return;
  	}
  	if (!current_user_can('edit_post', $post_id)) {
   		return;
  	}
  	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    	return;
  	}
  	if( isset( $_POST[ 'policyguard_insurance_services_icon' ] ) ) {
    	update_post_meta( $post_id, 'policyguard_insurance_services_icon', 'fas fa-print');
  	}
}
add_action( 'save_post', 'policyguard_insurance_services_save' );