<?php
/**
 * Policyguard Insurance Services Theme Customizer
 *
 * @package Policyguard Insurance Services
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Policyguard_Insurance_Services_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Policyguard_Insurance_Services_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Policyguard_Insurance_Services_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Insurance Agency Pro', 'policyguard-insurance-services' ),
					'description' => __( 'Exclusive Discount. Buy now And Enjoy!', 'policyguard-insurance-services' ),
					'pro_text' => esc_html__( 'Go Pro', 'policyguard-insurance-services' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/products/insurance-agency-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'policyguard-insurance-services-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'policyguard-insurance-services-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

function mega_customizer_offer_popup_script() {
    ?>
    <style>
        #mega-offer-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(4px);
            z-index: 999998;
            display: none;
        }
        #mega-offer-popup {
            position: fixed;
            top: 45%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0.8);
            opacity: 0;
            background: #fff;
            border: 2px solid #0073aa;
            padding: 25px 25px 20px;
            z-index: 999999;
            box-shadow: 0 0 30px rgba(0,0,0,0.2);
            max-width: 420px;
            text-align: center;
            font-family: sans-serif;
            border-radius: 10px;
            transition: all 0.4s ease;
        }
        #mega-offer-popup.show {
            opacity: 1;
            transform: translate(-50%, -50%) scale(1);
        }
        #offer-close-icon {
            position: absolute;
            top: 10px;
            right: 12px;
            font-size: 20px;
            color: #333;
            cursor: pointer;
            font-weight: bold;
        }
        #offer-close-icon:hover {
            color: red;
        }
    </style>

    <script>
        (function () {
            document.addEventListener('DOMContentLoaded', function () {
                // Only show once per login session
                if (
                    !sessionStorage.getItem('mega_customizer_offer_shown') &&
                    !document.getElementById('mega-offer-popup') &&
                    !document.getElementById('mega-offer-backdrop')
                ) {
                    const backdrop = document.createElement('div');
                    backdrop.id = 'mega-offer-backdrop';

                    const popup = document.createElement('div');
                    popup.id = 'mega-offer-popup';
                    popup.innerHTML = `
						<div id="offer-close-icon" style="position: absolute; top: 10px; right: 12px; font-size: 20px; font-weight: bold; color: #333; cursor: pointer;">&times;</div>

						<div style="border: 2px solid #0073aa; border-radius: 10px; overflow: hidden; font-family: sans-serif; max-width: 600px; background: white;">

							<div style="background: #4CAF50; color: white; padding: 12px 20px; font-size: 18px; font-weight: bold; text-align: center;">
								🎁 Mega Offer Alert
							</div>

							<div style="display: flex; flex-wrap: wrap; justify-content: center; align-items: center; padding: 20px; gap: 20px;">
								<img src="<?php echo get_theme_file_uri('screenshot.png'); ?>" alt="Theme Preview" style="width: 250px; max-width: 100%; border: 1px solid #ccc; border-radius: 6px;" />

								<div>
									<h3 style="margin: 0 0 10px; font-size: 18px; color: #000;">Policyguard Insurance Services Theme Pro</h3>
									<div style="border: 2px dashed red; border-radius: 10px; padding: 15px; background: #fff5f5; text-align: center;">
										<div style="font-size: 18px; color: red; font-weight: bold;">Get 15% OFF</div>
										<div style="font-size: 14px; color: #555;">Use Code Below:</div>
										<div style="background: red; color: white; padding: 8px 16px; font-weight: bold; margin-top: 8px; display: inline-block; border-radius: 4px;">
											FREEWORDTHEME
										</div>
									</div>
								</div>
							</div>

							<div style="background: #4CAF50; text-align: center;">
								<a href="https://www.logicalthemes.com/products/insurance-agency-wordpress-theme/" target="_blank" style="display: inline-block; padding: 12px 25px; color: white; font-weight: bold; text-decoration: none; font-size: 16px;">Upgrade Now</a>
							</div>
						</div>
					`;

                    document.body.appendChild(backdrop);
                    document.body.appendChild(popup);

                    setTimeout(() => {
                        backdrop.style.display = 'block';
                        popup.classList.add('show');
                    }, 100);

                    popup.querySelector('#offer-close-icon').addEventListener('click', () => {
                        popup.remove();
                        backdrop.remove();
                    });

                    // Only for this session (until logout or browser closed)
                    sessionStorage.setItem('mega_customizer_offer_shown', 'true');
                }
            });
        })();
    </script>
    <?php
}
add_action('customize_controls_print_footer_scripts', 'mega_customizer_offer_popup_script');

// Doing this customizer thang!
Policyguard_Insurance_Services_Customize::get_instance();

function policyguard_insurance_services_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'policyguard_insurance_services_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'policyguard-insurance-services' ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'policyguard_insurance_services_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control('policyguard_insurance_services_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'policyguard-insurance-services' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'policyguard-insurance-services' ),
        'section' => 'policyguard_insurance_services_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','policyguard-insurance-services'),
            'Three Columns' => esc_html__('Three Columns','policyguard-insurance-services'),
            'Four Columns' => esc_html__('Four Columns','policyguard-insurance-services'),
            'Right Sidebar' => esc_html__('Right Sidebar','policyguard-insurance-services'),
            'Left Sidebar' => esc_html__('Left Sidebar','policyguard-insurance-services'),
            'Grid Layout' => esc_html__('Grid Layout','policyguard-insurance-services')
        ),
	));

	$policyguard_insurance_services_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'policyguard_insurance_services_typography', array(
    	'title'      => __( 'Typography', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_paragraph_color', array(
		'label' => __('Paragraph Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_paragraph_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'Paragraph Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	$wp_customize->add_setting('policyguard_insurance_services_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_atag_color', array(
		'label' => __('"a" Tag Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_atag_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( '"a" Tag Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_li_color', array(
		'label' => __('"li" Tag Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_li_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( '"li" Tag Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h1_color', array(
		'label' => __('H1 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h1_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H1 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h1_font_size',array(
		'label'	=> __('H1 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h2_color', array(
		'label' => __('H2 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h2_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H2 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h2_font_size',array(
		'label'	=> __('H2 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h3_color', array(
		'label' => __('H3 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h3_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H3 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h3_font_size',array(
		'label'	=> __('H3 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h4_color', array(
		'label' => __('H4 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h4_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H4 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h4_font_size',array(
		'label'	=> __('H4 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h5_color', array(
		'label' => __('H5 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h5_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H5 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h5_font_size',array(
		'label'	=> __('H5 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'policyguard_insurance_services_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_h6_color', array(
		'label' => __('H6 Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_typography',
		'settings' => 'policyguard_insurance_services_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('policyguard_insurance_services_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices'
	));
	$wp_customize->add_control(
	    'policyguard_insurance_services_h6_font_family', array(
	    'section'  => 'policyguard_insurance_services_typography',
	    'label'    => __( 'H6 Fonts','policyguard-insurance-services'),
	    'type'     => 'select',
	    'choices'  => $policyguard_insurance_services_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('policyguard_insurance_services_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_h6_font_size',array(
		'label'	=> __('H6 Font Size','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_typography',
		'setting'	=> 'policyguard_insurance_services_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('policyguard_insurance_services_topbar',array(
		'title'	=> esc_html__('Header','policyguard-insurance-services'),
		'priority'	=> null,
		'panel' => 'policyguard_insurance_services_panel_id',
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'policyguard_insurance_services_sanitize_checkbox'
    ) );
    $wp_customize->add_control('policyguard_insurance_services_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'policyguard-insurance-services' ),
        'label' => __( 'Sticky Header','policyguard-insurance-services' ),
        'section' => 'policyguard_insurance_services_topbar'
    ));

	$wp_customize->add_setting('policyguard_insurance_services_btn_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btn_text',array(
		'label'	=> __('Add Button Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btn_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btn_link',array(
		'label'	=> __('Button Link','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_bg', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_bg', array(
		'label' => __('BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_bg',
	)));


	$wp_customize->add_setting( 'policyguard_insurance_services_header_menu_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_menu_col', array(
		'label' => __('Menu Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_menu_col',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_menuactivehover_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_menuactivehover_col', array(
		'label' => __('Menu Active & Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_menuactivehover_col',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_submenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_submenu_color', array(
		'label' => __('Submenu Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_submenu_color',
	)));


	$wp_customize->add_setting( 'policyguard_insurance_services_header_submenu_bg_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_submenu_bg_col', array(
		'label' => __('Submenu BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_submenu_bg_col',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_submenu_txthovercolor', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_submenu_txthovercolor', array(
		'label' => __('Submenu Text Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_submenu_txthovercolor',
	)));


	$wp_customize->add_setting( 'policyguard_insurance_services_header_submenubg_hover', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_submenubg_hover', array(
		'label' => __('Submenu BG Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_submenubg_hover',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_btn_text_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_btn_text_col', array(
		'label' => __('Button Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_btn_text_col',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_btn_bg_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_btn_bg_col', array(
		'label' => __('Button BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_btn_bg_col',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_header_btn_bghover_col', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_header_btn_bghover_col', array(
		'label' => __('Button BG Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_topbar',
		'settings' => 'policyguard_insurance_services_header_btn_bghover_col',
	)));

	//home page banner
	$wp_customize->add_section( 'policyguard_insurance_services_bannersettings' , array(
    	'title'      => esc_html__( 'Banner Settings', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_banner_heading',array(
		'default'	=> 'WE ENSURE THE BEST INSURANCE AGENCY.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_banner_heading',array(
		'label'	=> __('Heading','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_banner_description',array(
		'default'	=> 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industrys Standard Dummy Text Ever Since The 1500S, When An Unknown Printer Took A Galley Of Type And Scrambled It To Make A Type Specimen Book. It Has Survived Not Only Five Centuries, But Also The Leap Into Electronic Typesetting, Remaining Essentially Unchanged. It Was Popularised In The 1960S With The Release Of Letraset Sheets Containing Lorem Ipsum Passages, And More Recently With Desktop Publishing Software Like Aldus Pagemaker Including Versions Of Lorem Ipsum.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_banner_description',array(
		'label'	=> __('Description','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_banner_btntext',array(
		'default'	=> 'Start Consultation',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_banner_btntext',array(
		'label'	=> __('Button Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_banner_btnlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_banner_btnlink',array(
		'label'	=> __('Button Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_text',array(
		'default'	=> 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_text',array(
		'label'	=> __('Bottom Banner Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_2xtext',array(
		'default'	=> '2X',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_2xtext',array(
		'label'	=> __('2X Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_2xdescription',array(
		'default'	=> 'Faster Than Any Other Insurance Services',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_2xdescription',array(
		'label'	=> __('2X Description','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_1mtext',array(
		'default'	=> '1M',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_1mtext',array(
		'label'	=> __('1M Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_1mdescription',array(
		'default'	=> 'People Secure Their Future With Our Insurance',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_1mdescription',array(
		'label'	=> __('1M Description','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'banner_profile_img',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_profile_img',
	        array(
			    'label'   		=> __('Profile Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 367*441','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_bannersettings',
	            'settings' => 'banner_profile_img',
	        )
	    )
	);

	$wp_customize->add_setting('policyguard_insurance_services_btmbanner_ouragenttext',array(
		'default'	=> 'Consult With Our Expert Agent',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbanner_ouragenttext',array(
		'label'	=> __('Our Agent Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'banner_ouragent_img1',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_ouragent_img1',
	        array(
			    'label'   		=> __('Agent 1 Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 400*400','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_bannersettings',
	            'settings' => 'banner_ouragent_img1',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'banner_ouragent_img2',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_ouragent_img2',
	        array(
			    'label'   		=> __('Agent 2 Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 400*400','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_bannersettings',
	            'settings' => 'banner_ouragent_img2',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'banner_ouragent_img3',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_ouragent_img3',
	        array(
			    'label'   		=> __('Agent 3 Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 400*400','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_bannersettings',
	            'settings' => 'banner_ouragent_img3',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'banner_ouragent_img4',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'banner_ouragent_img4',
	        array(
			    'label'   		=> __('Agent 4 Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 400*400','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_bannersettings',
	            'settings' => 'banner_ouragent_img4',
	        )
	    )
	);

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox1_percent',array(
		'default'	=> '+1.4%',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox1_percent',array(
		'label'	=> __('Box 1 Percent','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox1_number',array(
		'default'	=> '93,000 +',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox1_number',array(
		'label'	=> __('Box 1 Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox1_numbertext',array(
		'default'	=> 'INSURANCE POLICY PER YEAR',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox1_numbertext',array(
		'label'	=> __('Box 1 Number Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox2_percent',array(
		'default'	=> '-2.9%',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox2_percent',array(
		'label'	=> __('Box 2 Percent','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox2_number',array(
		'default'	=> '32,000 +',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox2_number',array(
		'label'	=> __('Box 2 Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_btmbannerbox2_numbertext',array(
		'default'	=> 'INSURANCE POLICY PER MONTH',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btmbannerbox2_numbertext',array(
		'label'	=> __('Box 2 Number Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_banner_imgopacity',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_banner_imgopacity',array(
		'label'	=> __('BG Graph Image Opacity','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'type'	 => 'range',
		'input_attrs' => array(
			'min' => 0,
			'max' => 1,
			'step' => 0.1,
		)
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_heading_color', array(
		'label' => __('Heading Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_heading_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_description_color', array(
		'label' => __('Description Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_description_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_btntext_color', array(
		'label' => __('Button Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_btntext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_btnbg_color', array(
		'label' => __('Button BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_btnbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_btnbghrv_color', array(
		'label' => __('Button BG Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_btnbghrv_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_btmbannertext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_btmbannertext_color', array(
		'label' => __('Bottom Banner Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_btmbannertext_color',
	)));
	
	$wp_customize->add_setting( 'policyguard_insurance_services_banner_2xtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_2xtext_color', array(
		'label' => __('2X Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_2xtext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_2xdescription_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_2xdescription_color', array(
		'label' => __('2X Description Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_2xdescription_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_1mtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_1mtext_color', array(
		'label' => __('1M Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_1mtext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_1mdescription_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_1mdescription_color', array(
		'label' => __('1M Description Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_1mdescription_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_ouragenttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_ouragenttext_color', array(
		'label' => __('Our Agent Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_ouragenttext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_boxtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_boxtext_color', array(
		'label' => __('Box Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_boxtext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_banner_boxbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_banner_boxbg_color', array(
		'label' => __('Box BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_bannersettings',
		'settings' => 'policyguard_insurance_services_banner_boxbg_color',
	)));


	//home page trustedbycompanies
	$wp_customize->add_section( 'policyguard_insurance_services_trustedbycompanies' , array(
    	'title'      => esc_html__( 'Trusted By Companies Settings', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_trustedbycompaniestext',array(
		'default'	=> 'Trusted By The Top 100+ Companies Worldwide',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_trustedbycompaniestext',array(
		'label'	=> __('Trusted By Companies Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_trustedbycompanies',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'trustedbycompanies_logo1',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'trustedbycompanies_logo1',
	        array(
			    'label'   		=> __('Trusted By Companies Logo 1','policyguard-insurance-services'),
				'description'   		=> __('Image size 512*512','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_trustedbycompanies',
	            'settings' => 'trustedbycompanies_logo1',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'trustedbycompanies_logo2',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'trustedbycompanies_logo2',
	        array(
			    'label'   		=> __('Trusted By Companies Logo 2','policyguard-insurance-services'),
				'description'   		=> __('Image size 512*512','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_trustedbycompanies',
	            'settings' => 'trustedbycompanies_logo2',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'trustedbycompanies_logo3',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'trustedbycompanies_logo3',
	        array(
			    'label'   		=> __('Trusted By Companies Logo 3','policyguard-insurance-services'),
				'description'   		=> __('Image size 512*512','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_trustedbycompanies',
	            'settings' => 'trustedbycompanies_logo3',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'trustedbycompanies_logo4',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'trustedbycompanies_logo4',
	        array(
			    'label'   		=> __('Trusted By Companies Logo 4','policyguard-insurance-services'),
				'description'   		=> __('Image size 512*512','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_trustedbycompanies',
	            'settings' => 'trustedbycompanies_logo4',
	        )
	    )
	);

	$wp_customize->add_setting( 'policyguard_insurance_services_trustedbycompanies_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_trustedbycompanies_text_color', array(
		'label' => __('Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_trustedbycompanies',
		'settings' => 'policyguard_insurance_services_trustedbycompanies_text_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_trustedbycompanies_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_trustedbycompanies_bg_color', array(
		'label' => __('BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_trustedbycompanies',
		'settings' => 'policyguard_insurance_services_trustedbycompanies_bg_color',
	)));


	//home page Aboutus
	$wp_customize->add_section( 'policyguard_insurance_services_aboutussettings' , array(
		'title'      => esc_html__( 'About Us Settings', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutsec_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutsec_color', array(
		'label' => __('Section BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutsec_color',
	)));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_heading',array(
		'default'	=> 'WE ENSURE THE BEST INSURANCE AGENCY.',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_heading',array(
		'label'	=> __('Heading','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('policyguard_insurance_services_aboutus_description',array(
		'default'	=> 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industrys Standard Dummy Text Ever Since The 1500S, When An Unknown Printer Took .',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_description',array(
		'label'	=> __('Description','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('policyguard_insurance_services_aboutus_btntext',array(
		'default'	=> 'About Us',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_btntext',array(
		'label'	=> __('Button Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_btnlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_btnlink',array(
		'label'	=> __('Button Link','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'aboutus_contactagent_img',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_contactagent_img',
	        array(
			    'label'   		=> __('Contact Agent Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 400*400','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_aboutussettings',
	            'settings' => 'aboutus_contactagent_img',
	        )
	    )
	);

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_contacttext',array(
		'default'	=> 'Contact Agent',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_contacttext',array(
		'label'	=> __('Contact Agent Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_phonenumber',array(
		'default'	=> '(+0111) 111 111',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_phonenumber',array(
		'label'	=> __('Phone Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image','policyguard-insurance-services'),
				'description'   		=> __('Image size 613*447','policyguard-insurance-services'),
	            'section' => 'policyguard_insurance_services_aboutussettings',
	            'settings' => 'aboutus_image',
	        )
	    )
	);

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box1_number',array(
		'default'	=> '200',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box1_number',array(
		'label'	=> __('Box 1 Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box1_text',array(
		'default'	=> 'COMPLETED PROJECTS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box1_text',array(
		'label'	=> __('Box 1 Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box2_number',array(
		'default'	=> '95',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box2_number',array(
		'label'	=> __('Box 2 Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box2_text',array(
		'default'	=> 'COMPLETED PROJECTS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box2_text',array(
		'label'	=> __('Box 2 Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box3_number',array(
		'default'	=> '28',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box3_number',array(
		'label'	=> __('Box 3 Number','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('policyguard_insurance_services_aboutus_box3_text',array(
		'default'	=> 'YEAR EXPERIENCE',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_aboutus_box3_text',array(
		'label'	=> __('Box 3 Text','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_heading_color', array(
		'label' => __('Heading Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_heading_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_description_color', array(
		'label' => __('Description Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_description_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_btntext_color', array(
		'label' => __('Button Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_btntext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_btnbg_color', array(
		'label' => __('Button BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_btnbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_btnbghrv_color', array(
		'label' => __('Button BG Hover Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_btnbghrv_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_contactagenttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_contactagenttext_color', array(
		'label' => __('Contact Agent Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_contactagenttext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_phonenumber_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_phonenumber_color', array(
		'label' => __('Phone Number Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_phonenumber_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_boxbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_boxbg_color', array(
		'label' => __('Box BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_boxbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_boxtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_boxtext_color', array(
		'label' => __('Box Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_boxtext_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_boxicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_boxicon_color', array(
		'label' => __('Box Icon Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_boxicon_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_boxiconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_boxiconbg_color', array(
		'label' => __('Box Icon BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_boxiconbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_aboutus_imgboxtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_aboutus_imgboxtext_color', array(
		'label' => __('Image Box Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_aboutussettings',
		'settings' => 'policyguard_insurance_services_aboutus_imgboxtext_color',
	)));


	//home page feature
	$wp_customize->add_section( 'policyguard_insurance_services_featuresettings' , array(
    	'title'      => esc_html__( 'Feature Settings', 'policyguard-insurance-services' ),
		'priority'   => null,
		'panel' => 'policyguard_insurance_services_panel_id'
	) );

	$wp_customize->add_setting( 'policyguard_insurance_services_featuresec_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_featuresec_color', array(
		'label' => __('Section BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_featuresec_color',
	)));

	$wp_customize->add_setting('policyguard_insurance_services_btn_featureheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btn_featureheading',array(
		'label'	=> __('Heading','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('policyguard_insurance_services_btn_featuresubheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_btn_featuresubheading',array(
		'label'	=> __('Sub Heading','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));
	

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_page1', array(
		'default'           => '',
		'sanitize_callback' => 'policyguard_insurance_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'policyguard_insurance_services_feature_page1', array(
		'label'    => esc_html__( 'Select Feature Page', 'policyguard-insurance-services' ),
		'section'  => 'policyguard_insurance_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_feature_icon1',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_feature_icon1',array(
		'label'	=> __('Icon 1','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_page2', array(
		'default'           => '',
		'sanitize_callback' => 'policyguard_insurance_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'policyguard_insurance_services_feature_page2', array(
		'label'    => esc_html__( 'Select Feature Page', 'policyguard-insurance-services' ),
		'section'  => 'policyguard_insurance_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_feature_icon2',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_feature_icon2',array(
		'label'	=> __('Icon 2','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_page3', array(
		'default'           => '',
		'sanitize_callback' => 'policyguard_insurance_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'policyguard_insurance_services_feature_page3', array(
		'label'    => esc_html__( 'Select Feature Page', 'policyguard-insurance-services' ),
		'section'  => 'policyguard_insurance_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_feature_icon3',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_feature_icon3',array(
		'label'	=> __('Icon 3','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_page4', array(
		'default'           => '',
		'sanitize_callback' => 'policyguard_insurance_services_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'policyguard_insurance_services_feature_page4', array(
		'label'    => esc_html__( 'Select Feature Page', 'policyguard-insurance-services' ),
		'section'  => 'policyguard_insurance_services_featuresettings',
		'type'     => 'dropdown-pages'
	) );

	$wp_customize->add_setting('policyguard_insurance_services_feature_icon4',array(
		'default'	=> 'fa fa-home',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('policyguard_insurance_services_feature_icon4',array(
		'label'	=> __('Icon 4','policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_heading_color', array(
		'label' => __('Heading Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_heading_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_subheading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_subheading_color', array(
		'label' => __('Sub Heading Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_subheading_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_boxbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_boxbg_color', array(
		'label' => __('Box BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_boxbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_icon_color', array(
		'label' => __('Icon Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_icon_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_iconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_iconbg_color', array(
		'label' => __('Icon BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_iconbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_title_color', array(
		'label' => __('Title Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_title_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_description_color', array(
		'label' => __('Description Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_description_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_feature_readmoretext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_feature_readmoretext_color', array(
		'label' => __('Read More Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_featuresettings',
		'settings' => 'policyguard_insurance_services_feature_readmoretext_color',
	)));


	//footer
	$wp_customize->add_section('policyguard_insurance_services_footer_section',array(
		'title'	=> esc_html__('Footer Settings','policyguard-insurance-services'),
		'panel' => 'policyguard_insurance_services_panel_id'
	));
		
	$wp_customize->add_setting('policyguard_insurance_services_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('policyguard_insurance_services_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_copyright_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_copyright_color', array(
		'label' => __('Copyright Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_copyright_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_title_color', array(
		'label' => __('Widgets Title Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_title_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_text_color', array(
		'label' => __('Widgets Text Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_text_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_icon_color', array(
		'label' => __('Icon Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_icon_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footer_activemenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footer_activemenu_color', array(
		'label' => __('Active Menu Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footer_activemenu_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_footerbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_footerbg_color', array(
		'label' => __('Footer BG Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_footer_section',
		'settings' => 'policyguard_insurance_services_footerbg_color',
	)));


	//Wocommerce Shop Page
	$wp_customize->add_section('policyguard_insurance_services_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','policyguard-insurance-services'),
		'panel' => 'policyguard_insurance_services_panel_id'
	));

	$wp_customize->add_setting( 'policyguard_insurance_services_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'policyguard_insurance_services_sanitize_choices',
	) );
	$wp_customize->add_control( 'policyguard_insurance_services_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'policyguard-insurance-services' ),
		'description'	=> __('How many products should be shown per Column?','policyguard-insurance-services'),
		'section'  => 'policyguard_insurance_services_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('policyguard_insurance_services_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'policyguard_insurance_services_sanitize_float',
	));	
	$wp_customize->add_control('policyguard_insurance_services_products_per_page',array(
		'label'	=> __('Product Per Page','policyguard-insurance-services'),
		'description'	=> __('How many products should be shown per page?','policyguard-insurance-services'),
		'section'	=> 'policyguard_insurance_services_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'policyguard_insurance_services_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_woocommerce_shop_page',
		'settings' => 'policyguard_insurance_services_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'policyguard_insurance_services_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_woocommerce_shop_page',
		'settings' => 'policyguard_insurance_services_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'policyguard_insurance_services_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_product_sale_color', array(
		'label' => __('Sale Badge Color', 'policyguard-insurance-services'),
		'section' => 'policyguard_insurance_services_woocommerce_shop_page',
		'settings' => 'policyguard_insurance_services_product_sale_color',
	)));


	// logo site title
	$wp_customize->add_setting('policyguard_insurance_services_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'policyguard_insurance_services_sanitize_checkbox'
    ));
    $wp_customize->add_control('policyguard_insurance_services_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','policyguard-insurance-services'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'policyguard_insurance_services_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_site_title_color', array(
		'label' => __('Site Title Color', 'policyguard-insurance-services'),
		'section' => 'title_tagline',
		'settings' => 'policyguard_insurance_services_site_title_color',
	)));

    $wp_customize->add_setting( 'policyguard_insurance_services_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'policyguard_insurance_services_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'policyguard-insurance-services'),
		'section' => 'title_tagline',
		'settings' => 'policyguard_insurance_services_site_tagline_color',
	)));
}
add_action( 'customize_register', 'policyguard_insurance_services_customize_register' );