<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'multipurpose_corporate_before_slider' ); ?>
  <?php if( get_theme_mod('multipurpose_corporate_slider_hide', false) != ''){ ?>
    <section id="slider" class="mw-100 m-auto p-0">
      <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
        <?php $multipurpose_corporate_content_pages = array();
          for ( $count = 1; $count <= 4; $count++ ) {
            $mod = intval( get_theme_mod( 'multipurpose_corporate_slider_page' . $count ));
            if ( 'page-none-selected' != $mod ) {
              $multipurpose_corporate_content_pages[] = $mod;
            }
          }
          if( !empty($multipurpose_corporate_content_pages) ) :
            $args = array(
              'post_type' => 'page',
              'post__in' => $multipurpose_corporate_content_pages,
              'orderby' => 'post__in'
            );
            $query = new WP_Query( $args );
          if ( $query->have_posts() ) :
            $i = 1;
        ?>     
        <div class="carousel-inner" role="listbox">
          <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
            <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
              <?php the_post_thumbnail(); ?>
              <?php
                $multipurpose_corporate_slider_animation = get_theme_mod('multipurpose_corporate_slider_animation', '')
                ?>
              <div class="carousel-caption <?php echo($multipurpose_corporate_slider_animation)?>">
                <div class="inner_carousel">
                  <h1 class="p-0"><?php the_title(); ?></h1>
                  <p class="mb-3"><?php $excerpt = get_the_excerpt(); echo esc_html( multipurpose_corporate_string_limit_words( $excerpt,20 ) ); ?></p>
                  <div class="slide-btn">
                    <a href="<?php the_permalink(); ?>" class="py-2 px-3"><?php esc_html_e('READ MORE','multipurpose-corporate'); ?><span class="screen-reader-text"><?php esc_html_e( 'READ MORE','multipurpose-corporate' );?></span></a>
                  </div>
                </div>
              </div>
            </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>
        </div>
        <?php else : ?>
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon p-3 w-auto h-auto" aria-hidden="true"><?php esc_html_e('Previous','multipurpose-corporate'); ?></span><span class="screen-reader-text"><?php esc_html_e( 'Previous','multipurpose-corporate' );?></span></a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button"><span class="carousel-control-next-icon p-3 w-auto h-auto" aria-hidden="true"><?php esc_html_e('Next','multipurpose-corporate'); ?></span><span class="screen-reader-text"><?php esc_html_e( 'Next','multipurpose-corporate' );?></span>
        </a>
      </div>      
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'multipurpose_corporate_after_slider' ); ?>

  <section id="services">
    <div class="container">
      <div class="row">
        <div class="col-lg-10 col-md-10 offset-lg-1 offset-md-1 row">
          <?php $service_pages = array();
            for ( $count = 0; $count <= 3; $count++ ) {
              $mod = intval( get_theme_mod( 'multipurpose_corporate_services_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $service_pages[] = $mod;
              }
            }
            if( !empty($service_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $service_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
              if ( $query->have_posts() ) :
                $count = 0;
                while ( $query->have_posts() ) : $query->the_post(); ?>
                  <div class="col-lg-4 col-md-4 top-service mb-4 text-center">
                    <?php the_post_thumbnail(); ?>
                    <h2 class="p-0 my-3"><?php the_title(); ?></h2>
                    <hr class="services my-3 mx-auto">
                   <p class="mb-2"><?php $excerpt = get_the_excerpt(); echo esc_html( multipurpose_corporate_string_limit_words( $excerpt,30 ) ); ?></p>
                    <a href="<?php the_permalink(); ?>"><?php esc_html_e('READ MORE','multipurpose-corporate'); ?><span class="screen-reader-text"><?php esc_html_e( 'READ MORE','multipurpose-corporate' );?></span></a>
                  </div>
                <?php $count++; endwhile; 
                wp_reset_postdata();?>
              <?php else : ?>
                <div class="no-postfound"></div>
            <?php endif;
          endif;?>
          <div class="clearfix"></div>
        </div>
      </div>
    </div> 
  </section>

  <?php do_action( 'multipurpose_corporate_after_courses' ); ?>

  <?php if( get_theme_mod('multipurpose_corporate_about_page') != ''){ ?>
    <section id="about" class="my-2">
      <div class="container">
        <div class="row">
          <?php $multipurpose_corporate_about_pages = array();
              $mod = intval( get_theme_mod( 'multipurpose_corporate_about_page' ));
              if ( 'page-none-selected' != $mod ) {
                $multipurpose_corporate_about_pages[] = $mod;
            }
            if( !empty($multipurpose_corporate_about_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $multipurpose_corporate_about_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
              if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post(); ?>
                  <div class="col-lg-8 col-md-8">
                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3>
                    <p><?php the_excerpt() ?></p>
                  </div>
                  <div class="col-lg-4 col-md-4">
                   <?php the_post_thumbnail(); ?>               
                  </div>
                <?php  endwhile; 
                wp_reset_postdata();?>
              <?php else : ?>
                <div class="no-postfound"></div>
            <?php endif;
          endif;?>
          <div class="clearfix"></div>
        </div>
      </div> 
    </section>
  <?php }?>

  <?php do_action( 'multipurpose_corporate_after_about' ); ?>

  <div class="container entry-content">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>

<?php get_footer(); ?>