<?php
//about theme info
add_action( 'admin_menu', 'multipurpose_corporate_gettingstarted' );
function multipurpose_corporate_gettingstarted() {    	
	add_theme_page( esc_html__('Get Started: Multipurpose Corporate Theme', 'multipurpose-corporate'), esc_html__('Get Started', 'multipurpose-corporate'), 'edit_theme_options', 'multipurpose_corporate_guide', 'multipurpose_corporate_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function multipurpose_corporate_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getting-started/getting-started.css');
}
add_action('admin_enqueue_scripts', 'multipurpose_corporate_admin_theme_style');

//guidline for about theme
function multipurpose_corporate_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'multipurpose-corporate' );
?>

<div class="wrapper-info">
	<div class="top-section">
	    <div class="col-left">
	    	<h2><?php esc_html_e( 'Welcome to Multipurpose Corporate Theme', 'multipurpose-corporate' ); ?></h2>
	    	<span class="version">Version: <?php echo esc_html($theme['Version']);?></span>
	    	<p><?php esc_html_e('The multipurpose corporate theme has the professional approach to it as required for any corporate site. This theme effectively serves any type of business whether you are a small firm or a corporate biggie, shop owners, business owners, bloggers, travelers, etc.. As it is a multipurpose theme, it can be used for personal websites, blogging and by agencies dealing in different areas such as product showcase, startups, medium sized companies, marketing, promoting your business online, corporate business, business websites, business agencies, organizations, e-commerce. If you are new to business world it will help you establish in the market or if you are already established then it will showcase your services and work in the most professional way. The theme comes with top-class features and functionalities to serve various purposes. It has a user-friendly and interactive interface for smooth usage of the site. It can be customized to change its colour, background, images etc. to fit your perspective. It is fully responsive to seamlessly adjust across any device; translation ready to serve different demographics and cross-browser compatible to load on any browser. It has multiple page templates to design each page differently. The social media icons present will make your site content shareable on all networking sites. This multipurpose corporate theme is written in clean and secure codes. It has a testimonial section where your customers can give review about your services and site. It is SEO-friendly and loads pages faster. Use this theme to exhibit your sincerity and professionalism in business world.','multipurpose-corporate'); ?></p>
	    </div>
	    <div class="col-right">
	    	<div class="logo">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/free-theme-image.png" alt="" />
			</div>
	    </div>
	    <div class="info-link">
			<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'multipurpose-corporate'); ?></a>
			<a class="get-pro" href="<?php echo esc_url( MULTIPURPOSE_CORPORATE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'multipurpose-corporate'); ?></a>
		</div>
	</div>

	<div class="accordain-sec">
		<div class="block">
		  	<input type="radio" name="city" id="cityA" checked />   
		  	<label for="cityA"><span><?php esc_html_e( 'Visit to our amazing Premium Theme', 'multipurpose-corporate' ); ?></span><span class="dashicons dashicons-arrow-down"></span></label>
		  	<div class="info1">
			  	<h3><?php esc_html_e( 'Premium Theme Information', 'multipurpose-corporate' ); ?></h3>
			  	<hr class="hr-accr">
			  	<div class="sec-left-inner">
			  		<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/free-theme-image.png" alt="" />
			  		<p class="lite-para"><?php esc_html_e('The corporate WordPress theme is a versatile, polished and modern theme for small as well as big corporate businesses. It has that perfect professional look necessary for a business site. As it is the improvised version of the free corporate theme, it has top-notch features and functionality. The secure and clean coding will protect your site from any security threat. The responsiveness and cross-browser compatibility of the theme will serve wider range of audience. The serene design and perfect combination of colours thoughtfully used by our expert developers will show your sincerity in doing business.The premium version of premium corporate WP theme comes with exclusive features and functionality. Being translation ready, the content of your site can be written in various languages. Customization can be done to change colour, background, fonts, header, footer, logo etc. with utmost ease in just few clicks through theme option panel. Spice up sidebars, header and footer using widgets to make the site neater. The facility to enable/disable section will be one more step towards letting you decide the look of the site. Shortcodes are implemented to add video, audio, other file formats, columns etc. without increasing the length of the code. Use this premium top corporate WordPress theme to see your business achieve success in no time.','multipurpose-corporate'); ?></p>

					<div class="info-link-top">
						<a href="<?php echo esc_url( MULTIPURPOSE_CORPORATE_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Buy Now', 'multipurpose-corporate' ); ?></a>
					</div>
					
			  	</div>
		  	</div>
		</div>
		<div class="block">
		  	<input type="radio" name="city" id="cityB"/>
		  	<label for="cityB"><span><?php esc_html_e( 'Theme Features', 'multipurpose-corporate' ); ?></span><span class="dashicons dashicons-arrow-down"></span></label>
		  	<div class="info2">
			    <h3><?php esc_html_e( 'Lite Theme v/s Premium Theme', 'multipurpose-corporate' ); ?></h3>
			  	<hr class="hr-accr">
			  	<div class="table-image">
					<table class="tablebox">
						<thead>
							<tr>
								<th></th>
								<th><?php esc_html_e('Free Themes', 'multipurpose-corporate'); ?></th>
								<th><?php esc_html_e('Premium Themes', 'multipurpose-corporate'); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e('Theme Customization', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Responsive Design', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Logo Upload', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Social Media Links', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Slider Settings', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Number of Slides', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('4', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('Unlimited', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Template Pages', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('3', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('6', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Home Page Template', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Contact us Page Template', 'multipurpose-corporate'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('1', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Blog Templates & Layout', 'multipurpose-corporate'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Page Templates & Layout', 'multipurpose-corporate'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('2(Left/Right Sidebar)', 'multipurpose-corporate'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Full Documentation', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Latest WordPress Compatibility', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Woo-Commerce Compatibility', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support 3rd Party Plugins', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Secure and Optimized Code', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Exclusive Functionalities', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Enable / Disable', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Google Font Choices', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Gallery', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Simple & Mega Menu Option', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Support to add custom CSS / JS ', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Shortcodes', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Premium Membership', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Budget Friendly Value', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Priority Error Fixing', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Custom Feature Addition', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('All Access Theme Pass', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Seamless Customer Support', 'multipurpose-corporate'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no-alt"></span></td>
								<td class="table-img"><span class="dashicons dashicons-yes"></span></td>
							</tr>
							<tr>
								<td></td>
								<td class="table-img"></td>
								<td class="update-link"><a href="<?php echo esc_url( MULTIPURPOSE_CORPORATE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'multipurpose-corporate'); ?></a></td>
							</tr>
						</tbody>
					</table>
				</div>
		 	</div>
		</div>
	</div>
</div>
<?php } ?>