<?php
/**
 * Multipurpose Corporate Theme Customizer
 *
 * @package Multipurpose Corporate
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function multipurpose_corporate_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'multipurpose_corporate_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'LT Settings', 'multipurpose-corporate' ),
	    'description' => __( 'Description of what this panel does.', 'multipurpose-corporate' ),
	) );

	$wp_customize->add_section( 'multipurpose_corporate_left_right' , array(
    	'title'      => __( 'General Settings', 'multipurpose-corporate' ),
		'priority'   => null,
		'panel' => 'multipurpose_corporate_panel_id'
	) );
 
    //Select width layout
    $wp_customize->add_setting('multipurpose_corporate_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'multipurpose_corporate_sanitize_choices'
	));
	$wp_customize->add_control('multipurpose_corporate_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','multipurpose-corporate'),
        'section' => 'multipurpose_corporate_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','multipurpose-corporate'),
            'Contained Width' => esc_html__('Contained Width','multipurpose-corporate'),
            'Boxed Width' => esc_html__('Boxed Width','multipurpose-corporate'),
        ),
	) );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('multipurpose_corporate_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'multipurpose_corporate_sanitize_choices'	        
	));
	$wp_customize->add_control('multipurpose_corporate_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'multipurpose-corporate' ),
        'label' => __( 'Post Sidebar Layout', 'multipurpose-corporate' ),
        'section' => 'multipurpose_corporate_left_right',
        'choices' => array(
            'One Column' => __('One Column ','multipurpose-corporate'),
            'Three Columns' => __('Three Columns','multipurpose-corporate'),
            'Four Columns' => __('Four Columns','multipurpose-corporate'),
            'Right Sidebar' => __('Right Sidebar','multipurpose-corporate'),
            'Left Sidebar' => __('Left Sidebar','multipurpose-corporate'),
            'Grid Layout' => __('Grid Layout','multipurpose-corporate')
        ),
	));

	$wp_customize->add_setting('multipurpose_corporate_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'multipurpose_corporate_sanitize_choices'
	));
	$wp_customize->add_control('multipurpose_corporate_dropdown_anim', array(
		'section'  => 'multipurpose_corporate_left_right',
		'label'    => __( 'Submenu Dropdown Effect','multipurpose-corporate'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'multipurpose-corporate'),
			'zoomIn' => __('zoomIn', 'multipurpose-corporate'),
			'flip-up' => __('flip-up', 'multipurpose-corporate'),
			'none' => __('none', 'multipurpose-corporate')
		)
	));

	//Topbar section
	$wp_customize->add_section('multipurpose_corporate_topbar',array(
		'title'	=> __('Topbar','multipurpose-corporate'),
		'description'	=> __('Add Topbar Content here','multipurpose-corporate'),
		'priority'	=> null,
		'panel' => 'multipurpose_corporate_panel_id',
	));

	$wp_customize->add_setting( 'multipurpose_corporate_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'multipurpose_corporate_sanitize_checkbox'
    ) );
    $wp_customize->add_control('multipurpose_corporate_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'multipurpose-corporate' ),
        'label' => __( 'Sticky Header','multipurpose-corporate' ),
        'section' => 'multipurpose_corporate_topbar'
    ));

    //Show /Hide Topbar
	$wp_customize->add_setting( 'multipurpose_corporate_show_topbar',array(
		'default' => false,
      	'sanitize_callback'	=> 'multipurpose_corporate_sanitize_checkbox'
    ) );
    $wp_customize->add_control('multipurpose_corporate_show_topbar',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable Topbar.', 'multipurpose-corporate' ),
        'label' => __( 'Topbar','multipurpose-corporate' ),
        'section' => 'multipurpose_corporate_topbar'
    ));

	$wp_customize->add_setting('multipurpose_corporate_timming',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('multipurpose_corporate_timming',array(
		'label'	=> __('Add Timmings','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_topbar',
		'setting'	=> 'multipurpose_corporate_timming',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multipurpose_corporate_call',array(
		'default'	=> '',
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_phone_number'
	));
	$wp_customize->add_control('multipurpose_corporate_call',array(
		'label'	=> __('Add Phone Number','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_topbar',
		'setting'	=> 'multipurpose_corporate_call',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multipurpose_corporate_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('multipurpose_corporate_mail',array(
		'label'	=> __('Add Email','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_topbar',
		'setting'	=> 'multipurpose_corporate_mail',
		'type'		=> 'text'
	));	

	$wp_customize->add_setting('multipurpose_corporate_button_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_button_text',array(
		'label'	=> __('Button text','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_topbar',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multipurpose_corporate_button_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('multipurpose_corporate_button_link',array(
		'label'	=> __('Add Button Link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_topbar',
		'setting'	=> 'multipurpose_corporate_button_link',
		'type'		=> 'url'
	));

	$wp_customize->add_setting( 'multipurpose_corporate_topicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_topicon_color', array(
		'label' => __('Topbar Icons Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_topbar',
		'settings' => 'multipurpose_corporate_topicon_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_toptext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_toptext_color', array(
		'label' => __('Topbar Text Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_topbar',
		'settings' => 'multipurpose_corporate_toptext_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_topbar_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_topbar_color', array(
		'label' => __('Topbar Background Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_topbar',
		'settings' => 'multipurpose_corporate_topbar_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_menu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_menu_color', array(
		'label' => __('Menu Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_topbar',
		'settings' => 'multipurpose_corporate_menu_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_submenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_submenu_color', array(
		'label' => __('Submenu Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_topbar',
		'settings' => 'multipurpose_corporate_submenu_color',
	)));

	//Social Icons(topbar)
	$wp_customize->add_section('multipurpose_corporate_social_media',array(
		'title'	=> __('Social Media','multipurpose-corporate'),
		'description'	=> __('Add Social Media Url here','multipurpose-corporate'),
		'priority'	=> null,
		'panel' => 'multipurpose_corporate_panel_id',
	));

	$wp_customize->add_setting('multipurpose_corporate_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_facebook_url',array(
		'label'	=> __('Add Facebook link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_facebook_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('multipurpose_corporate_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_twitter_url',array(
		'label'	=> __('Add Twitter link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_twitter_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('multipurpose_corporate_instagram_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_instagram_url',array(
		'label'	=> __('Add Instagram link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_instagram_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('multipurpose_corporate_youtube_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_youtube_url',array(
		'label'	=> __('Add Youtube link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_youtube_url',
		'type'		=> 'url'
	));

	$wp_customize->add_setting('multipurpose_corporate_pint_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_pint_url',array(
		'label'	=> __('Add Pinterest link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_pint_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('multipurpose_corporate_linkedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('multipurpose_corporate_linkedin_url',array(
		'label'	=> __('Add LinkedIn link','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_social_media',
		'setting'	=> 'multipurpose_corporate_linkedin_url',
		'type'	=> 'url'
	));
    
    //Social Icons Font Size
	$wp_customize->add_setting('multipurpose_corporate_social_icon_fontsize',array(
		'default'=> '',
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_float'
	));
	$wp_customize->add_control('multipurpose_corporate_social_icon_fontsize',array(
		'label'	=> __('Social Icons Font Size','multipurpose-corporate'),
		'input_attrs' => array(
            'step' => 1,
			'min'  => 0,
			'max'  => 100,
        ),
		'section'=> 'multipurpose_corporate_social_media',
		'type'=> 'number',
	));

	$wp_customize->add_setting( 'multipurpose_corporate_social_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_social_color', array(
		'label' => __('Icon Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_social_media',
		'settings' => 'multipurpose_corporate_social_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_socialbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_socialbg_color', array(
		'label' => __('Icon Background Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_social_media',
		'settings' => 'multipurpose_corporate_socialbg_color',
	)));
	
	//home page slider
	$wp_customize->add_section( 'multipurpose_corporate_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'multipurpose-corporate' ),
		'priority'   => null,
		'panel' => 'multipurpose_corporate_panel_id'
	) );

	$wp_customize->add_setting('multipurpose_corporate_slider_hide',array(
       'default' => false,
       'sanitize_callback'  => 'multipurpose_corporate_sanitize_checkbox'
    ));
    $wp_customize->add_control('multipurpose_corporate_slider_hide',array(
       'type' => 'checkbox',
       'description' => __( 'Click on the checkbox to enable slider.', 'multipurpose-corporate' ),
       'label' => __('Show / Hide slider','multipurpose-corporate'),
       'section' => 'multipurpose_corporate_slidersettings',
    ));

	//This is onload transaction effect
	$wp_customize->add_setting('multipurpose_corporate_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'multipurpose_corporate_sanitize_choices'
	));
	$wp_customize->add_control('multipurpose_corporate_slider_animation', array(
		'section'  => 'multipurpose_corporate_slidersettings',
		'label'    => __( 'Onload Transaction Effect','multipurpose-corporate'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'multipurpose-corporate'),
			'bounceInRight' => __('bounceInRight', 'multipurpose-corporate'),
			'bounceInUp' => __('bounceInUp', 'multipurpose-corporate'),
			'bounceInDown' => __('bounceInDown', 'multipurpose-corporate'),
			'zoomIn' => __('zoomIn', 'multipurpose-corporate'),
			'zoomOut' => __('zoomOut', 'multipurpose-corporate'),
			'fadeInLeft' => __('fadeInLeft', 'multipurpose-corporate'),
			'fadeInRight' => __('fadeInRight', 'multipurpose-corporate'),
			'fadeInUp' => __('fadeInUp', 'multipurpose-corporate'),
			'fadeInDown' => __('fadeInDown', 'multipurpose-corporate'),
			'flip-up' => __('flip-up', 'multipurpose-corporate'),
			'none' => __('none', 'multipurpose-corporate')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		// Add color scheme setting and control.
		$wp_customize->add_setting( 'multipurpose_corporate_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'multipurpose_corporate_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'multipurpose_corporate_slider_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'multipurpose-corporate' ),
			'section'  => 'multipurpose_corporate_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('multipurpose_corporate_slider_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_slider_title_font_size',array(
		'label'	=> __('Title Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_slidersettings',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('multipurpose_corporate_slider_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_slider_text_font_size',array(
		'label'	=> __('Text Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_slidersettings',
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'multipurpose_corporate_slider', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider', array(
		'label' => __('Title Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_text', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_text', array(
		'label' => __('Text Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_text',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_btn', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_btn', array(
		'label' => __('Button Text Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_btn',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_btnbg', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_btnbg', array(
		'label' => __('Button BG Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_btnbg',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_btnhvr', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_btnhvr', array(
		'label' => __('Button Hover Text Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_btnhvr',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_btnbghvr', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_btnbghvr', array(
		'label' => __('Button Hover BG Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_btnbghvr',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_np', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_np', array(
		'label' => __('Next Pre Button Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_np',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_slider_npbg', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_slider_npbg', array(
		'label' => __('Next Pre Button BG Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_slidersettings',
		'settings' => 'multipurpose_corporate_slider_npbg',
	)));

	//OUR services
	$wp_customize->add_section('multipurpose_corporate_services_section',array(
		'title'	=> __('Our Services','multipurpose-corporate'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','multipurpose-corporate'),
		'panel' => 'multipurpose_corporate_panel_id',
	));	

	for ( $count = 0; $count <= 2; $count++ ) {
		$wp_customize->add_setting( 'multipurpose_corporate_services_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'multipurpose_corporate_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'multipurpose_corporate_services_page' . $count, array(
			'label'    => __( 'Select Service Page', 'multipurpose-corporate' ),
			'section'  => 'multipurpose_corporate_services_section',
			'type'     => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting('multipurpose_corporate_service_img_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_service_img_size',array(
		'label'	=> __('Image Height','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_services_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('multipurpose_corporate_service_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_service_title_font_size',array(
		'label'	=> __('Title Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_services_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('multipurpose_corporate_service_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_service_text_font_size',array(
		'label'	=> __('Text Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_services_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'multipurpose_corporate_service_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_service_color', array(
		'label' => __('Box Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_services_section',
		'settings' => 'multipurpose_corporate_service_color',
	)));

	//About
	$wp_customize->add_section('multipurpose_corporate_about_section',array(
		'title'	=> __('About us','multipurpose-corporate'),
		'description'=> __('Select the about us page.','multipurpose-corporate'),
		'panel' => 'multipurpose_corporate_panel_id',
	));	

	$wp_customize->add_setting( 'multipurpose_corporate_about_page' , array(
		'default'           => '',
		'sanitize_callback' => 'multipurpose_corporate_sanitize_dropdown_pages'
	));
	$wp_customize->add_control( 'multipurpose_corporate_about_page' , array(
		'label'    => __( 'Select About Page', 'multipurpose-corporate' ),
		'section'  => 'multipurpose_corporate_about_section',
		'type'     => 'dropdown-pages'
	));

	$wp_customize->add_setting('multipurpose_corporate_about_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_about_title_font_size',array(
		'label'	=> __('Title Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_about_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('multipurpose_corporate_about_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_about_text_font_size',array(
		'label'	=> __('Text Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_about_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'multipurpose_corporate_about_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_about_title_color', array(
		'label' => __('Title Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_about_section',
		'settings' => 'multipurpose_corporate_about_title_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_about_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_about_text_color', array(
		'label' => __('Text Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_about_section',
		'settings' => 'multipurpose_corporate_about_text_color',
	)));

	$wp_customize->add_setting( 'multipurpose_corporate_about_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_about_color', array(
		'label' => __('Image Border Color', 'multipurpose-corporate'),
		'section' => 'multipurpose_corporate_about_section',
		'settings' => 'multipurpose_corporate_about_color',
	)));

	//footer
	$wp_customize->add_section('multipurpose_corporate_footer_section',array(
		'title'	=> __('Footer Setting','multipurpose-corporate'),
		'description'	=> __('Add some text for footer like copyright etc.','multipurpose-corporate'),
		'panel' => 'multipurpose_corporate_panel_id'
	));

	/*Footer Background Color */
	$wp_customize->add_setting('multipurpose_corporate_footer_background_color', array(
		'default'           => '#1e1d1c',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'multipurpose_corporate_footer_background_color', array(
		'label'    => __('Footer Background Color', 'multipurpose-corporate'),
		'section'  => 'multipurpose_corporate_footer_section',
	)));
	
	$wp_customize->add_setting('multipurpose_corporate_footer_copy',array(
		'default'	=> 'Corporate WordPress Theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('multipurpose_corporate_footer_copy',array(
		'label'	=> __('Copyright Text','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('multipurpose_corporate_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('multipurpose_corporate_footer_copy_font_size',array(
		'label'	=> __('Text Font Size','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_footer_section',
		'type'		=> 'number'
	));

    /*copyright text position*/
	$wp_customize->add_setting('multipurpose_corporate_copyright_text_position',array(
        'default' => 'center',
        'sanitize_callback' => 'multipurpose_corporate_sanitize_choices'
	));
	$wp_customize->add_control('multipurpose_corporate_copyright_text_position',array(
        'type' => 'select',
        'label' => __('Copyright Text Alignment','multipurpose-corporate'),
        'section' => 'multipurpose_corporate_footer_section',
        'choices' => array(
            'left' => __('Left','multipurpose-corporate'),
            'right' => __('Right','multipurpose-corporate'),
            'center' => __('Center','multipurpose-corporate'),
        ),
	) );

	$wp_customize->add_setting('multipurpose_corporate_footer_copy_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('multipurpose_corporate_footer_copy_padding',array(
		'label'	=> __('Top & Bottom Padding','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_footer_section',
		'type'		=> 'number'
	));

	//Copyright Background Color
    $wp_customize->add_setting('multipurpose_corporate_copyright_background_color', array(
		'default'           => '#007f98',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'multipurpose_corporate_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'multipurpose-corporate'),
		'section'  => 'multipurpose_corporate_footer_section',
	)));

	//Wocommerce Shop Page
	$wp_customize->add_section('multipurpose_corporate_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','multipurpose-corporate'),
		'panel' => 'multipurpose_corporate_panel_id'
	));

	$wp_customize->add_setting( 'multipurpose_corporate_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'multipurpose_corporate_sanitize_choices',
	) );
	$wp_customize->add_control( 'multipurpose_corporate_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'multipurpose-corporate' ),
		'description'	=> __('How many products should be shown per Column?','multipurpose-corporate'),
		'section'  => 'multipurpose_corporate_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('multipurpose_corporate_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_float',
	));	
	$wp_customize->add_control('multipurpose_corporate_products_per_page',array(
		'label'	=> __('Product Per Page','multipurpose-corporate'),
		'description'	=> __('How many products should be shown per page?','multipurpose-corporate'),
		'section'	=> 'multipurpose_corporate_woocommerce_shop_page',
		'type'		=> 'number'
	));

	// site logo size
	$wp_customize->add_setting('multipurpose_corporate_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_float'
	));
	$wp_customize->add_control('multipurpose_corporate_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','multipurpose-corporate'),
		'section' => 'title_tagline'
	));

	// logo site title size 
	$wp_customize->add_setting('multipurpose_corporate_site_title_font_size',array(
		'default'	=> 28,
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_float'
	));
	$wp_customize->add_control('multipurpose_corporate_site_title_font_size',array(
		'label'	=> __('Site Title Font Size','multipurpose-corporate'),
		'section'	=> 'title_tagline',
		'setting'	=> 'multipurpose_corporate_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'multipurpose_corporate_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_site_title_color', array(
		'label' => __('Title Color', 'multipurpose-corporate'),
		'section' => 'title_tagline',
		'settings' => 'multipurpose_corporate_site_title_color',
	)));

	// logo site tagline size 
	$wp_customize->add_setting('multipurpose_corporate_site_tagline_font_size',array(
		'default'	=> 12,
		'sanitize_callback'	=> 'multipurpose_corporate_sanitize_float'
	));
	$wp_customize->add_control('multipurpose_corporate_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size','multipurpose-corporate'),
		'section'	=> 'title_tagline',
		'setting'	=> 'multipurpose_corporate_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'multipurpose_corporate_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'multipurpose_corporate_site_tagline_color', array(
		'label' => __('Tagline Color', 'multipurpose-corporate'),
		'section' => 'title_tagline',
		'settings' => 'multipurpose_corporate_site_tagline_color',
	)));

	// logo site title
	$wp_customize->add_setting('multipurpose_corporate_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'multipurpose_corporate_sanitize_checkbox'
    ));
    $wp_customize->add_control('multipurpose_corporate_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','multipurpose-corporate'),
       'section' => 'title_tagline'
    ));
	
}
add_action( 'customize_register', 'multipurpose_corporate_customize_register' );	

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Multipurpose_Corporate_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Multipurpose_Corporate_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Multipurpose_Corporate_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Corporate Pro', 'multipurpose-corporate' ),
					'pro_text' => esc_html__( 'Go Pro', 'multipurpose-corporate' ),
					'pro_url'  => esc_url( 'https://www.radicalthemes.com/wordpress-theme/para-multipurpose-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'multipurpose-corporate-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'multipurpose-corporate-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Multipurpose_Corporate_Customize::get_instance();