<?php
/**
 * Display Header.
 * @package Multipurpose Corporate
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<header role="banner">	
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'multipurpose-corporate' ); ?></a>
		<div class="header-box">
			<?php  get_template_part( 'template-parts/header/top', 'bar' ); ?>
			<div class="<?php if( get_theme_mod( 'multipurpose_corporate_sticky_header', false) != '') { ?> sticky-menubox"<?php } else { ?>close-sticky <?php } ?>">
				<div class="container">
				  	<div class="row">
				  		<div class="col-lg-3 col-md-4">
				  			<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
				  		</div>
					  	<div class="<?php if(get_theme_mod('multipurpose_corporate_button_text')) { ?>col-lg-6 col-md-4 col-4 align-self-center"<?php } else { ?>col-lg-8 col-md-7 col-6 <?php } ?>">
					  		<?php get_template_part( 'template-parts/navigation/site', 'nav' ); ?>
					  	</div>
					  	<div class="<?php if(get_theme_mod('multipurpose_corporate_button_text')) { ?>col-lg-1 col-md-1 col-2 align-self-center"<?php } else { ?>col-lg-1 col-md-1 col-6 <?php } ?>">
				  			<div class="search-box text-center my-3">
					          <i class="fas fa-search"></i>
					        </div>
					  	</div>
					  	<div class="col-lg-2 col-md-3 col-6 align-self-center">
					  		<?php if ( get_theme_mod('multipurpose_corporate_button_text','') != "" ) {?>
					            <div class="get-quote-btn my-3 text-end">
				              		<span><a href="<?php echo esc_url(get_theme_mod('multipurpose_corporate_button_link','')); ?>"><?php echo esc_html(get_theme_mod('multipurpose_corporate_button_text','')); ?> </a></span>
					            </div>
					        <?php }?>
					  	</div>
			 	 	</div> 
			 		<div class="serach_outer">
				        <div class="closepop w-100 text-end me-3"><i class="far fa-window-close"></i></div>
				        <div class="serach_inner w-100">
				          <?php get_search_form(); ?>
				        </div>
				    </div>
				</div>
			</div>
		</div>
	</header>