<?php
/**
 * Multipurpose Corporate functions and definitions
 * @package Multipurpose Corporate
 */


/* Theme Setup */
if ( ! function_exists( 'multipurpose_corporate_setup' ) ) :

function multipurpose_corporate_setup() {

	$GLOBALS['content_width'] = apply_filters( 'multipurpose_corporate_content_width', 640 );

	load_theme_textdomain( 'multipurpose-corporate', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'custom-logo', array(
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
	) );
	add_image_size('multipurpose-corporate-homepage-thumb',240,145,true);
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'multipurpose-corporate' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'f1f1f1'
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support(
		'post-formats', array(
			'image',
			'video',
			'gallery',
			'audio',
		)	
	);

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support('responsive-embeds');

	add_editor_style( array( 'assets/css/editor-style.css', multipurpose_corporate_font_url() ) );

	// Theme Activation Notice
	global $pagenow;
	
	if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
		add_action( 'admin_notices', 'multipurpose_corporate_activation_notice' );
	}
}
endif; // multipurpose_corporate_setup
add_action( 'after_setup_theme', 'multipurpose_corporate_setup' );

// Notice after Theme Activation
function multipurpose_corporate_activation_notice() {
	echo '<div class="corporatewelcome notice notice-success is-dismissible">';
		echo '<h3>'. esc_html__( 'Warm Greetings to you!!', 'multipurpose-corporate' ) .'</h3>';
		echo '<p>'. esc_html__( ' Our sincere thanks for choosing our multipurpose corporate theme. We assure you a high performing theme for your corporate business. Please proceed towards welcome section to start an amazing journey with us..', 'multipurpose-corporate' ) .'</p>';
		echo '<p><a href="'. esc_url( admin_url( 'themes.php?page=multipurpose_corporate_guide' ) ) .'" class="button button-primary">'. esc_html__( 'Welcome...', 'multipurpose-corporate' ) .'</a></p>';
	echo '</div>';
}

/*Site URL*/
define('MULTIPURPOSE_CORPORATE_BUY_NOW',__('https://www.radicalthemes.com/wordpress-theme/para-multipurpose-wordpress-theme/','multipurpose-corporate'));
define('MULTIPURPOSE_CORPORATE_CREDIT',__('https://www.radicalthemes.com/free-wordpress-themes/free-multipurpose-corporate-wordpress-theme/','multipurpose-corporate'));
if ( ! function_exists( 'multipurpose_corporate_credit' ) ) {
	function multipurpose_corporate_credit(){
		echo "<a href=".esc_url(MULTIPURPOSE_CORPORATE_CREDIT)." target='_blank'>".esc_html__(get_theme_mod('multipurpose_corporate_footer_copy',__('By LogicalThemes','multipurpose-corporate')))."</a>";
	}
}

/*radio button sanitization*/
function multipurpose_corporate_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function multipurpose_corporate_sanitize_phone_number( $phone ) {
	return preg_replace( '/[^\d+]/', '', $phone );
}

function multipurpose_corporate_sanitize_checkbox( $input ) {
	return ( ( isset( $input ) && true == $input ) ? true : false );
}

function multipurpose_corporate_sanitize_float( $input ) {
	return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

function multipurpose_corporate_sanitize_dropdown_pages($page_id, $setting) {
	// Ensure $input is an absolute integer.
	$page_id = absint($page_id);
	// If $page_id is an ID of a published page, return it; otherwise, return the default.
	return ('publish' == get_post_status($page_id)?$page_id:$setting->default);
}

/* Excerpt Limit Begin */
function multipurpose_corporate_string_limit_words($string, $word_limit) {
	$words = explode(' ', $string, ($word_limit + 1));
	if(count($words) > $word_limit)
	array_pop($words);
	return implode(' ', $words);
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'multipurpose_corporate_loop_columns');
if (!function_exists('multipurpose_corporate_loop_columns')) {
	function multipurpose_corporate_loop_columns() {
		$columns = get_theme_mod( 'multipurpose_corporate_products_per_column', 3 );
		return $columns; // 3 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'multipurpose_corporate_shop_per_page', 20 );
function multipurpose_corporate_shop_per_page( $cols ) {
  	$cols = get_theme_mod( 'multipurpose_corporate_products_per_page', 9 );
	return $cols;
}

/* Theme Widgets Setup */
function multipurpose_corporate_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'multipurpose-corporate' ),
		'description'   => __( 'Appears on blog page sidebar', 'multipurpose-corporate' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Posts and Pages Sidebar', 'multipurpose-corporate' ),
		'description'   => __( 'Appears on posts and pages', 'multipurpose-corporate' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'multipurpose-corporate' ),
		'description'   => __( 'Appears on posts and pages', 'multipurpose-corporate' ),
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'multipurpose-corporate' ),
		'description'   => __( 'Appears in footer', 'multipurpose-corporate' ),
		'id'            => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 2', 'multipurpose-corporate' ),
		'description'   => __( 'Appears in footer', 'multipurpose-corporate' ),
		'id'            => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 3', 'multipurpose-corporate' ),
		'description'   => __( 'Appears in footer', 'multipurpose-corporate' ),
		'id'            => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 4', 'multipurpose-corporate' ),
		'description'   => __( 'Appears in footer', 'multipurpose-corporate' ),
		'id'            => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'multipurpose_corporate_widgets_init' );

function multipurpose_corporate_font_url(){
	$font_url = '';
	$font_family = array();
	$font_family[] = 'Montserrat:300,400,600,700,800,900';

	$query_args = array(
		'family'	=> rawurlencode(implode('|',$font_family)),
	);
	$font_url = add_query_arg($query_args,'//fonts.googleapis.com/css');
	return $font_url;
}	

/* Theme enqueue scripts */
function multipurpose_corporate_scripts() {
	wp_enqueue_style( 'multipurpose-corporate-font', multipurpose_corporate_font_url(), array() );
	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri()) . '/assets/css/bootstrap.css');
	wp_enqueue_style( 'multipurpose-corporate-basic-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/inc/inline-css.php' );
	wp_add_inline_style( 'multipurpose-corporate-basic-style',$multipurpose_corporate_custom_css ); 
	wp_style_add_data( 'multipurpose-corporate-style', 'rtl', 'replace' );
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css' );
	wp_enqueue_style( 'custom-aniumations', get_template_directory_uri().'/assets/css/animations.css' );
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()) . '/assets/js/bootstrap.js', array('jquery') ,'',true);
	wp_enqueue_script( 'multipurpose-corporate-custom-jquery', esc_url(get_template_directory_uri()) . '/assets/js/custom.js', array('jquery') );
	wp_enqueue_script( 'jquery-superfish', esc_url(get_template_directory_uri()) . '/assets/js/jquery.superfish.js', array('jquery') ,'',true);
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'multipurpose_corporate_scripts' );

require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/getting-started/getting-started.php';