<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'mega_manufacturing_industry_above_slider' ); ?>
  <?php if( get_theme_mod('mega_manufacturing_industry_slider_hide_show', false) != ''){ ?> 
    <section id="slider" class=" mw-100">
        
       <!-- <div class="container"> -->
        <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
          <?php $mega_manufacturing_industry_content_pages = array();
            for ( $count = 1; $count <= 4; $count++ ) {
              $mod = intval( get_theme_mod( 'mega_manufacturing_industry_slider_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $mega_manufacturing_industry_content_pages[] = $mod;
              }
            }
            if( !empty($mega_manufacturing_industry_content_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $mega_manufacturing_industry_content_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
              $i = 1;
          ?>     
          <div class="carousel-inner" role="listbox">
            <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>     
                  <div class="sliderbg-img">
                    <?php the_post_thumbnail(); ?>                            
                    <div class="s-oly"></div>
                    <div class="slider-content">
                          <p>
                            <?php $mega_manufacturing_industry_excerpt = get_the_excerpt(); echo esc_html( mega_manufacturing_industry_string_limit_words( $mega_manufacturing_industry_excerpt,20 ) ); ?>
                          </p>
                          <h2><?php the_title(); ?></h2>
                          <div class="clearfix"></div>
                          <!-- <div class="read-btn">
                            <a href="</?php echo esc_url(get_permalink()); ?>"></?php esc_html_e( 'Learn More', 'mega-manufacturing-industry' ); ?></a>
                          </div> -->
                        
                    </div>
                 </div>   
                
              </div>
            <?php $i++; endwhile; 
            wp_reset_postdata();?>
          </div>
        </div>
        <?php else : ?> 
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-caret-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous', 'mega-manufacturing-industry' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-caret-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next', 'mega-manufacturing-industry' );?></span>
        </a>
      <!-- </div> -->
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'mega_manufacturing_industry_below_slider' ); ?>

    <section id="aboutus-section">
      <div class="container">
        <div class="row m-0">
            <div class="service-head">
              <h4>
                <?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutustitle')); ?>
              </h4>
            </div>
            <p class="description"><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutusdescription')); ?></p>
        </div>
          <div class="row m-0">
          <div class="icntxtbx">
              <div class="box1 box">
                <div class="row">
                    <div class="icon">
                        <i class="<?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box1icon')); ?>"></i>
                    </div>
                    <div class="textbx">
                        <h4><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box1heading')); ?></h4>
                        <p><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box1description')); ?></p>
                    </div>
                </div>
              </div>
              <div class="box2 box">
                  <div class="row">
                      <div class="icon">
                          <i class="<?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box2icon')); ?>"></i>
                      </div>
                      <div class="textbx">
                          <h4><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box2heading')); ?></h4>
                          <p><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box2description')); ?></p>
                      </div>
                  </div>
              </div>
              <div class="box3 box">
                  <div class="row">
                      <div class="icon">
                          <i class="<?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box3icon')); ?>"></i>
                      </div>
                      <div class="textbx">
                          <h4><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box3heading')); ?></h4>
                          <p><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_box3description')); ?></p>
                      </div>
                  </div>
              </div>
          </div> 

          <div class="imgbx">
              <div class="numberbox ">
                  <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-6 yearofex">
                          <h3 class="yearofexno"><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutusyearofexno')); ?></h3>
                          <p class="yearofextext"><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutusyearofextext')); ?></p>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 yearofex latesttechnology">
                          <h3 class="yearofexno latesttechno"><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_latesttechnologyno')); ?></h3>
                          <p class="yearofextext latesttechtxt"><?php echo esc_html(get_theme_mod('mega_manufacturing_industry_aboutus_latesttechnologytext')); ?></p>
                      </div>
                  </div>
              </div>
            
            <div class="image">
              <?php 
                $mega_manufacturing_industry_aboutus_image1 = get_theme_mod('mega_manufacturing_industry_aboutus_image1');

                if(!empty($mega_manufacturing_industry_aboutus_image1)){
                  echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($mega_manufacturing_industry_aboutus_image1).'" class="img-responsive secondry-bg-img" />';
                }else{
                  echo '<img alt="mega_manufacturing_industry_aboutus_image1" src="'.get_template_directory_uri().'/assets/images/abt3.jpg" class="img-responsive" />';
                }
              ?>
            </div>
          </div>
        </div>
      </div>
    </section>

  <?php if( get_theme_mod('mega_manufacturing_industry_service_category') != ''){ ?>

    <section id="service-section">
      <div class="container">
        <?php if(get_theme_mod('mega_manufacturing_industry_btn_serviceheading') != '') { ?>
          <div class="service-head">
            <h4>
              <?php echo esc_html(get_theme_mod('mega_manufacturing_industry_btn_serviceheading')); ?>
            </h4>
            <p>
              <?php echo esc_html(get_theme_mod('mega_manufacturing_industry_btn_servicedescription')); ?>
            </p>
          </div>
        <?php } ?>

        <div class="row mr-0">
          <?php 
          $mega_manufacturing_industry_catData = get_theme_mod('mega_manufacturing_industry_service_category');
          if($mega_manufacturing_industry_catData) {
            $page_query = new WP_Query(array(
              'category_name' => esc_html($mega_manufacturing_industry_catData, 'mega-manufacturing-industry'),
              'order'         => 'ASC', // Order by oldest first
              'orderby'       => 'date' // Sort by date
            ));
            $count = 1; // Initialize counter

            while($page_query->have_posts()) : $page_query->the_post();
          ?>  
              <div class="col-lg-4 col-md-6 col-sm-6 serbx">
                  <div class="service-box text-center">
                      <div class="service-img">
                          <?php the_post_thumbnail(); ?>
                          <div class="ser_oly"></div>
                          <div class="count">
                              0<?php echo $count; ?>
                          </div>
                          <div class="service-content">
                              <a href="<?php echo esc_url(get_permalink()); ?>">
                                  <div class="title"><?php the_title(); ?></div>
                              </a>
                          </div>
                        <div class="clearfix"></div>
                      </div>
                  </div>
                  <div class="clearfix"></div>
              </div>
          <?php 
              $count++; // Increment counter
            endwhile; 
            wp_reset_postdata();
          } 
          ?>
        </div>
      </div>
      <div class="clearfix"></div>
    </section>

  <?php }?>
  <?php do_action( 'mega_manufacturing_industry_below_best_sellers' ); ?>

  <!-- <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div> -->
</main>
<?php get_footer(); ?>