<?php
/**
 * Mega Manufacturing Industry Theme Customizer
 *
 * @package Mega Manufacturing Industry
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Mega_Manufacturing_Industry_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Mega_Manufacturing_Industry_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Mega_Manufacturing_Industry_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Manufacturing Industry Pro', 'mega-manufacturing-industry' ),
					'description' => __( 'Buy now and enjoy exclusive discounts!', 'mega-manufacturing-industry' ),
					'pro_text' => esc_html__( 'Go Pro', 'mega-manufacturing-industry' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/products/premium-mega-manufacturing-industry-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'mega-manufacturing-industry-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'mega-manufacturing-industry-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

function mega_customizer_offer_popup_script() {
    ?>
    <style>
        #mega-offer-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(4px);
            z-index: 999998;
            display: none;
        }
        #mega-offer-popup {
            position: fixed;
            top: 45%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0.8);
            opacity: 0;
            background: #fff;
            border: 2px solid #0073aa;
            padding: 25px 25px 20px;
            z-index: 999999;
            box-shadow: 0 0 30px rgba(0,0,0,0.2);
            max-width: 420px;
            text-align: center;
            font-family: sans-serif;
            border-radius: 10px;
            transition: all 0.4s ease;
        }
        #mega-offer-popup.show {
            opacity: 1;
            transform: translate(-50%, -50%) scale(1);
        }
        #offer-close-icon {
            position: absolute;
            top: 10px;
            right: 12px;
            font-size: 20px;
            color: #333;
            cursor: pointer;
            font-weight: bold;
        }
        #offer-close-icon:hover {
            color: red;
        }
    </style>

    <script>
        (function () {
            document.addEventListener('DOMContentLoaded', function () {
                // Only show once per login session
                if (
                    !sessionStorage.getItem('mega_customizer_offer_shown') &&
                    !document.getElementById('mega-offer-popup') &&
                    !document.getElementById('mega-offer-backdrop')
                ) {
                    const backdrop = document.createElement('div');
                    backdrop.id = 'mega-offer-backdrop';

                    const popup = document.createElement('div');
                    popup.id = 'mega-offer-popup';
                    popup.innerHTML = `
						<div id="offer-close-icon" style="position: absolute; top: 10px; right: 12px; font-size: 20px; font-weight: bold; color: #333; cursor: pointer;">&times;</div>

						<div style="border: 2px solid #0073aa; border-radius: 10px; overflow: hidden; font-family: sans-serif; max-width: 600px; background: white;">

							<div style="background: #4CAF50; color: white; padding: 12px 20px; font-size: 18px; font-weight: bold; text-align: center;">
								🎁 Mega Offer Alert
							</div>

							<div style="display: flex; flex-wrap: wrap; justify-content: center; align-items: center; padding: 20px; gap: 20px;">
								<img src="<?php echo get_theme_file_uri('screenshot.png'); ?>" alt="Theme Preview" style="width: 250px; max-width: 100%; border: 1px solid #ccc; border-radius: 6px;" />

								<div>
									<h3 style="margin: 0 0 10px; font-size: 18px; color: #000;">Mega Manufacturing Industry Theme Pro</h3>
									<div style="border: 2px dashed red; border-radius: 10px; padding: 15px; background: #fff5f5; text-align: center;">
										<div style="font-size: 18px; color: red; font-weight: bold;">Get 15% OFF</div>
										<div style="font-size: 14px; color: #555;">Use Code Below:</div>
										<div style="background: red; color: white; padding: 8px 16px; font-weight: bold; margin-top: 8px; display: inline-block; border-radius: 4px;">
											FREEWORDTHEME
										</div>
									</div>
								</div>
							</div>

							<div style="background: #4CAF50; text-align: center;">
								<a href="https://www.logicalthemes.com/products/premium-mega-manufacturing-industry-wordpress-theme/" target="_blank" style="display: inline-block; padding: 12px 25px; color: white; font-weight: bold; text-decoration: none; font-size: 16px;">Upgrade Now</a>
							</div>
						</div>
					`;

                    document.body.appendChild(backdrop);
                    document.body.appendChild(popup);

                    setTimeout(() => {
                        backdrop.style.display = 'block';
                        popup.classList.add('show');
                    }, 100);

                    popup.querySelector('#offer-close-icon').addEventListener('click', () => {
                        popup.remove();
                        backdrop.remove();
                    });

                    // Only for this session (until logout or browser closed)
                    sessionStorage.setItem('mega_customizer_offer_shown', 'true');
                }
            });
        })();
    </script>
    <?php
}
add_action('customize_controls_print_footer_scripts', 'mega_customizer_offer_popup_script');

// Doing this customizer thang!
Mega_Manufacturing_Industry_Customize::get_instance();

function mega_manufacturing_industry_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'mega_manufacturing_industry_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'mega-manufacturing-industry' ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'mega_manufacturing_industry_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'mega-manufacturing-industry' ),
		'priority'   => null,
		'panel' => 'mega_manufacturing_industry_panel_id'
	) );

	//Select width layout
    $wp_customize->add_setting('mega_manufacturing_industry_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control('mega_manufacturing_industry_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','mega-manufacturing-industry'),
        'section' => 'mega_manufacturing_industry_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','mega-manufacturing-industry'),
            'Contained Width' => esc_html__('Contained Width','mega-manufacturing-industry'),
            'Boxed Width' => esc_html__('Boxed Width','mega-manufacturing-industry'),
        ),
	) );

	$wp_customize->add_setting('mega_manufacturing_industry_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control('mega_manufacturing_industry_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'mega-manufacturing-industry' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'mega-manufacturing-industry' ),
        'section' => 'mega_manufacturing_industry_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','mega-manufacturing-industry'),
            'Three Columns' => esc_html__('Three Columns','mega-manufacturing-industry'),
            'Four Columns' => esc_html__('Four Columns','mega-manufacturing-industry'),
            'Right Sidebar' => esc_html__('Right Sidebar','mega-manufacturing-industry'),
            'Left Sidebar' => esc_html__('Left Sidebar','mega-manufacturing-industry'),
            'Grid Layout' => esc_html__('Grid Layout','mega-manufacturing-industry')
        ),
	));

	$wp_customize->add_setting('mega_manufacturing_industry_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control('mega_manufacturing_industry_dropdown_anim', array(
		'section'  => 'mega_manufacturing_industry_left_right',
		'label'    => __( 'Submenu Dropdown Effect','mega-manufacturing-industry'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'mega-manufacturing-industry'),
			'zoomIn' => __('zoomIn', 'mega-manufacturing-industry'),
			'flip-up' => __('flip-up', 'mega-manufacturing-industry'),
			'none' => __('none', 'mega-manufacturing-industry')
		)
	));

	$mega_manufacturing_industry_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'mega_manufacturing_industry_typography', array(
    	'title'      => __( 'Typography', 'mega-manufacturing-industry' ),
		'priority'   => null,
		'panel' => 'mega_manufacturing_industry_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_paragraph_color', array(
		'label' => __('Paragraph Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_paragraph_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'Paragraph Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	$wp_customize->add_setting('mega_manufacturing_industry_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_atag_color', array(
		'label' => __('"a" Tag Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_atag_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( '"a" Tag Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_li_color', array(
		'label' => __('"li" Tag Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_li_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( '"li" Tag Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h1_color', array(
		'label' => __('H1 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h1_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H1 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h1_font_size',array(
		'label'	=> __('H1 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h2_color', array(
		'label' => __('H2 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h2_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H2 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h2_font_size',array(
		'label'	=> __('H2 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h3_color', array(
		'label' => __('H3 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h3_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H3 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h3_font_size',array(
		'label'	=> __('H3 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h4_color', array(
		'label' => __('H4 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h4_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H4 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h4_font_size',array(
		'label'	=> __('H4 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h5_color', array(
		'label' => __('H5 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h5_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H5 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h5_font_size',array(
		'label'	=> __('H5 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'mega_manufacturing_industry_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_h6_color', array(
		'label' => __('H6 Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_typography',
		'settings' => 'mega_manufacturing_industry_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('mega_manufacturing_industry_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices'
	));
	$wp_customize->add_control(
	    'mega_manufacturing_industry_h6_font_family', array(
	    'section'  => 'mega_manufacturing_industry_typography',
	    'label'    => __( 'H6 Fonts','mega-manufacturing-industry'),
	    'type'     => 'select',
	    'choices'  => $mega_manufacturing_industry_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('mega_manufacturing_industry_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_h6_font_size',array(
		'label'	=> __('H6 Font Size','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_typography',
		'setting'	=> 'mega_manufacturing_industry_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('mega_manufacturing_industry_topbar',array(
		'title'	=> esc_html__('Topbar','mega-manufacturing-industry'),
		'priority'	=> null,
		'panel' => 'mega_manufacturing_industry_panel_id',
	));

	$wp_customize->add_setting( 'mega_manufacturing_industry_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'mega_manufacturing_industry_sanitize_checkbox'
    ) );
    $wp_customize->add_control('mega_manufacturing_industry_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'mega-manufacturing-industry' ),
        'label' => __( 'Sticky Header','mega-manufacturing-industry' ),
        'section' => 'mega_manufacturing_industry_topbar'
    ));

	$wp_customize->add_setting('mega_manufacturing_industry_headertwitterlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_headertwitterlink',array(
		'label'	=> __('Twitter Icon Link','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_headerinstagramlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_headerinstagramlink',array(
		'label'	=> __('Instagram Icon Link','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_headerpinterestlink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_headerpinterestlink',array(
		'label'	=> __('Pinterest Icon Link','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_headerfacebooklink',array(
		'default'	=> '#',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_headerfacebooklink',array(
		'label'	=> __('Facebook Icon Link','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_phoneno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_phoneno',array(
		'label'	=> __('Add Phone Number','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'mega_manufacturing_industry_topheadbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_topheadbg_color', array(
		'label' => __('Header BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_topheadbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_topheadicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_topheadicon_color', array(
		'label' => __('Social Icons Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_topheadicon_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_topheadiconhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_topheadiconhover_color', array(
		'label' => __('Social Icons Hover Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_topheadiconhover_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headermenubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headermenubg_color', array(
		'label' => __('Menus BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headermenubg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headermenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headermenu_color', array(
		'label' => __('Menu Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headermenu_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headeractivemenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headeractivemenuhover_color', array(
		'label' => __('Active Menu & Hover Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headeractivemenuhover_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headeractivemenuhoverbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headeractivemenuhoverbg_color', array(
		'label' => __('Active Menu & Hover BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headeractivemenuhoverbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headersubmenuicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headersubmenuicon_color', array(
		'label' => __('Submenu Icon Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headersubmenuicon_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headersubmenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headersubmenu_color', array(
		'label' => __('Submenu Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headersubmenu_color',
	)));
	
	$wp_customize->add_setting( 'mega_manufacturing_industry_headersubmenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headersubmenuhover_color', array(
		'label' => __('Submenu Hover Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headersubmenuhover_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headersubmenubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headersubmenubg_color', array(
		'label' => __('Submenu BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headersubmenubg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headersubmenubghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headersubmenubghover_color', array(
		'label' => __('Submenu BG Hover Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headersubmenubghover_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headerphonenumber_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headerphonenumber_color', array(
		'label' => __('Phone Number Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headerphonenumber_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headerphonenumbericon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headerphonenumbericon_color', array(
		'label' => __('Phone Number Icon Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headerphonenumbericon_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headerphonenumbericonbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headerphonenumbericonbg_color', array(
		'label' => __('Phone Number Icon BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headerphonenumbericonbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headerphonenumberbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headerphonenumberbg_color', array(
		'label' => __('Phone Number BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headerphonenumberbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_headerphonenumberbgcurve_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_headerphonenumberbgcurve_color', array(
		'label' => __('Phone Number Curve BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_topbar',
		'settings' => 'mega_manufacturing_industry_headerphonenumberbgcurve_color',
	)));


	//home page slider
	$wp_customize->add_section( 'mega_manufacturing_industry_slidersettings' , array(
    	'title'      => esc_html__( 'Slider Settings', 'mega-manufacturing-industry' ),
		'priority'   => null,
		'panel' => 'mega_manufacturing_industry_panel_id'
	) );

	$wp_customize->add_setting('mega_manufacturing_industry_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'mega_manufacturing_industry_sanitize_checkbox'
	));
	$wp_customize->add_control('mega_manufacturing_industry_slider_hide_show',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'mega-manufacturing-industry' ),
	   'label' => esc_html__('Show / Hide slider','mega-manufacturing-industry'),
	   'section' => 'mega_manufacturing_industry_slidersettings',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'mega_manufacturing_industry_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'mega_manufacturing_industry_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'mega_manufacturing_industry_slider_page' . $count, array(
			'label'    => esc_html__( 'Select Slider Page', 'mega-manufacturing-industry' ),
			'section'  => 'mega_manufacturing_industry_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting( 'mega_manufacturing_industryslider_subtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryslider_subtitle_color', array(
		'label' => __('Subtitle Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_slidersettings',
		'settings' => 'mega_manufacturing_industryslider_subtitle_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryslider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryslider_title_color', array(
		'label' => __('Title Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_slidersettings',
		'settings' => 'mega_manufacturing_industryslider_title_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryslider_overlay_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryslider_overlay_color', array(
		'label' => __('Overlay Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_slidersettings',
		'settings' => 'mega_manufacturing_industryslider_overlay_color',
	)));


	// aboutus Section
	$wp_customize->add_section('mega_manufacturing_industry_aboutus_section',array(
		'title'	=> __('AboutUs Settings','mega-manufacturing-industry'),
		'panel' => 'mega_manufacturing_industry_panel_id',
	));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutussec_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutussec_color', array(
		'label' => __('Section BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutussec_color',
	)));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutustitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutustitle',array(
		'label'	=> __('Title','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutusdescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutusdescription',array(
		'label'	=> __('Description','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box1icon',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box1icon',array(
		'label'	=> __('Box 1 Icon','mega-manufacturing-industry'),
		'description'	=> 'Like "fa-solid fa-user"',
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box1heading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box1heading',array(
		'label'	=> __('Box 1 Heading','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box1description',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box1description',array(
		'label'	=> __('Box 1 Description','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box2icon',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box2icon',array(
		'label'	=> __('Box 2 Icon','mega-manufacturing-industry'),
		'description'	=> 'Like "fa-solid fa-user"',
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box2heading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box2heading',array(
		'label'	=> __('Box 2 Heading','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box2description',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box2description',array(
		'label'	=> __('Box 2 Description','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box3icon',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box3icon',array(
		'label'	=> __('Box 3 Icon','mega-manufacturing-industry'),
		'description'	=> 'Like "fa-solid fa-user"',
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box3heading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box3heading',array(
		'label'	=> __('Box 3 Heading','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_box3description',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_box3description',array(
		'label'	=> __('Box 3 Description','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutusyearofexno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutusyearofexno',array(
		'label'	=> __('Years Of Experience Number','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutusyearofextext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutusyearofextext',array(
		'label'	=> __('Years Of Experience Text','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_latesttechnologyno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_latesttechnologyno',array(
		'label'	=> __('Latest Technology Number','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_aboutus_latesttechnologytext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_aboutus_latesttechnologytext',array(
		'label'	=> __('Latest Technology Text','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'mega_manufacturing_industry_aboutus_image1',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'mega_manufacturing_industry_aboutus_image1',
	        array(
			    'label'   		=> __('Image 1','mega-manufacturing-industry'),
				'description'   		=> __('Image size 745*523','mega-manufacturing-industry'),
	            'section' => 'mega_manufacturing_industry_aboutus_section',
	            'settings' => 'mega_manufacturing_industry_aboutus_image1',
	        )
	    )
	);

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_title_color', array(
		'label' => __('Title Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_title_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_description_color', array(
		'label' => __('Description Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_description_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_boxicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_boxicon_color', array(
		'label' => __('Box Icon Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_boxicon_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_boxiconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_boxiconbg_color', array(
		'label' => __('Box Icon BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_boxiconbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_boxtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_boxtitle_color', array(
		'label' => __('Box Title Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_boxtitle_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_boxdescription_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_boxdescription_color', array(
		'label' => __('Box Description Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_boxdescription_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_yearofexpno_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_yearofexpno_color', array(
		'label' => __('Years Of Experience Number Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_yearofexpno_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_yearofexptext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_yearofexptext_color', array(
		'label' => __('Years Of Experience Text Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_yearofexptext_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_latesttechnologynum_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_latesttechnologynum_color', array(
		'label' => __('Latest Technology Number Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_latesttechnologynum_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_latesttechnologytext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_latesttechnologytext_color', array(
		'label' => __('Latest Technology Text Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_latesttechnologytext_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryaboutus_boxbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryaboutus_boxbg_color', array(
		'label' => __('Box BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_aboutus_section',
		'settings' => 'mega_manufacturing_industryaboutus_boxbg_color',
	)));


	// Services Settings
	$wp_customize->add_section('mega_manufacturing_industry_services_section',array(
		'title'	=> __('Services Settings','mega-manufacturing-industry'),
		'panel' => 'mega_manufacturing_industry_panel_id',
	));

	$wp_customize->add_setting('mega_manufacturing_industry_btn_serviceheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_btn_serviceheading',array(
		'label'	=> __('Heading','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_btn_servicedescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_btn_servicedescription',array(
		'label'	=> __('Description','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'type'	 => 'text'
	));
	

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('mega_manufacturing_industry_service_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices',
	));
	$wp_customize->add_control('mega_manufacturing_industry_service_category',array(
		'type'    => 'select',
		'choices' => $cat_post,
		'label' => esc_html__('Select Category To Display Post','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
	));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_heading_color', array(
		'label' => __('Heading Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_heading_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_description_color', array(
		'label' => __('Description Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_description_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_headingbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_headingbrd_color', array(
		'label' => __('Heading Border Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_headingbrd_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_boxnum_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_boxnum_color', array(
		'label' => __('Box Number Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_boxnum_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_boxtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_boxtitle_color', array(
		'label' => __('Box Title Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_boxtitle_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryservices_boxtitlehover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryservices_boxtitlehover_color', array(
		'label' => __('Box Title Hover Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_services_section',
		'settings' => 'mega_manufacturing_industryservices_boxtitlehover_color',
	)));


	//footer
	$wp_customize->add_section('mega_manufacturing_industry_footer_section',array(
		'title'	=> esc_html__('Footer Settings','mega-manufacturing-industry'),
		'panel' => 'mega_manufacturing_industry_panel_id'
	));
		
	$wp_customize->add_setting('mega_manufacturing_industry_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mega_manufacturing_industry_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('mega_manufacturing_industry_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mega_manufacturing_industry_footer_copy_font_size',array(
		'label'	=> __('Copyright Font Size','mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'mega_manufacturing_industryfooter_copyrighttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryfooter_copyrighttext_color', array(
		'label' => __('Copyright Text Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'settings' => 'mega_manufacturing_industryfooter_copyrighttext_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryfooter_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryfooter_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'settings' => 'mega_manufacturing_industryfooter_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industryfooter_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industryfooter_bg_color', array(
		'label' => __('BG Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'settings' => 'mega_manufacturing_industryfooter_bg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_wedgets_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_wedgets_color', array(
		'label' => __('Wedgets Title Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'settings' => 'mega_manufacturing_industry_wedgets_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_wedgets_menus_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_wedgets_menus_color', array(
		'label' => __('Wedgets Menus Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_footer_section',
		'settings' => 'mega_manufacturing_industry_wedgets_menus_color',
	)));

	//Wocommerce Shop Page
	$wp_customize->add_section('mega_manufacturing_industry_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','mega-manufacturing-industry'),
		'panel' => 'mega_manufacturing_industry_panel_id'
	));

	$wp_customize->add_setting( 'mega_manufacturing_industry_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'mega_manufacturing_industry_sanitize_choices',
	) );
	$wp_customize->add_control( 'mega_manufacturing_industry_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'mega-manufacturing-industry' ),
		'description'	=> __('How many products should be shown per Column?','mega-manufacturing-industry'),
		'section'  => 'mega_manufacturing_industry_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('mega_manufacturing_industry_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'mega_manufacturing_industry_sanitize_float',
	));	
	$wp_customize->add_control('mega_manufacturing_industry_products_per_page',array(
		'label'	=> __('Product Per Page','mega-manufacturing-industry'),
		'description'	=> __('How many products should be shown per page?','mega-manufacturing-industry'),
		'section'	=> 'mega_manufacturing_industry_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'mega_manufacturing_industry_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_woocommerce_shop_page',
		'settings' => 'mega_manufacturing_industry_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'mega_manufacturing_industry_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_woocommerce_shop_page',
		'settings' => 'mega_manufacturing_industry_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'mega_manufacturing_industry_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_product_sale_color', array(
		'label' => __('Sale Badge Color', 'mega-manufacturing-industry'),
		'section' => 'mega_manufacturing_industry_woocommerce_shop_page',
		'settings' => 'mega_manufacturing_industry_product_sale_color',
	)));

	// site logo size
	$wp_customize->add_setting('mega_manufacturing_industry_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'mega_manufacturing_industry_sanitize_float'
	));
	$wp_customize->add_control('mega_manufacturing_industry_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','mega-manufacturing-industry'),
		'section' => 'title_tagline'
	));

	// logo site title
	$wp_customize->add_setting('mega_manufacturing_industry_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'mega_manufacturing_industry_sanitize_checkbox'
    ));
    $wp_customize->add_control('mega_manufacturing_industry_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','mega-manufacturing-industry'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'mega_manufacturing_industry_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_site_title_color', array(
		'label' => __('Site Title Color', 'mega-manufacturing-industry'),
		'section' => 'title_tagline',
		'settings' => 'mega_manufacturing_industry_site_title_color',
	)));

    $wp_customize->add_setting( 'mega_manufacturing_industry_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mega_manufacturing_industry_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'mega-manufacturing-industry'),
		'section' => 'title_tagline',
		'settings' => 'mega_manufacturing_industry_site_tagline_color',
	)));
}
add_action( 'customize_register', 'mega_manufacturing_industry_customize_register' );