<?php
/**
 * Display Header.
 * @package Mega Manufacturing Industry
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<header role="banner" class="banner">
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'mega-manufacturing-industry' ); ?></a>
		<div id="header">
			<div class="header-box">
				<div class="top-head ">
					<div class="container">	
						<div class="row">
							<div class="col-lg-4 col-md-4 col-sm-6 logobx_m">
								<div class="logobx">
									<!-- <div class="logobxinn"></div> -->
									<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
								</div>
							</div>
							<div class="col-lg-8 col-md-8 col-sm-6 m_txt">
								<div class="socialicons">
									<a href="<?php echo esc_url(get_theme_mod('mega_manufacturing_industry_headertwitterlink')); ?>">
										<i class="fa-brands fa-twitter"></i>
									</a>
									<a href="<?php echo esc_url(get_theme_mod('mega_manufacturing_industry_headerinstagramlink')); ?>">
										<i class="fa-brands fa-instagram"></i>
									</a>
									<a href="<?php echo esc_url(get_theme_mod('mega_manufacturing_industry_headerpinterestlink')); ?>">
										<i class="fa-brands fa-pinterest-p"></i>
									</a>
									<a href="<?php echo esc_url(get_theme_mod('mega_manufacturing_industry_headerfacebooklink')); ?>">
										<i class="fab fa-facebook-f"></i>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="container">	
					<div class="bottom-head">
						<div class="row mr-0">
							<div class="col-lg-10 col-md-9 col-sm-8 m-mnu">
								<div class="menu-section text-lg-center">
									<div class="<?php if( get_theme_mod( 'mega_manufacturing_industry_sticky_header', false) != '') { ?>sticky-menubox<?php } else { ?>close-sticky <?php } ?>">
										<?php get_template_part( 'template-parts/navigation/site', 'nav' ); ?>
									</div>
								</div>
							</div>
							<div class="col-lg-2 col-md-3 col-sm-4 pd-0 m-btn">
								<?php if(get_theme_mod('mega_manufacturing_industry_phoneno') != ''){ ?>
									<div class="phbtn">
									<a href="tel:<?php echo esc_attr(get_theme_mod('mega_manufacturing_industry_phoneno')); ?>"> <i class="fa-solid fa-phone"></i>
									<?php echo esc_html(get_theme_mod('mega_manufacturing_industry_phoneno')); ?></a>
								</div>
								<?php }?>	
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<?php if(is_singular()) {?>
		<div class="inner-head">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6 align-self-center">
						<div class="header-content">
							<h1><?php single_post_title(); ?></h1>
							<div class="lt-breadcrumbs">
								<?php mega_manufacturing_industry_breadcrumb(); ?>
							</div>
						</div>
					</div>
					<?php if(has_post_thumbnail()){?>
						<div class="col-lg-6 col-md-6 align-self-end">
							
						</div>
					<?php }?>
				</div>
				
			</div>
		</div>
	<?php }?>