<?php
/**
 * The template part for displaying slider
 * @package Hotel Resort 
 * @subpackage hotel_resort
 * @since 1.0
 */
?>
<?php 
  $archive_year  = get_the_time('Y'); 
  $archive_month = get_the_time('m'); 
  $archive_day   = get_the_time('d'); 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="post-wrap p-2">
    <h2 class="section-title m-0 py-2 ps-0"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
    <div class="date-box py-2"><i class="fas fa-calendar-alt me-2"></i><a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></div>
    <div class="box-image">
      <?php if ( ! is_single() ) {
        // If not a single post, highlight the gallery.
        if ( get_post_gallery() ) {
          echo '<div class="entry-gallery">';
            echo get_post_gallery();
          echo '</div>';
        };
      };
      ?>
    </div>
    <div class="entry-content">
      <?php the_excerpt();?>
    </div>  
    <div class="cat-box mt-3">
     <i class="fas fa-folder-open pe-2"></i><?php the_category(); ?>
    </div>  
    <div class="clearfix"></div>
  </div>
</article>