<?php
/**
 * Displaying all single posts.
 * @package Hotel Resort
 */

get_header(); ?>

<?php do_action( 'hotel_resort_single_header' ); ?>

<div class="container">
	<main id="main" role="main" class="content-with-sidebar">
	    <div class="wrapper">
		    <?php
	        $hotel_resort_layout = get_theme_mod( 'hotel_resort_theme_options','Right Sidebar');
	        if($hotel_resort_layout == 'One Column'){?>
		        <div id="main-content" class="py-3">
					<?php while ( have_posts() ) : the_post(); 
						get_template_part( 'template-parts/single-post' );
		            endwhile; // end of the loop. ?>
		       	</div>
		    <?php }else if($hotel_resort_layout == 'Three Columns'){?>
			    <div class="row">
			    	<div class="col-lg-3 col-md-3 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-1'); ?></div>
			       	<div class="col-lg-6 col-md-6 py-3" id="main-content">
						<?php while ( have_posts() ) : the_post(); 
							get_template_part( 'template-parts/single-post' );
			            endwhile; // end of the loop. ?>
			       	</div>
					<div class="col-lg-3 col-md-3 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-1'); ?></div>
				</div>
			<?php }else if($hotel_resort_layout == 'Four Columns'){?>
				<div class="row">
			    	<div class="col-lg-3 col-md-3 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-2'); ?></div>
			       	<div class="col-lg-3 col-md-3 py-3" id="main-content">
						<?php while ( have_posts() ) : the_post(); 
							get_template_part( 'template-parts/single-post' );
			            endwhile; // end of the loop. ?>
			       	</div>
					<div class="col-lg-3 col-md-3 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-2'); ?></div>
					<div class="col-lg-3 col-md-3 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-3'); ?></div>  
				</div> 	
       		<?php }else if($hotel_resort_layout == 'Right Sidebar'){?>
	       		<div class="row">
			       	<div class="col-lg-8 col-md-8 py-3" id="main-content">
						<?php while ( have_posts() ) : the_post(); 
							get_template_part( 'template-parts/single-post' );
			            endwhile; // end of the loop. ?>
			       	</div>
					<div class="col-lg-4 col-md-4 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-1'); ?></div>
				</div>
			<?php }else if($hotel_resort_layout == 'One Column'){?>
				<div class="row">
		       		<div class="col-lg-4 col-md-4 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-1'); ?></div>
					<div class="col-lg-8 col-md-8 py-3" id="main-content">
						<?php while ( have_posts() ) : the_post(); 
							get_template_part( 'template-parts/single-post' );
			            endwhile; // end of the loop. ?>
			       	</div>
		       	</div>	    
			<?php }else if($hotel_resort_layout == 'Grid Layout'){?>
				<div class="row">
			       	<div class="col-lg-8 col-md-8 py-3" id="main-content">
						<?php while ( have_posts() ) : the_post(); 
							get_template_part( 'template-parts/single-post' );
			            endwhile; // end of the loop. ?>
			       	</div>
					<div class="col-lg-4 col-md-4 mt-5" id="sidebar"><?php dynamic_sidebar('sidebar-1'); ?></div>
				</div>
			<?php }else {?>
				<div id="main-content" class="py-3">
					<?php while ( have_posts() ) : the_post(); 
						get_template_part( 'template-parts/single-post' );
		            endwhile; // end of the loop. ?>
		       	</div>
			<?php } ?>
	        <div class="clearfix"></div>
	    </div>
	</main>    
</div>

<?php do_action( 'hotel_resort_single_footer' ); ?>

<?php get_footer(); ?>