<?php
/**
 * Displaying Search Results pages.
 * @package Hotel Resort
 * @subpackage hotel-resort
 * @since 1.0
 */

get_header(); ?>

<main id="main" role="main">
    <?php /** post section **/ ?>
    <div class="container">   
        <?php $hotel_resort_layout = get_theme_mod( 'hotel_resort_theme_options','Right Sidebar');
        if($hotel_resort_layout == 'One Column'){?> 
            <div class="row">     
                <div id="firstbox" class="col-lg-12 col-md-12 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                        /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ));
                        ?>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
        <?php }else if($hotel_resort_layout == 'Three Columns'){?>
            <div class="row">
                <div id="sidebar" class="col-lg-3 col-md-3 mt-5"><?php dynamic_sidebar('sidebar-2'); ?></div>
                <div id="firstbox" class="col-lg-6 col-md-6 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                      /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                      <?php
                          // Previous/next page navigation.
                          the_posts_pagination( array(
                              'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                              'next_text'          => __( 'Next page', 'hotel-resort' ),
                              'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                          ) );
                      ?>
                    </div>
                </div>
                <div id="sidebar" class="col-lg-3 col-md-3 mt-5"><?php dynamic_sidebar('sidebar-2'); ?></div>
            </div>
        <?php }else if($hotel_resort_layout == 'Four Columns'){?>
            <div class="row">
                <div id="sidebar" class="col-lg-3 col-md-3 mt-5"><?php dynamic_sidebar('sidebar-2'); ?></div>
                <div id="firstbox" class="col-lg-3 col-md-3 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                      /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ) );
                        ?>
                    </div>
                </div>                
                <div id="sidebar" class="col-lg-3 col-md-3 mt-5"><?php dynamic_sidebar('sidebar-2'); ?></div>
                <div id="sidebar" class="col-lg-3 col-md-3 mt-5"><?php dynamic_sidebar('sidebar-3'); ?></div>
            </div>
        <?php }else if($hotel_resort_layout == 'Right Sidebar'){?>
            <div class="row">
                <div id="firstbox" class="col-lg-8 col-md-8 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                      /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ));
                        ?>
                    </div>
                </div>                
                <div class="col-lg-4 col-md-4"><?php get_sidebar(); ?></div>
            </div>
        <?php }else if($hotel_resort_layout == 'Left Sidebar'){?>
            <div class="row">
                <div class="col-lg-4 col-md-4"><?php get_sidebar(); ?></div>
                <div id="firstbox" class="col-lg-8 col-md-8 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                      /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ) );
                        ?>
                    </div>
                </div>
            </div>   
        <?php }else if($hotel_resort_layout == 'Grid Layout'){?>
            <div class="row">
                <div id="firstbox" class="col-lg-12 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <div class="row">
                        <?php if ( have_posts() ) :
                          /* Start the Loop */
                            while ( have_posts() ) : the_post();
                              get_template_part( 'template-parts/grid-layout' ); 
                            endwhile;
                            else :
                              get_template_part( 'no-results' ); 
                            endif; 
                        ?>
                    </div>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ));
                        ?>
                    </div>
                </div>                
            </div>
        <?php }else {?>
            <div class="row">     
                <div id="firstbox" class="col-lg-12 col-md-12 mainbox mt-5">
                    <h1 class="search-title mb-2"><?php /* translators: %s: search term */ printf(esc_html('Search Results for: %s','hotel-resort'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                      /* Start the Loop */
                        while ( have_posts() ) : the_post();
                          get_template_part( 'template-parts/content',get_post_format() ); 
                        endwhile;
                        else :
                          get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <div class="navigation">
                        <?php
                            // Previous/next page navigation.
                            the_posts_pagination( array(
                                'prev_text'          => __( 'Previous page', 'hotel-resort' ),
                                'next_text'          => __( 'Next page', 'hotel-resort' ),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'hotel-resort' ) . ' </span>',
                            ));
                        ?>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
        <?php } ?>    
    </div>
</main>    

<?php get_footer(); ?>