<?php
/**
 * Template Name: Home Custom Page
 */
?>
<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'hotel_resort_before_slider' ); ?>
  <?php /** slider section **/ ?>
    <?php if( get_theme_mod('hotel_resort_slider_hide', false) != ''){ ?>
      <section id="slider" class="p-0 m-auto mw-100">
        <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
          <?php $hotel_resort_content_pages = array();
            for ( $count = 1; $count <= 4; $count++ ) {
              $mod = intval( get_theme_mod( 'hotel_resort_slidersettings_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $hotel_resort_content_pages[] = $mod;
              }
            }
            if( !empty($hotel_resort_content_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $hotel_resort_content_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                $i = 1;
          ?>
          <div class="carousel-inner" role="listbox">
            <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
                <?php the_post_thumbnail(); ?>
                <?php
                  $hotel_resort_slider_animation = get_theme_mod('hotel_resort_slider_animation', '')
                ?>
                <div class="carousel-caption <?php echo ($hotel_resort_slider_animation)?>">
                  <div class="inner_carousel">
                    <h1><?php the_title(); ?></h1>
                    <p><?php $excerpt = get_the_excerpt(); echo esc_html( hotel_resort_string_limit_words( $excerpt,30 ) ); ?></p>
                    <div class="more-btn my-lg-3 my-md-3 my-0">              
                      <a href="<?php the_permalink(); ?>" class="py-2 px-3"><?php esc_html_e('LEARN MORE','hotel-resort'); ?><span class="screen-reader-text"><?php esc_html_e( 'LEARN MORE','hotel-resort' );?></span></a>
                    </div>
                  </div>
                </div>
              </div>
            <?php $i++; endwhile; 
            wp_reset_postdata();?>
          </div>
          <?php else : ?>
              <div class="no-postfound"></div>
            <?php endif;
          endif;?>
          <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
            <span class="carousel-control-prev-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous','hotel-resort' );?></span>
          </a>
          <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
            <span class="carousel-control-next-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next','hotel-resort' );?></span>
          </a>
        </div>  
        <div class="clearfix"></div>
      </section>
    <?php }?>
  <?php do_action( 'hotel_resort_after_slider' ); ?>

    <?php /*--accomodation--*/?>
      <section id="accomodation" class="text-center py-3">
        <div class="container">
          <div class="acco-main-box">
            <?php if( get_theme_mod('hotel_resort_title') != ''){ ?>     
              <h2><?php echo esc_html(get_theme_mod('hotel_resort_title','')); ?></h2>
              <div class="images_border">
                <img src="<?php echo esc_url( get_theme_mod('',esc_url(get_template_directory_uri()).'/images/Design.png') ); ?>" alt="<?php esc_attr_e( 'Title image','hotel-resort' );?>">
              </div>
            <?php }?>
            <?php if( get_theme_mod('hotel_resort_subtitle') != ''){ ?>
              <div class="subtitle py-4"><?php echo esc_html(get_theme_mod('hotel_resort_subtitle','')); ?>
              </div>
            <?php }?>
          </div>
          <div class="row">
            <?php $hotel_resort_content_pages = array();
            for ( $count = 0; $count <= 2; $count++ ) {
              $mod = absint( get_theme_mod( 'hotel_resort_page_settings' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $hotel_resort_content_pages[] = $mod;
              }
            }
            if( !empty($hotel_resort_content_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $hotel_resort_content_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
              if ( $query->have_posts() ) :
                $count = 0;
                while ( $query->have_posts() ) : $query->the_post(); ?>
                  <div class="col-md-4">
                    <div class="box-image text-center">
                      <?php the_post_thumbnail(); ?>
                    </div>
                    <div class="box-content text-center my-2">
                      <h3 class="py-2"><?php the_title(); ?></h3>
                      <p><?php $excerpt = get_the_excerpt(); echo esc_html( hotel_resort_string_limit_words( $excerpt,15 ) ); ?></p>
                      <div class="clearfix"></div>
                      <div class="wow bounceInUp"><a class="r_button hvr-sweep-to-right py-2 px-3 mt-2"  href="<?php the_permalink(); ?>"><?php esc_html_e('VIEW ROOM DETAILS','hotel-resort'); ?><span class="screen-reader-text"><?php esc_html_e( 'VIEW ROOM DETAILS','hotel-resort' );?></span></a>
                      </div>
                    </div>
                  </div>
                <?php $count++; endwhile; ?>
              <?php else : ?>
                <div class="no-postfound"></div>
              <?php endif;
            endif; wp_reset_postdata();?>
          </div>
          <div class="clearfix"></div>
        </div> 
      </section>
  <?php do_action( 'hotel_resort_after_accomodation' ); ?>

  <div id="main-content" class="container py-3">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>
<?php get_footer(); ?>