<?php
/**
 * This template display "post cannot be found".
 * @package Hotel Resort
 */
?>

<header>
	<h2 class="entry-title"><?php esc_html_e( 'Nothing Found', 'hotel-resort' ); ?></h2>
</header>
<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
	<p><?php printf( esc_html__( 'Ready to publish your first post? Get started here.', 'hotel-resort' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
<?php elseif ( is_search() ) : ?>
	<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'hotel-resort' ); ?></p><br />
		<?php get_search_form(); ?>
<?php else : ?>
	<p><?php esc_html_e( 'Dont worry it happens to the best of us.', 'hotel-resort' ); ?></p><br />
	<div class="read-moresec my-3">
		<a href="<?php echo esc_url( home_url() ); ?>" class="button hvr-sweep-to-right"><?php esc_html_e( 'Return to the home page', 'hotel-resort' ); ?><span class="screen-reader-text"><?php esc_html_e( 'Return to the home page','hotel-resort' );?></span></a>
	</div>
<?php endif; ?>