<?php
/**
 * Hotel Resort Theme Customizer
 *
 * @package Hotel Resort
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function hotel_resort_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'hotel_resort_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'LT Settings', 'hotel-resort' ),
	    'description' => __( 'Description of what this panel does.', 'hotel-resort' ),
	) );

	$wp_customize->add_section( 'hotel_resort_left_right' , array(
    	'title'      => __( 'General Settings', 'hotel-resort' ),
		'priority'   => null,
		'panel' => 'hotel_resort_panel_id'
	) );

	//Select width layout
    $wp_customize->add_setting('hotel_resort_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','hotel-resort'),
        'section' => 'hotel_resort_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','hotel-resort'),
            'Contained Width' => esc_html__('Contained Width','hotel-resort'),
            'Boxed Width' => esc_html__('Boxed Width','hotel-resort'),
        ),
	) );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('hotel_resort_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'hotel_resort_sanitize_choices'	        
	));
	$wp_customize->add_control('hotel_resort_theme_options', array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'hotel-resort' ),
        'label' => __( 'Post Sidebar Layout', 'hotel-resort' ),
        'section' => 'hotel_resort_left_right',
        'choices' => array(
            'One Column' => __('One Column ','hotel-resort'),
            'Three Columns' => __('Three Columns','hotel-resort'),
            'Four Columns' => __('Four Columns','hotel-resort'),
            'Right Sidebar' => __('Right Sidebar','hotel-resort'),
            'Left Sidebar' => __('Left Sidebar','hotel-resort'),
            'Grid Layout' => __('Grid Layout','hotel-resort')
        ),
	));

	$wp_customize->add_setting('hotel_resort_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_dropdown_anim', array(
		'section'  => 'hotel_resort_left_right',
		'label'    => __( 'Submenu Dropdown Effect','hotel-resort'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'hotel-resort'),
			'zoomIn' => __('zoomIn', 'hotel-resort'),
			'flip-up' => __('flip-up', 'hotel-resort'),
			'none' => __('none', 'hotel-resort')
		)
	));

	$hotel_resort_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Kavoon' =>'Kavoon',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Topbar section
	$wp_customize->add_section('hotel_resort_topbar',array(
		'title'	=> __('Topbar','hotel-resort'),
		'description'	=> __('Add Topbar Content here','hotel-resort'),
		'priority'	=> null,
		'panel' => 'hotel_resort_panel_id',
	));

	$wp_customize->add_setting( 'hotel_resort_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'hotel_resort_sanitize_checkbox'
    ) );
    $wp_customize->add_control('hotel_resort_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'hotel-resort' ),
        'label' => __( 'Sticky Header','hotel-resort' ),
        'section' => 'hotel_resort_topbar'
    ));

    //Show /Hide Topbar
	$wp_customize->add_setting( 'hotel_resort_show_topbar',array(
		'default' => false,
      	'sanitize_callback'	=> 'hotel_resort_sanitize_checkbox'
    ) );
    $wp_customize->add_control('hotel_resort_show_topbar',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable Topbar.', 'hotel-resort' ),
        'label' => __( 'Topbar','hotel-resort' ),
        'section' => 'hotel_resort_topbar'
    ));

	$wp_customize->add_setting('hotel_resort_phone',array(
		'default'	=> '',
		'sanitize_callback'	=> 'hotel_resort_sanitize_phone_number'
	));	
	$wp_customize->add_control('hotel_resort_phone',array(
		'label'	=> __('Add Phone Number','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_phone',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('hotel_resort_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));	
	$wp_customize->add_control('hotel_resort_mail',array(
		'label'	=> __('Add Email','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_mail',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('hotel_resort_location',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('hotel_resort_location',array(
		'label'	=> __('Add Location','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_location',
		'type'		=> 'text'
	));

	// This is Topbar Color picker setting
	$wp_customize->add_setting( 'hotel_resort_topbaricon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_topbaricon_color', array(
		'label' => __('Topbar Icon Color', 'hotel-resort'),
		'section' => 'hotel_resort_topbar',
		'settings' => 'hotel_resort_topbaricon_color',
	)));

	$wp_customize->add_setting( 'hotel_resort_topbar_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_topbar_color', array(
		'label' => __('Topbar Color', 'hotel-resort'),
		'section' => 'hotel_resort_topbar',
		'settings' => 'hotel_resort_topbar_color',
	)));

	$wp_customize->add_setting( 'hotel_resort_topbarbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_topbarbg_color', array(
		'label' => __('Topbar Bg Color', 'hotel-resort'),
		'section' => 'hotel_resort_topbar',
		'settings' => 'hotel_resort_topbarbg_color',
	)));

	//This is Topbar FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_topbar_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_topbar_font_family', array(
	    'section'  => 'hotel_resort_topbar',
	    'label'    => __( 'Topbar Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_topbar_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_topbar_font_size',array(
		'label'	=> __('Topbar Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_topbar_font_size',
		'type'	=> 'text'
	));

	//This is logo FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_logo_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_logo_font_family', array(
	    'section'  => 'hotel_resort_topbar',
	    'label'    => __( 'Logo Font','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	//This is logo FontSize setting
	$wp_customize->add_setting('hotel_resort_logo_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_logo_font_size',array(
		'label'	=> __('Logo Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_logo_font_size',
		'type'	=> 'number'
	));

	//This is Description FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_description_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_description_font_family', array(
	    'section'  => 'hotel_resort_topbar',
	    'label'    => __( 'Description Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_description_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_description_font_size',array(
		'label'	=> __('Description Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_topbar',
		'setting'	=> 'hotel_resort_description_font_size',
		'type'	=> 'text'
	));

	//Social Icons(topbar)
	$wp_customize->add_section('hotel_resort_social_media',array(
		'title'	=> __('Social Media','hotel-resort'),
		'description'	=> __('Add Social Media Url here','hotel-resort'),
		'priority'	=> null,
		'panel' => 'hotel_resort_panel_id',
	));

	$wp_customize->add_setting('hotel_resort_youtube_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_youtube_url',array(
		'label'	=> __('Add Youtube link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_youtube_url',
		'type'		=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_facebook_url',array(
		'label'	=> __('Add Facebook link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_facebook_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_twitter_url',array(
		'label'	=> __('Add Twitter link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_twitter_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_rss_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_rss_url',array(
		'label'	=> __('Add RSS link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_rss_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_insta_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('hotel_resort_insta_url',array(
		'label'	=> __('Add Instagram link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_insta_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_pint_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_pint_url',array(
		'label'	=> __('Add Pinterest link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_pint_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('hotel_resort_linkedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('hotel_resort_linkedin_url',array(
		'label'	=> __('Add LinkedIn link','hotel-resort'),
		'section'	=> 'hotel_resort_social_media',
		'setting'	=> 'hotel_resort_linkedin_url',
		'type'	=> 'url'
	));

	//Social Icons Font Size
	$wp_customize->add_setting('hotel_resort_social_icon_fontsize',array(
		'default'=> '',
		'sanitize_callback'	=> 'hotel_resort_sanitize_float'
	));
	$wp_customize->add_control('hotel_resort_social_icon_fontsize',array(
		'label'	=> __('Social Icons Font Size','hotel-resort'),
		'input_attrs' => array(
            'step' => 1,
			'min'  => 0,
			'max'  => 100,
        ),
		'section'=> 'hotel_resort_social_media',
		'type'=> 'number',
	));

	$wp_customize->add_setting( 'hotel_resort_social_icon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_social_icon_color', array(
		'label' => __('Social Icon Color', 'hotel-resort'),
		'section' => 'hotel_resort_social_media',
		'settings' => 'hotel_resort_social_icon_color',
	)));

	//home page slider
	$wp_customize->add_section( 'hotel_resort_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'hotel-resort' ),
		'priority'   => null,
		'panel' => 'hotel_resort_panel_id'
	) );

	$wp_customize->add_setting('hotel_resort_slider_hide',array(
       'default' => false,
       'sanitize_callback'  => 'hotel_resort_sanitize_checkbox'
    ));
    $wp_customize->add_control('hotel_resort_slider_hide',array(
       'type' => 'checkbox',
       'description' => __( 'Click on the checkbox to enable slider.', 'hotel-resort' ),
       'label' => __('Show / Hide slider','hotel-resort'),
       'section' => 'hotel_resort_slidersettings',
    ));

	//This is online transaction effect
	$wp_customize->add_setting('hotel_resort_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_slider_animation', array(
		'section'  => 'hotel_resort_slidersettings',
		'label'    => __( 'Onload Transaction Effect','hotel-resort'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'hotel-resort'),
			'bounceInRight' => __('bounceInRight', 'hotel-resort'),
			'bounceInUp' => __('bounceInUp', 'hotel-resort'),
			'bounceInDown' => __('bounceInDown', 'hotel-resort'),
			'zoomIn' => __('zoomIn', 'hotel-resort'),
			'zoomOut' => __('zoomOut', 'hotel-resort'),
			'fadeInLeft' => __('fadeInLeft', 'hotel-resort'),
			'fadeInRight' => __('fadeInRight', 'hotel-resort'),
			'fadeInUp' => __('fadeInUp', 'hotel-resort'),
			'fadeInDown' => __('fadeInDown', 'hotel-resort'),
			'flip-up' => __('flip-up', 'hotel-resort'),
			'none' => __('none', 'hotel-resort')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		// Add color scheme setting and control.
		$wp_customize->add_setting( 'hotel_resort_slidersettings_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'hotel_resort_sanitize_dropdown_pages'
		) );

		$wp_customize->add_control( 'hotel_resort_slidersettings_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'hotel-resort' ),
			'section'  => 'hotel_resort_slidersettings',
			'type'     => 'dropdown-pages'
		) );		
	}

	// This is title Color picker setting
	$wp_customize->add_setting( 'hotel_resort_slider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_slider_title_color', array(
		'label' => __('Title Color', 'hotel-resort'),
		'section' => 'hotel_resort_slidersettings',
		'settings' => 'hotel_resort_slider_title_color',
	)));

	//This is title FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_slider_title_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_slider_title_font_family', array(
	    'section'  => 'hotel_resort_slidersettings',
	    'label'    => __( 'Title Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_slider_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_slider_title_font_size',array(
		'label'	=> __('Title Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_slidersettings',
		'setting'	=> 'hotel_resort_slider_title_font_size',
		'type'	=> 'text'
	));

	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'hotel_resort_slider_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_slider_paragraph_color', array(
		'label' => __('Content Color', 'hotel-resort'),
		'section' => 'hotel_resort_slidersettings',
		'settings' => 'hotel_resort_slider_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_slider_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control(
	    'hotel_resort_slider_paragraph_font_family', array(
	    'section'  => 'hotel_resort_slidersettings',
	    'label'    => __( 'Content Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_slider_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_slider_paragraph_font_size',array(
		'label'	=> __('Content Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_slidersettings',
		'setting'	=> 'hotel_resort_slider_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is Button Color picker setting
	$wp_customize->add_setting( 'hotel_resort_slider_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_slider_atag_color', array(
		'label' => __('Button Color', 'hotel-resort'),
		'section' => 'hotel_resort_slidersettings',
		'settings' => 'hotel_resort_slider_atag_color',
	)));

	$wp_customize->add_setting( 'hotel_resort_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_slider_btnbg_color', array(
		'label' => __('Button BG Color', 'hotel-resort'),
		'section' => 'hotel_resort_slidersettings',
		'settings' => 'hotel_resort_slider_btnbg_color',
	)));

	//This is Button FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_slider_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_slider_atag_font_family', array(
	    'section'  => 'hotel_resort_slidersettings',
	    'label'    => __( 'Button Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_slider_atag_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_slider_atag_font_size',array(
		'label'	=> __('Button Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_slidersettings',
		'setting'	=> 'hotel_resort_slider_atag_font_size',
		'type'	=> 'text'
	));
	
	//Accomodation
	$wp_customize->add_section('hotel_resort_acco',array(
		'title'	=> __('Accomodation','hotel-resort'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','hotel-resort'),
		'panel' => 'hotel_resort_panel_id',
	));
	
	$wp_customize->add_setting('hotel_resort_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('hotel_resort_title',array(
		'label'	=> __('Section Title','hotel-resort'),
		'section'=> 'hotel_resort_acco',
		'setting'=> 'hotel_resort_title',
		'type'=> 'text'
	));
	
	$wp_customize->add_setting('hotel_resort_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('hotel_resort_subtitle',array(
		'label'	=> __('Section Sub-Title','hotel-resort'),
		'section'=> 'hotel_resort_acco',
		'setting'=> 'hotel_resort_subtitle',
		'type'=> 'text'
	));

	for ( $count = 0; $count <= 2; $count++ ) {
		$wp_customize->add_setting( 'hotel_resort_page_settings' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'hotel_resort_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'hotel_resort_page_settings' . $count, array(
			'label'    => __( 'Select Accomodation Page', 'hotel-resort' ),
			'section'  => 'hotel_resort_acco',
			'type'     => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting('hotel_resort_accomodation_img_height',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_img_height',array(
		'label'	=> __('Image Height','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_img_height',
		'type'	=> 'number'
	));

	// This is accomodation title Color picker setting
	$wp_customize->add_setting( 'hotel_resort_accomodation_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_accomodation_heading_color', array(
		'label' => __('Title Color', 'hotel-resort'),
		'section' => 'hotel_resort_acco',
		'settings' => 'hotel_resort_accomodation_heading_color',
	)));

	$wp_customize->add_setting( 'hotel_resort_accomodation_subheading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_accomodation_subheading_color', array(
		'label' => __('Subtitle Color', 'hotel-resort'),
		'section' => 'hotel_resort_acco',
		'settings' => 'hotel_resort_accomodation_subheading_color',
	)));

	//This is accomodation FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_accomodation_heading_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_accomodation_heading_font_family', array(
	    'section'  => 'hotel_resort_acco',
	    'label'    => __( 'Title Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	//This is accomodation FontSize setting
	$wp_customize->add_setting('hotel_resort_accomodation_heading_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_heading_font_size',array(
		'label'	=> __('Title Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_heading_font_size',
		'type'	=> 'text'
	));

	//This is Accomodation subtitle FontSize setting
	$wp_customize->add_setting('hotel_resort_accomodation_subtitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_subtitle_font_size',array(
		'label'	=> __('Subtitle Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_subtitle_font_size',
		'type'	=> 'text'
	));

	//This is heading subtitle FontSize setting
	$wp_customize->add_setting('hotel_resort_accomodation_service_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_service_font_size',array(
		'label'	=> __('Service Heading Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_service_font_size',
		'type'	=> 'text'
	));	

	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'hotel_resort_accomodation_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_accomodation_paragraph_color', array(
		'label' => __('Content Color', 'hotel-resort'),
		'section' => 'hotel_resort_acco',
		'settings' => 'hotel_resort_accomodation_paragraph_color',
	)));

	//This is Title FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_accomodation_title_font_family',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_accomodation_title_font_family', array(
		'section'  => 'hotel_resort_acco',
		'label'    => __( 'Title Fonts','hotel-resort'),
		'type'     => 'select',
		'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_accomodation_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_title_font_size',array(
		'label'	=> __('Title Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_title_font_size',
		'type'	=> 'text'
	));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_accomodation_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_accomodation_paragraph_font_family', array(
	    'section'  => 'hotel_resort_acco',
	    'label'    => __( 'Content Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_accomodation_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_paragraph_font_size',array(
		'label'	=> __('Content Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is Button Color picker setting
	$wp_customize->add_setting( 'hotel_resort_accomodation_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_accomodation_atag_color', array(
		'label' => __('Button Color', 'hotel-resort'),
		'section' => 'hotel_resort_acco',
		'settings' => 'hotel_resort_accomodation_atag_color',
	)));

	$wp_customize->add_setting( 'hotel_resort_accomodation_atagbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_accomodation_atagbg_color', array(
		'label' => __('Button Bg Color', 'hotel-resort'),
		'section' => 'hotel_resort_acco',
		'settings' => 'hotel_resort_accomodation_atagbg_color',
	)));

	//This is Button FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_accomodation_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_accomodation_atag_font_family', array(
	    'section'  => 'hotel_resort_acco',
	    'label'    => __( 'Button Fonts','hotel-resort'),
	    'type'     => 'select',
	    'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_accomodation_atag_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_accomodation_atag_font_size',array(
		'label'	=> __('Button Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_acco',
		'setting'	=> 'hotel_resort_accomodation_atag_font_size',
		'type'	=> 'text'
	));

	//footer
	$wp_customize->add_section('hotel_resort_footer_section',array(
		'title'	=> __('Footer Setting','hotel-resort'),
		'description'	=> __('Add some text for footer like copyright etc.','hotel-resort'),
		'panel' => 'hotel_resort_panel_id'
	));

	/*Footer Background Color */
	$wp_customize->add_setting('hotel_resort_footer_background_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'hotel_resort_footer_background_color', array(
		'label'    => __('Footer Background Color', 'hotel-resort'),
		'section'  => 'hotel_resort_footer_section',
	)));

	$wp_customize->add_setting('hotel_resort_footer_widget_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'hotel_resort_footer_widget_color', array(
		'label'    => __('Widget Title Color', 'hotel-resort'),
		'section'  => 'hotel_resort_footer_section',
	)));

	$wp_customize->add_setting('hotel_resort_footer_widgetmenu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'hotel_resort_footer_widgetmenu_color', array(
		'label'    => __('Widget Menu Color', 'hotel-resort'),
		'section'  => 'hotel_resort_footer_section',
	)));
	
	$wp_customize->add_setting('hotel_resort_footer_copy',array(
		'default'	=> 'Hotel WordPress Theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('hotel_resort_footer_copy',array(
		'label'	=> __('Copyright Text','hotel-resort'),
		'section'	=> 'hotel_resort_footer_section',
		'type'		=> 'text'
	));

	//Copyright Text Alignment
	$wp_customize->add_setting('hotel_resort_copyright_text_position',array(
        'default' => 'center',
        'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_copyright_text_position',array(
        'type' => 'select',
        'label' => __('Copyright Text Alignment','hotel-resort'),
        'section' => 'hotel_resort_footer_section',
        'choices' => array(
            'left' => __('Left','hotel-resort'),
            'right' => __('Right','hotel-resort'),
            'center' => __('Center','hotel-resort'),
        ),
	) );

	//This is Title FontFamily picker setting
	$wp_customize->add_setting('hotel_resort_copyright_text_font_family',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'hotel_resort_sanitize_choices'
	));
	$wp_customize->add_control('hotel_resort_copyright_text_font_family', array(
		'section'  => 'hotel_resort_footer_section',
		'label'    => __( 'Copyright Text Fonts','hotel-resort'),
		'type'     => 'select',
		'choices'  => $hotel_resort_font_array,
	));

	$wp_customize->add_setting('hotel_resort_copyright_text_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('hotel_resort_copyright_text_font_size',array(
		'label'	=> __('Copyright Text Font Size','hotel-resort'),
		'section'	=> 'hotel_resort_footer_section',
		'setting'	=> 'hotel_resort_copyright_text_font_size',
		'type'	=> 'text'
	));

	//Copyright Background Color
	$wp_customize->add_setting('hotel_resort_copyright_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'hotel_resort_copyright_color', array(
		'label'    => __('Copyright Text Color', 'hotel-resort'),
		'section'  => 'hotel_resort_footer_section',
	)));

    $wp_customize->add_setting('hotel_resort_copyright_background_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'hotel_resort_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'hotel-resort'),
		'section'  => 'hotel_resort_footer_section',
	)));

	//Wocommerce Shop Page
	$wp_customize->add_section('hotel_resort_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','hotel-resort'),
		'panel' => 'hotel_resort_panel_id'
	));

	$wp_customize->add_setting( 'hotel_resort_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'hotel_resort_sanitize_choices',
	) );
	$wp_customize->add_control( 'hotel_resort_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'hotel-resort' ),
		'description'	=> __('How many products should be shown per Column?','hotel-resort'),
		'section'  => 'hotel_resort_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('hotel_resort_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'hotel_resort_sanitize_float',
	));	
	$wp_customize->add_control('hotel_resort_products_per_page',array(
		'label'	=> __('Product Per Page','hotel-resort'),
		'description'	=> __('How many products should be shown per page?','hotel-resort'),
		'section'	=> 'hotel_resort_woocommerce_shop_page',
		'type'		=> 'number'
	));

	//logo size
	$wp_customize->add_setting('hotel_resort_logo_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'hotel_resort_sanitize_float'
	));
	$wp_customize->add_control('hotel_resort_logo_size',array(
		'label'	=> __('Logo Size','hotel-resort'),
		'section'	=> 'title_tagline',
		'setting'	=> 'hotel_resort_logo_size',
		'type'	=> 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 200,
		),
	));

	// logo site title size 
	$wp_customize->add_setting('hotel_resort_site_title_font_size',array(
		'default'	=> 37,
		'sanitize_callback'	=> 'hotel_resort_sanitize_float'
	));
	$wp_customize->add_control('hotel_resort_site_title_font_size',array(
		'label'	=> __('Site Title Font Size','hotel-resort'),
		'section'	=> 'title_tagline',
		'setting'	=> 'hotel_resort_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'hotel_resort_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_site_title_color', array(
		'label' => __('Title Color', 'hotel-resort'),
		'section' => 'title_tagline',
		'settings' => 'hotel_resort_site_title_color',
	)));

	// logo site tagline size 
	$wp_customize->add_setting('hotel_resort_site_tagline_font_size',array(
		'default'	=> 14,
		'sanitize_callback'	=> 'hotel_resort_sanitize_float'
	));
	$wp_customize->add_control('hotel_resort_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size','hotel-resort'),
		'section'	=> 'title_tagline',
		'setting'	=> 'hotel_resort_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting('hotel_resort_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'hotel_resort_sanitize_checkbox'
    ));
    $wp_customize->add_control('hotel_resort_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','hotel-resort'),
       'section' => 'title_tagline'
    ));

	$wp_customize->add_setting( 'hotel_resort_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'hotel_resort_site_tagline_color', array(
		'label' => __('Tagline Color', 'hotel-resort'),
		'section' => 'title_tagline',
		'settings' => 'hotel_resort_site_tagline_color',
	)));
	
}
add_action( 'customize_register', 'hotel_resort_customize_register' );	

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Hotel_Resort_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Hotel_Resort_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Hotel_Resort_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Hotel Resort Pro', 'hotel-resort' ),
					'pro_text' => esc_html__( 'Update Pro', 'hotel-resort' ),
					'pro_url'  => esc_url('https://www.logicalthemes.com/themes/premium-hotel-resort-wordpress-theme/')
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'hotel-resort-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'hotel-resort-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Hotel_Resort_Customize::get_instance();