<?php
/**
 * @package Hotel Resort
 * Setup the WordPress core custom header feature.
 *
 * @uses hotel_resort_header_style()
*/
function hotel_resort_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'hotel_resort_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1355,
		'height'                 => 110,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'hotel_resort_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'hotel_resort_custom_header_setup' );

if ( ! function_exists( 'hotel_resort_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see hotel_resort_custom_header_setup().
 */
add_action( 'wp_enqueue_scripts', 'hotel_resort_header_style' );
function hotel_resort_header_style() {
	//Check if user has defined any header image.
	if ( get_header_image() ) :
	$hotel_resort_custom_css = "
        .header{
			background-image:url('".esc_url(get_header_image())."');
			background-position: center top;
		}
		.primary-navigation ul{
			background:none;
		}";
	   	wp_add_inline_style( 'hotel-resort-basic-style', $hotel_resort_custom_css );
	endif;
}
endif; // hotel_resort_header_style