<?php
/**
 * Display Header.
 * @package Hotel Resort
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
  <?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
  } else {
    do_action( 'wp_body_open' );
  }?>
  <header role="banner">
    <?php if( get_theme_mod('hotel_resort_show_topbar', false) != ''){ ?>
      <?php if( get_theme_mod( 'hotel_resort_phone','' ) != '' || get_theme_mod( 'hotel_resort_mail','' ) != '' || get_theme_mod( 'hotel_resort_location','' ) != '' || get_theme_mod( 'hotel_resort_youtube_url','' ) != '' || get_theme_mod( 'hotel_resort_facebook_url','' ) != '' || get_theme_mod( 'hotel_resort_twitter_url','' ) != '' || get_theme_mod( 'hotel_resort_rss_url','' ) != '' || get_theme_mod( 'hotel_resort_insta_url','' ) != '' || get_theme_mod( 'hotel_resort_pint_url','' ) != '' ) { ?>
        <div class="header-top">
          <a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'hotel-resort' ); ?></a>
          <div class="container">
            <div class="row">
              <div class="col-lg-8 col-md-12">
                <div class="row">
                  <?php if( get_theme_mod( 'hotel_resort_phone','' ) != '') { ?>
                    <div class="top-contact col-lg-4 col-md-3 p-2 text-lg-start text-md-start text-center">
                      <i class="fa fa-phone me-2" aria-hidden="true"></i><a href="tel:<?php echo esc_url( get_theme_mod('hotel_resort_phone','' )); ?>" class="phone py-2"><?php echo esc_html( get_theme_mod('hotel_resort_phone','' )); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('hotel_resort_phone','' )); ?></span></a>
                    </div>   
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_mail','' ) != '') { ?>
                    <div class="top-contact col-lg-4 col-md-4 p-2 text-lg-start text-md-start text-center">
                      <i class="fa fa-envelope me-2" aria-hidden="true"></i><a href="mailto:<?php echo esc_url( get_theme_mod('hotel_resort_mail','') ); ?>" class="mail py-2"><?php echo esc_html( get_theme_mod('hotel_resort_mail','') ); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('hotel_resort_mail','') ); ?></span></a>
                    </div>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_location','' ) != '') { ?>
                    <div class="top-contact col-lg-4 col-md-5 p-2 text-lg-start text-md-start text-center">
                      <i class="fa fa-map-marker me-2" aria-hidden="true"></i><p class="location py-2"><?php echo esc_html( get_theme_mod('hotel_resort_location','') ); ?></p>
                    </div>
                  <?php } ?>
                </div>
              </div>
              <div class="col-lg-4 col-md-12" >
                <div class="social-media text-lg-end text-center">
                   <?php if( get_theme_mod( 'hotel_resort_youtube_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_youtube_url','' ) ); ?>"><i class="fab fa-youtube ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Youtube','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_facebook_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_facebook_url','' ) ); ?>"><i class="fab fa-facebook-f ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Facebook','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_twitter_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_twitter_url','' ) ); ?>"><i class="fab fa-twitter ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Twitter','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_rss_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_rss_url','' ) ); ?>"><i class="fa fa-rss ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'RSS','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_insta_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_insta_url','' ) ); ?>"><i class="fab fa-instagram ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Instagram','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_pint_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_pint_url','' ) ); ?>"><i class="fab fa-pinterest-p ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Pinterest','hotel-resort' );?></span></a>
                  <?php } ?>
                  <?php if( get_theme_mod( 'hotel_resort_linkedin_url') != '') { ?>
                    <a href="<?php echo esc_url( get_theme_mod( 'hotel_resort_linkedin_url','' ) ); ?>"><i class="fab fa-linkedin-in ms-3 mt-2" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'LinkedIn','hotel-resort' );?></span></a>
                  <?php } ?>
                </div>
              </div>
            </div>
            <div class="clearfix"></div>
          </div>
        </div>
      <?php }?>
    <?php }?>
    <div class="<?php if( get_theme_mod( 'hotel_resort_sticky_header', false) != '') { ?> sticky-menubox"<?php } else { ?>close-sticky <?php } ?>">
      <div class="header w-100 h-auto">
        <div class="container">
          <div class="row">
            <div class="col-lg-3 col-md-4 col-9 position-relative">
                <div class="logo m-0 text-lg-center p-2 text-md-center text-start">
                    <div class="site-logo"><?php the_custom_logo(); ?></div>
                  <?php if( get_theme_mod('hotel_resort_site_title_tagline',true) != ''){ ?>
                    <?php $blog_info = get_bloginfo( 'name' ); ?>
                    <?php if ( ! empty( $blog_info ) ) : ?>
                      <?php if ( is_front_page() && is_home() ) : ?>
                        <h1 class="site-title p-0 m-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                      <?php else : ?>
                        <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                      <?php endif; ?>
                    <?php endif; ?>
                    <?php
                      $description = get_bloginfo( 'description', 'display' );
                      if ( $description || is_customize_preview() ) :
                    ?>
                      <p class="site-description">
                        <?php echo esc_html($description); ?>
                      </p>
                    <?php endif; ?>
                    <?php }?>
                </div>
              
            </div>
            <div class="col-lg-9 col-md-8 col-3">
              <div class="menubox">
                <?php 
                  if(has_nav_menu('primary')){ ?>
                  <div class="toggle-menu responsive-menu text-end my-2">
                    <button role="tab" class="resToggle" onclick="hotel_resort_resmenu_open()"><i class="fas fa-bars"></i><span class="screen-reader-text"><?php esc_html_e('Open Menu','hotel-resort'); ?></span></button>
                  </div>
                <?php }?>
                <div id="menu-sidebar" class="nav sidebar text-start">
                  <nav id="primary-site-navigation" class="primary-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'hotel-resort' ); ?>">
                    <?php
                      if(has_nav_menu('primary')){  
                        wp_nav_menu( array( 
                          'theme_location' => 'primary',
                          'container_class' => 'main-menu-navigation clearfix' ,
                          'menu_class' => 'clearfix',
                          'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                          'fallback_cb' => 'wp_page_menu',
                        ) );
                      } 
                    ?>
                    <a href="javascript:void(0)" class="closebtn responsive-menu" onclick="hotel_resort_resmenu_close()"><i class="fas fa-times"></i><span class="screen-reader-text"><?php esc_html_e('Close Menu','hotel-resort'); ?></span></a>
                  </nav>
                </div>
              </div>
            </div>
          </div>
          <div class="clear"></div>
        </div> 
      </div>
    </div>
  </header>