<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'cleaning_business_above_slider' ); ?>

  <?php if( get_theme_mod('cleaning_business_slider_hide_show', false) != ''){ ?> 

    <section id="slider" class=" mw-100">
       <div class="s-oly"> </div>
       <div class="container">
        <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
          <?php $cleaning_business_content_pages = array();
            for ( $count = 1; $count <= 4; $count++ ) {
              $mod = intval( get_theme_mod( 'cleaning_business_slider_page' . $count ));
              if ( 'page-none-selected' != $mod ) {
                $cleaning_business_content_pages[] = $mod;
              }
            }
            if( !empty($cleaning_business_content_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $cleaning_business_content_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
              $i = 1;
          ?>     
          <div class="carousel-inner" role="listbox">
            <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>  
                <div class="row m-0">
                  <div class="col-xl-5 col-lg-6 col-md-6 col-sm-5">           
                      <div class="sliderbg-img">
                          <?php the_post_thumbnail(); ?>                            
                      </div>   
                  </div>
                  <div class="col-xl-7 col-lg-6 col-md-6 col-sm-7 pd-0">
                    <?php
                    $cleaning_business_slider_animation = get_theme_mod('cleaning_business_slider_animation', '')
                    ?>
                      <div class="slider-content <?php echo($cleaning_business_slider_animation)?>">
                          <div class="inner_carousel">
                            <p>
                              <?php $cleaning_business_excerpt = get_the_excerpt(); echo esc_html( cleaning_business_string_limit_words( $cleaning_business_excerpt,20 ) ); ?>
                            </p>
                            <h2><?php the_title(); ?></h2>
                            <div class="sliderlist ">
                              <div class=" row m-0">
                                  <div class="col-lg-6 col-md-6 col-sm-6 pd-0">
                                    <ul>
                                      <li><i class="fa fa-check-square-o"></i> <?php echo esc_html(get_theme_mod('cleaning_business_sliderlist1')); ?></li>
                                      <li><i class="fa fa-check-square-o"></i> <?php echo esc_html(get_theme_mod('cleaning_business_sliderlist2')); ?></li>
                                    </ul>
                                  </div>
                                  <div class="col-lg-6 col-md-6 col-sm-6 pd-0">
                                    <ul>
                                      <li><i class="fa fa-check-square-o"></i> <?php echo esc_html(get_theme_mod('cleaning_business_sliderlist3')); ?></li>
                                      <li><i class="fa fa-check-square-o"></i> <?php echo esc_html(get_theme_mod('cleaning_business_sliderlist4')); ?></li>
                                    </ul>
                                  </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="read-btn">
                              <a href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e( 'Read More', 'cleaning-business' ); ?></a>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
              </div>
            <?php $i++; endwhile; 
            wp_reset_postdata();?>
          </div>


          <svg viewBox="0 0 1500 728.5">
        <defs>
            <filter id="a" x="1014.4" y="539.06" width="462.39" height="186.05" filterUnits="userSpaceOnUse">
                <feOffset dx="-5" dy="8" input="SourceAlpha"/>
                <feGaussianBlur result="blur" stdDeviation="2.5"/>
                <feFlood flood-opacity=".161"/>
                <feComposite in2="blur" operator="in"/>
                <feComposite in="SourceGraphic"/>
            </filter>
        </defs>
        <path class="svg1" transform="translate(0 115)" d="M0,644.5V-115H1V607L263.308,460.385c.1-.057,10.391-5.927,27.64-14.56,10.161-5.086,20.74-10.137,31.443-15.013,13.373-6.092,26.976-11.925,40.431-17.335a815.939,815.939,0,0,1,99.541-33.141c18.885-4.881,37.379-8.769,54.967-11.556A437.882,437.882,0,0,1,573,363.4c3.477-.1,6.95-.15,10.323-.15,8.657,0,17.148.332,25.239.987,7.719.625,15.333,1.565,22.629,2.795a234.237,234.237,0,0,1,38.981,10.016A282.1,282.1,0,0,1,703.379,391.3c10.45,5.236,20.663,10.961,30.539,16.5l.007,0c37.817,21.2,76.921,43.127,144.575,47.893,7.713.543,15.611.819,23.473.819a369.109,369.109,0,0,0,39.006-2.112c12.028-1.267,24.373-3.089,37.74-5.571,24.835-4.612,49.543-10.87,73.437-16.923l.4-.1c23.928-6.061,48.669-12.328,73.854-16.985,13.481-2.493,25.949-4.325,38.117-5.6a375.974,375.974,0,0,1,39.5-2.123,336.116,336.116,0,0,1,80.071,9.6c8.8,2.138,17.58,4.721,26.1,7.675,8.179,2.836,16.334,6.09,24.238,9.671a295.505,295.505,0,0,1,43.05,24.086,335.169,335.169,0,0,1,65.467,58.424c8.057,9.281,15.807,19.157,23.035,29.355,6.014,8.485,11.727,17.276,16.98,26.128A310.362,310.362,0,0,1,1500,604.649v39.325L0,644.5Z" data-name="Subtraction 1" />
        <g filter="url(#a)">
            <path class="svg2" transform="translate(12 5.84)" d="m1014.9 564.54s135.07-50.161 241.12-23.545c41.359 10.381 83.527 28.931 121 59 58.109 46.629 85.271 103.76 85.271 103.76s-30.471-47.18-95.271-89.761c-40.162-26.39-89.172-46.752-130-57-106.04-26.616-222.12 7.545-222.12 7.545z" data-name="Path 6"/>
        </g>
    </svg>
        </div>
        <?php else : ?>


 
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-caret-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous', 'cleaning-business' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-caret-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next', 'cleaning-business' );?></span>
        </a>
      <!-- </div>    -->
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'cleaning_business_below_slider' ); ?>

  <section id="service-section" >
      <div class="container">
        <?php if(get_theme_mod('cleaning_business_btn_serviceheading') != ''){ ?>
          <div class="service-head">
            <h4>
              <?php echo esc_html(get_theme_mod('cleaning_business_btn_serviceheading')); ?>
              <div class="heading-brd"></div>
            </h4>
          </div>
        <?php }?>

        <div class="row mr-0">
          <?php $cleaning_business_catData =  get_theme_mod('cleaning_business_service_category');
          if($cleaning_business_catData){
            $page_query = new WP_Query(array( 'category_name' => esc_html($cleaning_business_catData,'cleaning-business')));

            while( $page_query->have_posts() ) : $page_query->the_post();

            ?>  
              
              <div class="col-lg-4 col-md-6 col-sm-6  serbx ">
                <div class="service-box text-center ">
                  <div class="service-img">
                    <?php the_post_thumbnail(); ?>
                    <div class="ser_oly"></div>
                      <div class="service-content">
                          
                          <a href="<?php echo esc_url( get_permalink() );?>">
                              <div class="title"><?php the_title();?></div>
                          </a>
                      </div>
                    
                      <div class="clearfix"></div>
                  </div>
                  
                </div>
                <div class="clearfix"></div>
              </div>
              <!-- </div> -->
            <?php endwhile; 
            wp_reset_postdata();
          } ?>
        </div>
      </div>
      <div class="clearfix"></div>
    </section>

  <?php if( get_theme_mod('cleaning_business_service_category') != ''){ ?>

    <section id="aboutus-section">
      <div class="container">
        <?php if(get_theme_mod('cleaning_business_aboutustitle') != ''){ ?>
          <div class="service-head">
            <h4>
              <?php echo esc_html(get_theme_mod('cleaning_business_aboutustitle')); ?>
              <div class="heading-brd"></div>
            </h4>
          </div>
        <?php }?>
        <div class="row m-0">
          <div class="col-lg-5 col-md-12 col-sm-12">
            <div class="yearofex">
              <h3 class="yearofexno"><?php echo esc_html(get_theme_mod('cleaning_business_aboutusyearofexno')); ?></h3>
              <p class="yearofextext"><?php echo esc_html(get_theme_mod('cleaning_business_aboutusyearofextext')); ?></p>
            </div>

            <div class="aboutus-content">
              <p class="description"><?php echo esc_html(get_theme_mod('cleaning_business_aboutusdescription')); ?></p>
              <ul>
                <li><?php echo esc_html(get_theme_mod('cleaning_business_aboutuslist1')); ?></li>
                <li><?php echo esc_html(get_theme_mod('cleaning_business_aboutuslist2')); ?></li>
              </ul>
              <div class="aboutus-btn">
                <?php if(get_theme_mod('cleaning_business_aboutusbtntext') != '') {?>
                  <a href="<?php echo esc_html(get_theme_mod('cleaning_business_aboutusbtnlinks')); ?>"><?php echo esc_html(get_theme_mod('cleaning_business_aboutusbtntext')); ?></a>
                <?php }?>
              </div>
            </div>
          </div> 

          <div class="col-lg-7 col-md-12 col-sm-12">
            <div class="ba-card">
              <div class="horizontal-ba">
                <!-- The before image is first -->
                  <?php 
                    $cleaning_business_aboutus_image1 = get_theme_mod('cleaning_business_aboutus_image1');

                    if(!empty($cleaning_business_aboutus_image1)){
                      echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($cleaning_business_aboutus_image1).'" class="img-responsive secondry-bg-img" />';
                    }else{
                      echo '<img alt="cleaning_business_aboutus_image1" src="'.get_template_directory_uri().'/assets/images/abt3.jpg" class="img-responsive" />';
                    }
                  ?>
                  <?php 
                    $cleaning_business_aboutus_image2 = get_theme_mod('cleaning_business_aboutus_image2');

                    if(!empty($cleaning_business_aboutus_image2)){
                      echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($cleaning_business_aboutus_image2).'" class="img-responsive secondry-bg-img" />';
                    }else{
                      echo '<img alt="cleaning_business_aboutus_image2" src="'.get_template_directory_uri().'/assets/images/abt2.jpg" class="img-responsive" />';
                    }
                  ?>
              </div>
            </div>
            <div class="about-circle1"></div>
            <div class="about-circle2"></div>
            <div class="about-circle3"></div>
          </div>
        </div>
      </div>
    </section>

  <?php }?>
  <?php do_action( 'cleaning_business_below_best_sellers' ); ?>

  <!-- <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div> -->
</main>
<?php get_footer(); ?>