<?php
/**
 * Cleaning Business Theme Customizer
 *
 * @package Cleaning Business
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Cleaning_Business_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Cleaning_Business_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Cleaning_Business_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Cleaning Business Pro', 'cleaning-business' ),
					'pro_text' => esc_html__( 'Go Pro', 'cleaning-business' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/product/themes/cleaning-wp-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'cleaning-business-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'cleaning-business-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Cleaning_Business_Customize::get_instance();

function cleaning_business_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'cleaning_business_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'cleaning-business' ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'cleaning_business_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'cleaning-business' ),
		'priority'   => null,
		'panel' => 'cleaning_business_panel_id'
	) );

	//Select width layout
    $wp_customize->add_setting('cleaning_business_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control('cleaning_business_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','cleaning-business'),
        'section' => 'cleaning_business_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','cleaning-business'),
            'Contained Width' => esc_html__('Contained Width','cleaning-business'),
            'Boxed Width' => esc_html__('Boxed Width','cleaning-business'),
        ),
	) );

	$wp_customize->add_setting('cleaning_business_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control('cleaning_business_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'cleaning-business' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'cleaning-business' ),
        'section' => 'cleaning_business_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','cleaning-business'),
            'Three Columns' => esc_html__('Three Columns','cleaning-business'),
            'Four Columns' => esc_html__('Four Columns','cleaning-business'),
            'Right Sidebar' => esc_html__('Right Sidebar','cleaning-business'),
            'Left Sidebar' => esc_html__('Left Sidebar','cleaning-business'),
            'Grid Layout' => esc_html__('Grid Layout','cleaning-business')
        ),
	));

	$wp_customize->add_setting('cleaning_business_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control('cleaning_business_dropdown_anim', array(
		'section'  => 'cleaning_business_left_right',
		'label'    => __( 'Submenu Dropdown Effect','cleaning-business'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'cleaning-business'),
			'zoomIn' => __('zoomIn', 'cleaning-business'),
			'flip-up' => __('flip-up', 'cleaning-business'),
			'none' => __('none', 'cleaning-business')
		)
	));

	$cleaning_business_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'cleaning_business_typography', array(
    	'title'      => __( 'Typography', 'cleaning-business' ),
		'priority'   => null,
		'panel' => 'cleaning_business_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'cleaning_business_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_paragraph_color', array(
		'label' => __('Paragraph Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_paragraph_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'Paragraph Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	$wp_customize->add_setting('cleaning_business_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'cleaning_business_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_atag_color', array(
		'label' => __('"a" Tag Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_atag_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( '"a" Tag Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'cleaning_business_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_li_color', array(
		'label' => __('"li" Tag Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_li_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( '"li" Tag Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h1_color', array(
		'label' => __('H1 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h1_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H1 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('cleaning_business_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h1_font_size',array(
		'label'	=> __('H1 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h2_color', array(
		'label' => __('H2 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h2_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H2 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('cleaning_business_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h2_font_size',array(
		'label'	=> __('H2 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h3_color', array(
		'label' => __('H3 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h3_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H3 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('cleaning_business_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h3_font_size',array(
		'label'	=> __('H3 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h4_color', array(
		'label' => __('H4 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h4_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H4 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('cleaning_business_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h4_font_size',array(
		'label'	=> __('H4 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h5_color', array(
		'label' => __('H5 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h5_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H5 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('cleaning_business_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h5_font_size',array(
		'label'	=> __('H5 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'cleaning_business_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_h6_color', array(
		'label' => __('H6 Color', 'cleaning-business'),
		'section' => 'cleaning_business_typography',
		'settings' => 'cleaning_business_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('cleaning_business_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control(
	    'cleaning_business_h6_font_family', array(
	    'section'  => 'cleaning_business_typography',
	    'label'    => __( 'H6 Fonts','cleaning-business'),
	    'type'     => 'select',
	    'choices'  => $cleaning_business_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('cleaning_business_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_h6_font_size',array(
		'label'	=> __('H6 Font Size','cleaning-business'),
		'section'	=> 'cleaning_business_typography',
		'setting'	=> 'cleaning_business_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('cleaning_business_topbar',array(
		'title'	=> esc_html__('Topbar','cleaning-business'),
		'priority'	=> null,
		'panel' => 'cleaning_business_panel_id',
	));

	$wp_customize->add_setting( 'cleaning_business_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'cleaning_business_sanitize_checkbox'
    ) );
    $wp_customize->add_control('cleaning_business_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'cleaning-business' ),
        'label' => __( 'Sticky Header','cleaning-business' ),
        'section' => 'cleaning_business_topbar'
    ));

	$wp_customize->add_setting('cleaning_business_head_time',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_head_time',array(
		'label'	=> __('Add Time','cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_phoneno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_phoneno',array(
		'label'	=> __('Add Phone Number','cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('cleaning_business_mail',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_mail',array(
		'label'	=> __('Add Mail','cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'cleaning_business_topheadbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_topheadbg_color', array(
		'label' => __('Top Header BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_topheadbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_topheadtext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_topheadtext_color', array(
		'label' => __('Top Head Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_topheadtext_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_topheadicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_topheadicon_color', array(
		'label' => __('Top Head Icon Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_topheadicon_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_topheadiconbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_topheadiconbg_color', array(
		'label' => __('Top Head Icon BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_topheadiconbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headermenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headermenu_color', array(
		'label' => __('Menu Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headermenu_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headeractivemenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headeractivemenuhover_color', array(
		'label' => __('Active Menu & Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headeractivemenuhover_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headeractivemenuhoverbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headeractivemenuhoverbg_color', array(
		'label' => __('Active Menu & Hover BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headeractivemenuhoverbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headersubmenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headersubmenu_color', array(
		'label' => __('Submenu Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headersubmenu_color',
	)));
	
	$wp_customize->add_setting( 'cleaning_business_headersubmenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headersubmenuhover_color', array(
		'label' => __('Submenu Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headersubmenuhover_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headersubmenubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headersubmenubg_color', array(
		'label' => __('Submenu BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headersubmenubg_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_headersubmenubghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_headersubmenubghover_color', array(
		'label' => __('Submenu BG Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_topbar',
		'settings' => 'cleaning_business_headersubmenubghover_color',
	)));


	//home page slider
	$wp_customize->add_section( 'cleaning_business_slidersettings' , array(
    	'title'      => esc_html__( 'Slider Settings', 'cleaning-business' ),
		'priority'   => null,
		'panel' => 'cleaning_business_panel_id'
	) );

	$wp_customize->add_setting('cleaning_business_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'cleaning_business_sanitize_checkbox'
	));
	$wp_customize->add_control('cleaning_business_slider_hide_show',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'cleaning-business' ),
	   'label' => esc_html__('Show / Hide slider','cleaning-business'),
	   'section' => 'cleaning_business_slidersettings',
	));

	//This is onload transaction effect
	$wp_customize->add_setting('cleaning_business_slider_animation',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'cleaning_business_sanitize_choices'
	));
	$wp_customize->add_control('cleaning_business_slider_animation', array(
		'section'  => 'cleaning_business_slidersettings',
		'label'    => __( 'Onload Transaction Effect','cleaning-business'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft' => __('bounceInLeft', 'cleaning-business'),
			'bounceInRight' => __('bounceInRight', 'cleaning-business'),
			'bounceInUp' => __('bounceInUp', 'cleaning-business'),
			'bounceInDown' => __('bounceInDown', 'cleaning-business'),
			'zoomIn' => __('zoomIn', 'cleaning-business'),
			'zoomOut' => __('zoomOut', 'cleaning-business'),
			'fadeInLeft' => __('fadeInLeft', 'cleaning-business'),
			'fadeInRight' => __('fadeInRight', 'cleaning-business'),
			'fadeInUp' => __('fadeInUp', 'cleaning-business'),
			'fadeInDown' => __('fadeInDown', 'cleaning-business'),
			'flip-up' => __('flip-up', 'cleaning-business'),
			'none' => __('none', 'cleaning-business')
		)
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'cleaning_business_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'cleaning_business_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'cleaning_business_slider_page' . $count, array(
			'label'    => esc_html__( 'Select Slider Page', 'cleaning-business' ),
			'section'  => 'cleaning_business_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('cleaning_business_sliderlist1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_sliderlist1',array(
		'label'	=> __('List 1','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'text'
	));
	
	$wp_customize->add_setting('cleaning_business_sliderlist2',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_sliderlist2',array(
		'label'	=> __('List 2','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_sliderlist3',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_sliderlist3',array(
		'label'	=> __('List 3','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_sliderlist4',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_sliderlist4',array(
		'label'	=> __('List 4','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_slider_subtitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_slider_subtitle_font_size',array(
		'label'	=> __('Subtitle Font Size','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('cleaning_business_slider_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_slider_title_font_size',array(
		'label'	=> __('Title Font Size','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('cleaning_business_slider_list_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_slider_list_font_size',array(
		'label'	=> __('List Font Size','cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'cleaning_businessslider_subtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_subtitle_color', array(
		'label' => __('Subtitle Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_subtitle_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_title_color', array(
		'label' => __('Title Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_title_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_list_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_list_color', array(
		'label' => __('Lists Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_list_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_btntext_color', array(
		'label' => __('Button Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_btntext_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_btnbg_color', array(
		'label' => __('Button BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_btnbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_btntexthover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_btntexthover_color', array(
		'label' => __('Button Text Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_btntexthover_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_btnbghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_btnbghover_color', array(
		'label' => __('Button BG Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_btnbghover_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_btnbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_btnbrd_color', array(
		'label' => __('Button Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_btnbrd_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_bg1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_bg1_color', array(
		'label' => __('BG 1 Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_bg1_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_bg2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_bg2_color', array(
		'label' => __('BG 2 Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_bg2_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_bg3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_bg3_color', array(
		'label' => __('BG 3 Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_bg3_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessslider_bg3border_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessslider_bg3border_color', array(
		'label' => __('BG 3 Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_slidersettings',
		'settings' => 'cleaning_businessslider_bg3border_color',
	)));

	// Services Settings
	$wp_customize->add_section('cleaning_business_services_section',array(
		'title'	=> __('Services Settings','cleaning-business'),
		'panel' => 'cleaning_business_panel_id',
	));

	$wp_customize->add_setting('cleaning_business_btn_serviceheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_btn_serviceheading',array(
		'label'	=> __('Heading','cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_service_heading_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_service_heading_font_size',array(
		'label'	=> __('Heading Font Size','cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'type'	 => 'number'
	));
	

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('cleaning_business_service_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'cleaning_business_sanitize_choices',
	));
	$wp_customize->add_control('cleaning_business_service_category',array(
		'type'    => 'select',
		'choices' => $cat_post,
		'label' => esc_html__('Select Category To Display Post','cleaning-business'),
		'section' => 'cleaning_business_services_section',
	));

	$wp_customize->add_setting('cleaning_business_service_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_service_title_font_size',array(
		'label'	=> __('Title Font Size','cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'cleaning_businessservices_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessservices_heading_color', array(
		'label' => __('Heading Color', 'cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'settings' => 'cleaning_businessservices_heading_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessservices_headingbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessservices_headingbrd_color', array(
		'label' => __('Heading Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'settings' => 'cleaning_businessservices_headingbrd_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessservices_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessservices_title_color', array(
		'label' => __('Title Color', 'cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'settings' => 'cleaning_businessservices_title_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessservices_titlehrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessservices_titlehrv_color', array(
		'label' => __('Title Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_services_section',
		'settings' => 'cleaning_businessservices_titlehrv_color',
	)));

	// aboutus Section
	$wp_customize->add_section('cleaning_business_aboutus_section',array(
		'title'	=> __('AboutUs Settings','cleaning-business'),
		'panel' => 'cleaning_business_panel_id',
	));

	$wp_customize->add_setting('cleaning_business_aboutustitle',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutustitle',array(
		'label'	=> __('Title','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutustitle_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutustitle_font_size',array(
		'label'	=> __('Font Size','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting('cleaning_business_aboutusyearofexno',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutusyearofexno',array(
		'label'	=> __('Years Of Experience Number','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutusyearofextext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutusyearofextext',array(
		'label'	=> __('Years Of Experience Text','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutusdescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutusdescription',array(
		'label'	=> __('Description','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutuslist1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutuslist1',array(
		'label'	=> __('List 1','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutuslist2',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutuslist2',array(
		'label'	=> __('List 2','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutusbtntext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutusbtntext',array(
		'label'	=> __('Button Text','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('cleaning_business_aboutusbtnlinks',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_aboutusbtnlinks',array(
		'label'	=> __('Button Link','cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting(
    	'cleaning_business_aboutus_image1',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'cleaning_business_aboutus_image1',
	        array(
			    'label'   		=> __('Image 1','cleaning-business'),
				'description'   		=> __('Image size 417*546','cleaning-business'),
	            'section' => 'cleaning_business_aboutus_section',
	            'settings' => 'cleaning_business_aboutus_image1',
	        )
	    )
	);

	$wp_customize->add_setting(
    	'cleaning_business_aboutus_image2',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'cleaning_business_aboutus_image2',
	        array(
			    'label'   		=> __('Image 2','cleaning-business'),
				'description'   		=> __('Image size 417*546','cleaning-business'),
	            'section' => 'cleaning_business_aboutus_section',
	            'settings' => 'cleaning_business_aboutus_image2',
	        )
	    )
	);

	$wp_customize->add_setting( 'cleaning_businessaboutus_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_title_color', array(
		'label' => __('Title Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_title_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_titleborder_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_titleborder_color', array(
		'label' => __('Title Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_titleborder_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_yearofexpno_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_yearofexpno_color', array(
		'label' => __('Years Of Experience Number Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_yearofexpno_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_yearofexptext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_yearofexptext_color', array(
		'label' => __('Years Of Experience Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_yearofexptext_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_description_color', array(
		'label' => __('Description Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_description_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_list_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_list_color', array(
		'label' => __('List Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_list_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_btntext_color', array(
		'label' => __('Button Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_btntext_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_btnbg_color', array(
		'label' => __('Button BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_btnbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_btntexthover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_btntexthover_color', array(
		'label' => __('Button Text Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_btntexthover_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_btnbghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_btnbghover_color', array(
		'label' => __('Button BG Hover Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_btnbghover_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_btnbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_btnbrd_color', array(
		'label' => __('Button Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_btnbrd_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_imageborder_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_imageborder_color', array(
		'label' => __('Image Border Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_imageborder_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_imagearrow_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_imagearrow_color', array(
		'label' => __('Image Arrow Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_imagearrow_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_imagebtntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_imagebtntext_color', array(
		'label' => __('Image Button Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_imagebtntext_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessaboutus_imagebtnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessaboutus_imagebtnbg_color', array(
		'label' => __('Image Button BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_aboutus_section',
		'settings' => 'cleaning_businessaboutus_imagebtnbg_color',
	)));

	//footer
	$wp_customize->add_section('cleaning_business_footer_section',array(
		'title'	=> esc_html__('Footer Settings','cleaning-business'),
		'panel' => 'cleaning_business_panel_id'
	));
		
	$wp_customize->add_setting('cleaning_business_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('cleaning_business_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','cleaning-business'),
		'section'	=> 'cleaning_business_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('cleaning_business_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('cleaning_business_footer_copy_font_size',array(
		'label'	=> __('Copyright Font Size','cleaning-business'),
		'section' => 'cleaning_business_footer_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'cleaning_businessfooter_copyrighttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessfooter_copyrighttext_color', array(
		'label' => __('Copyright Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_footer_section',
		'settings' => 'cleaning_businessfooter_copyrighttext_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessfooter_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessfooter_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_footer_section',
		'settings' => 'cleaning_businessfooter_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessfooter_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessfooter_bg_color', array(
		'label' => __('BG Color', 'cleaning-business'),
		'section' => 'cleaning_business_footer_section',
		'settings' => 'cleaning_businessfooter_bg_color',
	)));

	$wp_customize->add_setting( 'cleaning_businessfooter_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_businessfooter_text_color', array(
		'label' => __('Text Color', 'cleaning-business'),
		'section' => 'cleaning_business_footer_section',
		'settings' => 'cleaning_businessfooter_text_color',
	)));

	//Wocommerce Shop Page
	$wp_customize->add_section('cleaning_business_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','cleaning-business'),
		'panel' => 'cleaning_business_panel_id'
	));

	$wp_customize->add_setting( 'cleaning_business_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'cleaning_business_sanitize_choices',
	) );
	$wp_customize->add_control( 'cleaning_business_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'cleaning-business' ),
		'description'	=> __('How many products should be shown per Column?','cleaning-business'),
		'section'  => 'cleaning_business_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('cleaning_business_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'cleaning_business_sanitize_float',
	));	
	$wp_customize->add_control('cleaning_business_products_per_page',array(
		'label'	=> __('Product Per Page','cleaning-business'),
		'description'	=> __('How many products should be shown per page?','cleaning-business'),
		'section'	=> 'cleaning_business_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'cleaning_business_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'cleaning-business'),
		'section' => 'cleaning_business_woocommerce_shop_page',
		'settings' => 'cleaning_business_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'cleaning_business_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'cleaning-business'),
		'section' => 'cleaning_business_woocommerce_shop_page',
		'settings' => 'cleaning_business_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'cleaning_business_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_product_sale_color', array(
		'label' => __('Sale Badge Color', 'cleaning-business'),
		'section' => 'cleaning_business_woocommerce_shop_page',
		'settings' => 'cleaning_business_product_sale_color',
	)));

	// site logo size
	$wp_customize->add_setting('cleaning_business_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'cleaning_business_sanitize_float'
	));
	$wp_customize->add_control('cleaning_business_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','cleaning-business'),
		'section' => 'title_tagline'
	));

	// logo site title
	$wp_customize->add_setting('cleaning_business_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'cleaning_business_sanitize_checkbox'
    ));
    $wp_customize->add_control('cleaning_business_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','cleaning-business'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'cleaning_business_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_site_title_color', array(
		'label' => __('Site Title Color', 'cleaning-business'),
		'section' => 'title_tagline',
		'settings' => 'cleaning_business_site_title_color',
	)));

    $wp_customize->add_setting( 'cleaning_business_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'cleaning_business_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'cleaning-business'),
		'section' => 'title_tagline',
		'settings' => 'cleaning_business_site_tagline_color',
	)));
}
add_action( 'customize_register', 'cleaning_business_customize_register' );