<?php
/**
 * Display Header.
 * @package Cleaning Business
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<header role="banner" class="banner">
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'cleaning-business' ); ?></a>
		<div id="header">
			<div class="header-box">
				<div class="top-head ">
					<div class="container">	
						<div class=" row">
							<div class="col-lg-3 col-md-12 col-sm-12">
								<div class="logobx">
									<!-- <div class="logobxinn"></div> -->
									<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
								</div>
							</div>
							<div class="col-lg-3 col-md-4 col-sm-12 txt">
								<?php if(get_theme_mod('cleaning_business_head_time') != ''){ ?>
									<p><i class="fas fa-history"></i>
									<?php echo esc_html(get_theme_mod('cleaning_business_head_time')); ?></p>
								<?php }?>						
							</div>
							<div class="col-lg-3 col-md-4 col-sm-12 txt">
								<?php if(get_theme_mod('cleaning_business_phoneno') != ''){ ?>
									<a href="tel:<?php echo esc_attr(get_theme_mod('cleaning_business_phoneno')); ?>"><i class="fas fa-phone"></i>
									<?php echo esc_html(get_theme_mod('cleaning_business_phoneno')); ?></a>
								<?php }?>	
							</div>
							<div class="col-lg-3 col-md-4 col-sm-12 txt">
								<div class="phbox">
									<?php if(get_theme_mod('cleaning_business_mail') != ''){ ?>
										<a href="mailto:<?php echo esc_attr(get_theme_mod('cleaning_business_mail')); ?>"><i class="fas fa-envelope me-2"></i>
										<?php echo esc_html(get_theme_mod('cleaning_business_mail')); ?></a>
									<?php }?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="bottom-head">
					<div class="container">	
						<div class="menu-section text-lg-center">
							<div class="<?php if( get_theme_mod( 'cleaning_business_sticky_header', false) != '') { ?>sticky-menubox<?php } else { ?>close-sticky <?php } ?>">
								<?php get_template_part( 'template-parts/navigation/site', 'nav' ); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<?php if(is_singular()) {?>
		<div class="inner-head">
			<img src="<?php if ( get_header_image() ){ echo esc_url(get_header_image()); } else { echo esc_url(get_template_directory_uri()) ?>/assets/images/head-bg.png<?php }?>" class="head-img" alt="<?php echo esc_attr__('Header Background Image', 'cleaning-business'); ?>">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6 align-self-center">
						<div class="header-content">
							<h1><?php single_post_title(); ?></h1>
							<div class="lt-breadcrumbs">
								<?php cleaning_business_breadcrumb(); ?>
							</div>
						</div>
					</div>
					<?php if(has_post_thumbnail()){?>
						<div class="col-lg-6 col-md-6 align-self-end">
							
						</div>
					<?php }?>
				</div>
				
			</div>
		</div>
	<?php }?>