<?php
/**
 * Bodyart Tattoo Designer Theme Customizer
 *
 * @package Bodyart Tattoo Designer
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Bodyart_Tattoo_Designer_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Bodyart_Tattoo_Designer_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Bodyart_Tattoo_Designer_Customize_Section_Pro(
				$manager,
				'example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Bodyart Tattoo Designer Pro', 'bodyart-tattoo-designer' ),
					'description' => __( 'Buy now and enjoy exclusive discounts!', 'bodyart-tattoo-designer' ),
					'pro_text' => esc_html__( 'Go Pro', 'bodyart-tattoo-designer' ),
					'pro_url'  => esc_url( 'https://www.logicalthemes.com/products/premium-tattoo-designer-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'bodyart-tattoo-designer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'bodyart-tattoo-designer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Bodyart_Tattoo_Designer_Customize::get_instance();

function bodyart_tattoo_designer_customize_register( $wp_customize ) {	

	//add home page setting pannel
	$wp_customize->add_panel( 'bodyart_tattoo_designer_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => esc_html__( 'LT Settings', 'bodyart-tattoo-designer' ),
	) );

	//Layout Setting
	$wp_customize->add_section( 'bodyart_tattoo_designer_left_right' , array(
    	'title'      => esc_html__( 'General Settings', 'bodyart-tattoo-designer' ),
		'priority'   => null,
		'panel' => 'bodyart_tattoo_designer_panel_id'
	) );

	//Select width layout
    $wp_customize->add_setting('bodyart_tattoo_designer_width_options',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_width_options',array(
        'type' => 'radio',
        'label' => __('Select Width Layout','bodyart-tattoo-designer'),
        'section' => 'bodyart_tattoo_designer_left_right',
        'choices' => array(
        	'Full Width' => esc_html__('Full Width','bodyart-tattoo-designer'),
            'Contained Width' => esc_html__('Contained Width','bodyart-tattoo-designer'),
            'Boxed Width' => esc_html__('Boxed Width','bodyart-tattoo-designer'),
        ),
	) );

	$wp_customize->add_setting('bodyart_tattoo_designer_theme_options',array(
        'default' => 'One Column',
        'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_theme_options',array(
        'type' => 'radio',
        'description' => __( 'Choose sidebar between different options', 'bodyart-tattoo-designer' ),
        'label' => esc_html__( 'Post Sidebar Layout.', 'bodyart-tattoo-designer' ),
        'section' => 'bodyart_tattoo_designer_left_right',
        'choices' => array(
            'One Column' => esc_html__('One Column ','bodyart-tattoo-designer'),
            'Three Columns' => esc_html__('Three Columns','bodyart-tattoo-designer'),
            'Four Columns' => esc_html__('Four Columns','bodyart-tattoo-designer'),
            'Right Sidebar' => esc_html__('Right Sidebar','bodyart-tattoo-designer'),
            'Left Sidebar' => esc_html__('Left Sidebar','bodyart-tattoo-designer'),
            'Grid Layout' => esc_html__('Grid Layout','bodyart-tattoo-designer')
        ),
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_dropdown_anim',array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_dropdown_anim', array(
		'section'  => 'bodyart_tattoo_designer_left_right',
		'label'    => __( 'Submenu Dropdown Effect','bodyart-tattoo-designer'),
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp' => __('bounceInUp', 'bodyart-tattoo-designer'),
			'zoomIn' => __('zoomIn', 'bodyart-tattoo-designer'),
			'flip-up' => __('flip-up', 'bodyart-tattoo-designer'),
			'none' => __('none', 'bodyart-tattoo-designer')
		)
	));

	$bodyart_tattoo_designer_font_array = array(
        '' =>'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' =>'Acme', 
        'Anton' => 'Anton', 
        'Architects Daughter' =>'Architects Daughter',
        'Arimo' => 'Arimo', 
        'Arsenal' =>'Arsenal',
        'Arvo' =>'Arvo',
        'Alegreya' =>'Alegreya',
        'Alfa Slab One' =>'Alfa Slab One',
        'Averia Serif Libre' =>'Averia Serif Libre', 
        'Bangers' =>'Bangers', 
        'Boogaloo' =>'Boogaloo', 
        'Bad Script' =>'Bad Script',
        'Bitter' =>'Bitter', 
        'Bree Serif' =>'Bree Serif', 
        'BenchNine' =>'BenchNine',
        'Cabin' =>'Cabin',
        'Cardo' =>'Cardo', 
        'Courgette' =>'Courgette', 
        'Cherry Swash' =>'Cherry Swash',
        'Cormorant Garamond' =>'Cormorant Garamond', 
        'Crimson Text' =>'Crimson Text',
        'Cuprum' =>'Cuprum', 
        'Cookie' =>'Cookie',
        'Chewy' =>'Chewy',
        'Days One' =>'Days One',
        'Dosis' =>'Dosis',
        'Droid Sans' =>'Droid Sans', 
        'Economica' =>'Economica', 
        'Fredoka One' =>'Fredoka One',
        'Fjalla One' =>'Fjalla One',
        'Francois One' =>'Francois One', 
        'Frank Ruhl Libre' => 'Frank Ruhl Libre', 
        'Gloria Hallelujah' =>'Gloria Hallelujah',
        'Great Vibes' =>'Great Vibes', 
        'Handlee' =>'Handlee', 
        'Hammersmith One' =>'Hammersmith One',
        'Inconsolata' =>'Inconsolata',
        'Indie Flower' =>'Indie Flower', 
        'IM Fell English SC' =>'IM Fell English SC',
        'Julius Sans One' =>'Julius Sans One',
        'Josefin Slab' =>'Josefin Slab',
        'Josefin Sans' =>'Josefin Sans',
        'Kanit' =>'Kanit',
        'Lobster' =>'Lobster',
        'Lato' => 'Lato',
        'Lora' =>'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather',
        'Monda' =>'Monda',
        'Montserrat' =>'Montserrat',
        'Muli' =>'Muli',
        'Marck Script' =>'Marck Script',
        'Noto Serif' =>'Noto Serif',
        'Open Sans' =>'Open Sans',
        'Overpass' => 'Overpass', 
        'Overpass Mono' =>'Overpass Mono',
        'Oxygen' =>'Oxygen',
        'Orbitron' =>'Orbitron',
        'Patua One' =>'Patua One',
        'Pacifico' =>'Pacifico',
        'Padauk' =>'Padauk',
        'Playball' =>'Playball',
        'Playfair Display' =>'Playfair Display',
        'PT Sans' =>'PT Sans',
        'Philosopher' =>'Philosopher',
        'Permanent Marker' =>'Permanent Marker',
        'Poiret One' =>'Poiret One',
        'Quicksand' =>'Quicksand',
        'Quattrocento Sans' =>'Quattrocento Sans',
        'Raleway' =>'Raleway',
        'Rubik' =>'Rubik',
        'Rokkitt' =>'Rokkitt',
        'Russo One' => 'Russo One', 
        'Righteous' =>'Righteous', 
        'Slabo' =>'Slabo', 
        'Source Sans Pro' =>'Source Sans Pro',
        'Shadows Into Light Two' =>'Shadows Into Light Two',
        'Shadows Into Light' =>  'Shadows Into Light',
        'Sacramento' =>'Sacramento',
        'Shrikhand' =>'Shrikhand',
        'Tangerine' => 'Tangerine',
        'Ubuntu' =>'Ubuntu',
        'VT323' =>'VT323',
        'Varela Round' =>'Varela Round',
        'Vampiro One' =>'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' =>'Volkhov',
        'Yanone Kaffeesatz' =>'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'bodyart_tattoo_designer_typography', array(
    	'title'      => __( 'Typography', 'bodyart-tattoo-designer' ),
		'priority'   => null,
		'panel' => 'bodyart_tattoo_designer_panel_id'
	) );
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_paragraph_color', array(
		'label' => __('Paragraph Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_paragraph_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'Paragraph Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_atag_color', array(
		'label' => __('"a" Tag Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_atag_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( '"a" Tag Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_li_color', array(
		'label' => __('"li" Tag Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_li_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( '"li" Tag Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h1_color', array(
		'label' => __('H1 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h1_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H1 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h1_font_size',array(
		'label'	=> __('H1 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h2_color', array(
		'label' => __('H2 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h2_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H2 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h2_font_size',array(
		'label'	=> __('H2 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h3_color', array(
		'label' => __('H3 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h3_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H3 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h3_font_size',array(
		'label'	=> __('H3 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h4_color', array(
		'label' => __('H4 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h4_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H4 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h4_font_size',array(
		'label'	=> __('H4 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h5_color', array(
		'label' => __('H5 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h5_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H5 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h5_font_size',array(
		'label'	=> __('H5 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'bodyart_tattoo_designer_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_h6_color', array(
		'label' => __('H6 Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_typography',
		'settings' => 'bodyart_tattoo_designer_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices'
	));
	$wp_customize->add_control(
	    'bodyart_tattoo_designer_h6_font_family', array(
	    'section'  => 'bodyart_tattoo_designer_typography',
	    'label'    => __( 'H6 Fonts','bodyart-tattoo-designer'),
	    'type'     => 'select',
	    'choices'  => $bodyart_tattoo_designer_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('bodyart_tattoo_designer_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_h6_font_size',array(
		'label'	=> __('H6 Font Size','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_typography',
		'setting'	=> 'bodyart_tattoo_designer_h6_font_size',
		'type'	=> 'text'
	));

	//Topbar section
	$wp_customize->add_section('bodyart_tattoo_designer_topbar',array(
		'title'	=> esc_html__('Topbar','bodyart-tattoo-designer'),
		'priority'	=> null,
		'panel' => 'bodyart_tattoo_designer_panel_id',
	));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_sticky_header',array(
		'default'	=> false,
      	'sanitize_callback'	=> 'bodyart_tattoo_designer_sanitize_checkbox'
    ) );
    $wp_customize->add_control('bodyart_tattoo_designer_sticky_header',array(
    	'type' => 'checkbox',
    	'description' => __( 'Click on the checkbox to enable sticky header.', 'bodyart-tattoo-designer' ),
        'label' => __( 'Sticky Header','bodyart-tattoo-designer' ),
        'section' => 'bodyart_tattoo_designer_topbar'
    ));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_topheadbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_topheadbg_color', array(
		'label' => __('Header BG Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_topheadbg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headermenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headermenu_color', array(
		'label' => __('Menu Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headermenu_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headeractivemenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headeractivemenuhover_color', array(
		'label' => __('Active Menu & Hover Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headeractivemenuhover_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headersubmenuicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headersubmenuicon_color', array(
		'label' => __('Submenu Icon Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headersubmenuicon_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headersubmenu_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headersubmenu_color', array(
		'label' => __('Submenu Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headersubmenu_color',
	)));
	
	$wp_customize->add_setting( 'bodyart_tattoo_designer_headersubmenuhover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headersubmenuhover_color', array(
		'label' => __('Submenu Hover Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headersubmenuhover_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headersubmenubg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headersubmenubg_color', array(
		'label' => __('Submenu BG Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headersubmenubg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_headersubmenubghover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_headersubmenubghover_color', array(
		'label' => __('Submenu BG Hover Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_topbar',
		'settings' => 'bodyart_tattoo_designer_headersubmenubghover_color',
	)));


	//home page slider
	$wp_customize->add_section( 'bodyart_tattoo_designer_slidersettings' , array(
    	'title'      => esc_html__( 'Slider Settings', 'bodyart-tattoo-designer' ),
		'priority'   => null,
		'panel' => 'bodyart_tattoo_designer_panel_id'
	) );

	$wp_customize->add_setting('bodyart_tattoo_designer_slider_hide_show',array(
       'default' => false,
       'sanitize_callback'	=> 'bodyart_tattoo_designer_sanitize_checkbox'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_slider_hide_show',array(
	   'type' => 'checkbox',
	   'description' => __( 'Click on the checkbox to enable slider.', 'bodyart-tattoo-designer' ),
	   'label' => esc_html__('Show / Hide slider','bodyart-tattoo-designer'),
	   'section' => 'bodyart_tattoo_designer_slidersettings',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'bodyart_tattoo_designer_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'bodyart_tattoo_designer_slider_page' . $count, array(
			'label'    => esc_html__( 'Select Slider Page', 'bodyart-tattoo-designer' ),
			'section'  => 'bodyart_tattoo_designer_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting( 'bodyart_tattoo_designerslider_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerslider_title_color', array(
		'label' => __('Title Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_slidersettings',
		'settings' => 'bodyart_tattoo_designerslider_title_color',
	)));


	// feature Settings
	$wp_customize->add_section('bodyart_tattoo_designer_feature_section',array(
		'title'	=> __('Feature Settings','bodyart-tattoo-designer'),
		'panel' => 'bodyart_tattoo_designer_panel_id',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_featureheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_featureheading',array(
		'label'	=> __('Heading','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_featurenum',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_featurenum',array(
		'label'	=> __('Number','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_featurenum',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_featurenum',array(
		'label'	=> __('Number','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_featurenumtext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_featurenumtext',array(
		'label'	=> __('Number Text','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_featuredescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_featuredescription',array(
		'label'	=> __('Description','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_btntext',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_btntext',array(
		'label'	=> __('Button Text','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_btnlink',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_btnlink',array(
		'label'	=> __('Button Link','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));
	

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_selected_page1', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_feature_selected_page1', array(
		'label'    => esc_html__('Select Page 1 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_feature_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_page_icon1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_page_icon1',array(
		'label'	=> __('Page 1 Icon','bodyart-tattoo-designer'),
		'description'	=> __('Add Like this "fa-solid fa-pencil"','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_selected_page2', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_feature_selected_page2', array(
		'label'    => esc_html__('Select Page 2 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_feature_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_page_icon2',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_page_icon2',array(
		'label'	=> __('Page 2 Icon','bodyart-tattoo-designer'),
		'description'	=> __('Add Like this "fa-solid fa-pencil"','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_selected_page3', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_feature_selected_page3', array(
		'label'    => esc_html__('Select Page 3 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_feature_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_page_icon3',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_page_icon3',array(
		'label'	=> __('Page 3 Icon','bodyart-tattoo-designer'),
		'description'	=> __('Add Like this "fa-solid fa-pencil"','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_selected_page4', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_feature_selected_page4', array(
		'label'    => esc_html__('Select Page 4 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_feature_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_feature_page_icon4',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_feature_page_icon4',array(
		'label'	=> __('Page 4 Icon','bodyart-tattoo-designer'),
		'description'	=> __('Add Like this "fa-solid fa-pencil"','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_heading_color', array(
		'label' => __('Heading Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_heading_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_number_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_number_color', array(
		'label' => __('Number Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_number_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_description_color', array(
		'label' => __('Description Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_description_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_btntext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_btntext_color', array(
		'label' => __('Button Text Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_btntext_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_btnbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_btnbg_color', array(
		'label' => __('Button BG Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_btnbg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_btntexthrv_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_btntexthrv_color', array(
		'label' => __('Button Text Hover Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_btntexthrv_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_boxtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_boxtitle_color', array(
		'label' => __('Box Title Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_boxtitle_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_boxdescription_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_boxdescription_color', array(
		'label' => __('Box Description Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_boxdescription_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_boxicon_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_boxicon_color', array(
		'label' => __('Box Icon Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_boxicon_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfeature_boxreadmore_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfeature_boxreadmore_color', array(
		'label' => __('Box Read More Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_feature_section',
		'settings' => 'bodyart_tattoo_designerfeature_boxreadmore_color',
	)));



	// project Settings
	$wp_customize->add_section('bodyart_tattoo_designer_project_section',array(
		'title'	=> __('Project Settings','bodyart-tattoo-designer'),
		'panel' => 'bodyart_tattoo_designer_panel_id',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_selected_page1', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_selected_page1', array(
		'label'    => esc_html__('Select Page 1 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_project_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_selected_page2', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_selected_page2', array(
		'label'    => esc_html__('Select Page 2 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_project_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_selected_page3', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_selected_page3', array(
		'label'    => esc_html__('Select Page 3 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_project_section',
		'type'     => 'dropdown-pages',
	));
	
	$wp_customize->add_setting( 'bodyart_tattoo_designerproject_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerproject_title_color', array(
		'label' => __('Title Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_project_section',
		'settings' => 'bodyart_tattoo_designerproject_title_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerproject_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerproject_description_color', array(
		'label' => __('Description Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_project_section',
		'settings' => 'bodyart_tattoo_designerproject_description_color',
	)));




	// Services Settings
	$wp_customize->add_section('bodyart_tattoo_designer_services_section',array(
		'title'	=> __('Services Settings','bodyart-tattoo-designer'),
		'panel' => 'bodyart_tattoo_designer_panel_id',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_servicedescription',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_servicedescription',array(
		'label'	=> __('Description','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_btn_serviceheading',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_btn_serviceheading',array(
		'label'	=> __('Heading','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'type'	 => 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_services_selected_page1', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_services_selected_page1', array(
		'label'    => esc_html__('Select Page 1 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_services_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_services_selected_page2', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_services_selected_page2', array(
		'label'    => esc_html__('Select Page 2 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_services_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_services_selected_page3', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_services_selected_page3', array(
		'label'    => esc_html__('Select Page 3 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_services_section',
		'type'     => 'dropdown-pages',
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_services_selected_page4', array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('bodyart_tattoo_designer_services_selected_page4', array(
		'label'    => esc_html__('Select Page 4 to Display', 'bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_services_section',
		'type'     => 'dropdown-pages',
	));
	

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_description_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_description_color', array(
		'label' => __('Description Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_description_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_heading_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_heading_color', array(
		'label' => __('Heading Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_heading_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_headingbrd_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_headingbrd_color', array(
		'label' => __('Border Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_headingbrd_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_boxnum_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_boxnum_color', array(
		'label' => __('Box Number Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_boxnum_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_boxtitle_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_boxtitle_color', array(
		'label' => __('Box Title Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_boxtitle_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerservices_boxtitlehover_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerservices_boxtitlehover_color', array(
		'label' => __('Box Title Hover Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_services_section',
		'settings' => 'bodyart_tattoo_designerservices_boxtitlehover_color',
	)));


	//footer
	$wp_customize->add_section('bodyart_tattoo_designer_footer_section',array(
		'title'	=> esc_html__('Footer Settings','bodyart-tattoo-designer'),
		'panel' => 'bodyart_tattoo_designer_panel_id'
	));
		
	$wp_customize->add_setting('bodyart_tattoo_designer_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('bodyart_tattoo_designer_footer_copy',array(
		'label'	=> esc_html__('Copyright Text','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('bodyart_tattoo_designer_footer_copy_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_footer_copy_font_size',array(
		'label'	=> __('Copyright Font Size','bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'type'	 => 'number'
	));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfooter_copyrighttext_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfooter_copyrighttext_color', array(
		'label' => __('Copyright Text Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designerfooter_copyrighttext_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfooter_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfooter_copyrightbg_color', array(
		'label' => __('Copyright BG Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designerfooter_copyrightbg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designerfooter_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designerfooter_bg_color', array(
		'label' => __('BG Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designerfooter_bg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_wedgets_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_wedgets_color', array(
		'label' => __('Wedgets Title Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designer_wedgets_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_wedgets_menus_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_wedgets_menus_color', array(
		'label' => __('Wedgets Menus Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designer_wedgets_menus_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_wedgets_text_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_wedgets_text_color', array(
		'label' => __('Wedgets Text Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_footer_section',
		'settings' => 'bodyart_tattoo_designer_wedgets_text_color',
	)));


	//Wocommerce Shop Page
	$wp_customize->add_section('bodyart_tattoo_designer_woocommerce_shop_page',array(
		'title'	=> __('Woocommerce Shop Page','bodyart-tattoo-designer'),
		'panel' => 'bodyart_tattoo_designer_panel_id'
	));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_products_per_column' , array(
		'default'           => 3,
		'transport'         => 'refresh',
		'sanitize_callback' => 'bodyart_tattoo_designer_sanitize_choices',
	) );
	$wp_customize->add_control( 'bodyart_tattoo_designer_products_per_column', array(
		'label'    => __( 'Product Per Columns', 'bodyart-tattoo-designer' ),
		'description'	=> __('How many products should be shown per Column?','bodyart-tattoo-designer'),
		'section'  => 'bodyart_tattoo_designer_woocommerce_shop_page',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('bodyart_tattoo_designer_products_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'bodyart_tattoo_designer_sanitize_float',
	));	
	$wp_customize->add_control('bodyart_tattoo_designer_products_per_page',array(
		'label'	=> __('Product Per Page','bodyart-tattoo-designer'),
		'description'	=> __('How many products should be shown per page?','bodyart-tattoo-designer'),
		'section'	=> 'bodyart_tattoo_designer_woocommerce_shop_page',
		'type'		=> 'number'
	));

	

	$wp_customize->add_setting( 'bodyart_tattoo_designer_product_btn_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_product_btn_bg_color', array(
		'label' => __('Button Background Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_woocommerce_shop_page',
		'settings' => 'bodyart_tattoo_designer_product_btn_bg_color',
	)));

	
	$wp_customize->add_setting( 'bodyart_tattoo_designer_product_btn_hover_bg_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_product_btn_hover_bg_color', array(
		'label' => __('Button Hover Background Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_woocommerce_shop_page',
		'settings' => 'bodyart_tattoo_designer_product_btn_hover_bg_color',
	)));

	$wp_customize->add_setting( 'bodyart_tattoo_designer_product_sale_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_product_sale_color', array(
		'label' => __('Sale Badge Color', 'bodyart-tattoo-designer'),
		'section' => 'bodyart_tattoo_designer_woocommerce_shop_page',
		'settings' => 'bodyart_tattoo_designer_product_sale_color',
	)));

	// site logo size
	$wp_customize->add_setting('bodyart_tattoo_designer_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'bodyart_tattoo_designer_sanitize_float'
	));
	$wp_customize->add_control('bodyart_tattoo_designer_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','bodyart-tattoo-designer'),
		'section' => 'title_tagline'
	));

	// logo site title
	$wp_customize->add_setting('bodyart_tattoo_designer_site_title_tagline',array(
       'default' => true,
       'sanitize_callback'	=> 'bodyart_tattoo_designer_sanitize_checkbox'
    ));
    $wp_customize->add_control('bodyart_tattoo_designer_site_title_tagline',array(
       'type' => 'checkbox',
       'label' => __('Display Site Title and Tagline in Header','bodyart-tattoo-designer'),
       'section' => 'title_tagline'
    ));

    $wp_customize->add_setting( 'bodyart_tattoo_designer_site_title_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_site_title_color', array(
		'label' => __('Site Title Color', 'bodyart-tattoo-designer'),
		'section' => 'title_tagline',
		'settings' => 'bodyart_tattoo_designer_site_title_color',
	)));

    $wp_customize->add_setting( 'bodyart_tattoo_designer_site_tagline_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bodyart_tattoo_designer_site_tagline_color', array(
		'label' => __('Site Tagline Color', 'bodyart-tattoo-designer'),
		'section' => 'title_tagline',
		'settings' => 'bodyart_tattoo_designer_site_tagline_color',
	)));
}
add_action( 'customize_register', 'bodyart_tattoo_designer_customize_register' );