<?php
/**
 * Display Header.
 * @package Bodyart Tattoo Designer
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Rye&family=Sancreek&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Rye&family=Sancreek&display=swap" rel="stylesheet">


	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<header role="banner" class="banner">
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'bodyart-tattoo-designer' ); ?></a>
		<div id="header">
			<div class="header-box">
				<div class="top-head ">
					<div class="container">	
						<div class="row">
							<div class="col-lg-4 col-md-6 col-sm-6 col-8 logobx_m">
								<div class="logobx">
									<!-- <div class="logobxinn"></div> -->
									<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
								</div>
							</div>
							<div class="col-lg-8 col-md-6 col-sm-6 col-4 m_txt">			
								<div class="bottom-head">
									<div class="row mr-0">
										<div class="menu-section text-lg-center">
											<div class="<?php if( get_theme_mod( 'bodyart_tattoo_designer_sticky_header', false) != '') { ?>sticky-menubox<?php } else { ?>close-sticky <?php } ?>">
												<?php get_template_part( 'template-parts/navigation/site', 'nav' ); ?>
											</div>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<?php if(is_singular()) {?>
		<div class="inner-head">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6 align-self-center">
						<div class="header-content">
							<h1><?php single_post_title(); ?></h1>
							<div class="lt-breadcrumbs">
								<?php bodyart_tattoo_designer_breadcrumb(); ?>
							</div>
						</div>
					</div>
					<?php if(has_post_thumbnail()){?>
						<div class="col-lg-6 col-md-6 align-self-end">
							
						</div>
					<?php }?>
				</div>
				
			</div>
		</div>
	<?php }?>